/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ShulkerBoxUtils;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int g;
    public int h;
    public int i = 5;
    @Nullable
    public UUID j;
    @Nullable
    public UUID k;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.af.i() * (float)Math.PI * 2.0f;
        this.a_(this.af.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        ItemBlock bi;
        Item item;
        this.e(x2, y2, z2);
        if (LeavesConfig.useVanillaRandom) {
            this.o(world.z.j() * 0.2 - 0.1, 0.2, world.z.j() * 0.2 - 0.1);
        } else {
            this.o(this.af.j() * 0.2 - 0.1, 0.2, this.af.j() * 0.2 - 0.1);
        }
        this.a(stack);
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.d()) instanceof ItemBlock && (bi = (ItemBlock)item).e() instanceof BlockShulkerBox) {
            ShulkerBoxUtils.cleanUpShulkerBoxTag(stack);
        }
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        this.e(x2, y2, z2);
        this.o(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.ae(), entity.dI());
        this.a(entity.j().p());
        this.s(entity);
        this.g = entity.g;
        this.b = entity.b;
    }

    @Override
    public boolean aT() {
        return this.j().a(TagsItem.aB);
    }

    @Override
    @Nullable
    public Entity v() {
        World world;
        if (this.j != null && (world = this.dI()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return worldserver.a(this.j);
        }
        return null;
    }

    @Override
    protected Entity.MovementEmission aS() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.aj().a(c, ItemStack.b);
    }

    @Override
    public void l() {
        if (this.j().b()) {
            this.ai();
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.h != Short.MAX_VALUE) {
                this.h -= elapsedTicks;
            }
            this.h = Math.max(0, this.h);
            if (this.g != Short.MIN_VALUE) {
                this.g += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.J = this.dn();
            this.K = this.dp();
            this.L = this.dt();
            Vec3D vec3d = this.dl();
            float f2 = this.cF() - 0.11111111f;
            if (this.aV() && this.b(TagsFluid.a) > (double)f2) {
                this.y();
            } else if (this.bi() && this.b(TagsFluid.b) > (double)f2) {
                this.z();
            } else if (!this.aR()) {
                this.f(this.dl().b(0.0, -0.04, 0.0));
            }
            if (this.dI().B) {
                this.ae = false;
            } else {
                boolean bl = this.ae = !this.dI().a((Entity)this, this.cE().h(1.0E-7));
                if (this.ae) {
                    this.m(this.dn(), (this.cE().b + this.cE().e) / 2.0, this.dt());
                }
            }
            if (!this.ay() || this.dl().i() > (double)1.0E-5f || (this.ag + this.af()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dl());
                float f1 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f1 = 1.0f;
                } else if (this.ay()) {
                    f1 = this.dI().a_(this.aE()).b().h() * 0.98f;
                }
                this.f(this.dl().d(f1, 0.98, f1));
                if (this.ay()) {
                    Vec3D vec3d1 = this.dl();
                    if (vec3d1.d < 0.0) {
                        this.f(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.J) != MathHelper.a(this.dn()) || MathHelper.a(this.K) != MathHelper.a(this.dp()) || MathHelper.a(this.L) != MathHelper.a(this.dt());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ag % i2 == 0 && !this.dI().B && this.C()) {
                this.A();
            }
            this.at |= this.bb();
            if (!this.dI().B && (d0 = this.dl().d(vec3d).g()) > 0.01) {
                this.at = true;
            }
            if (!this.dI().B && this.g >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.g = 0;
                    return;
                }
                this.ai();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.h != Short.MAX_VALUE) {
            this.h -= elapsedTicks;
        }
        this.h = Math.max(0, this.h);
        if (this.g != Short.MIN_VALUE) {
            this.g += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dI().B && this.g >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.g = 0;
                return;
            }
            this.ai();
        }
    }

    @Override
    protected BlockPosition aE() {
        return this.d(0.999999f);
    }

    private void y() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void z() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void A() {
        if (this.C()) {
            double radius = this.dI().spigotConfig.itemMerge;
            List<EntityItem> list = this.dI().a(EntityItem.class, this.cE().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.C());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.C() || this.dI().paperConfig().fixes.fixItemsMergingThroughWalls && this.dI().clipDirect(this.dg(), entityitem2.dg(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dD()) continue;
                break;
            }
        }
    }

    private boolean C() {
        ItemStack itemstack = this.j();
        return this.bs() && this.h != Short.MAX_VALUE && this.g != Short.MIN_VALUE && this.g < this.despawnRate && itemstack.L() < ShulkerBoxUtils.getItemStackMaxCount(itemstack);
    }

    private boolean tryStackShulkerBoxes(EntityItem other) {
        ItemBlock bi;
        Item item;
        ItemStack selfStack = this.j();
        if (LeavesConfig.shulkerBoxStackSize == 1 || !((item = selfStack.d()) instanceof ItemBlock) || !((bi = (ItemBlock)item).e() instanceof BlockShulkerBox)) {
            return false;
        }
        ItemStack otherStack = other.j();
        if (selfStack.d() == otherStack.d() && !ShulkerBoxUtils.shulkerBoxHasItems(selfStack) && !ShulkerBoxUtils.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.v(), otherStack.v()) && selfStack.L() != LeavesConfig.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.L(), LeavesConfig.shulkerBoxStackSize - selfStack.L());
            selfStack.g(amount);
            this.a(selfStack);
            this.h = Math.max(other.h, this.h);
            this.g = Math.min(other.k(), this.g);
            otherStack.h(amount);
            if (otherStack.b()) {
                other.ai();
            } else {
                other.a(otherStack);
            }
            return true;
        }
        return false;
    }

    private void a(EntityItem other) {
        if (this.tryStackShulkerBoxes(other)) {
            return;
        }
        ItemStack itemstack = this.j();
        ItemStack itemstack1 = other.j();
        if (Objects.equals(this.k, other.k) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return !stack2.a(stack1.d()) ? false : (stack2.L() + stack1.L() > stack2.g() ? false : (stack2.u() ^ stack1.u() ? false : !stack2.u() || stack2.v().equals(stack1.v())));
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.g(), maxCount) - stack1.L(), stack2.L());
        ItemStack itemstack2 = stack1.c(stack1.L() + j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        if (!itemstack2.b()) {
            targetEntity.a(itemstack2);
        }
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.h = Math.max(targetEntity.h, sourceEntity.h);
        targetEntity.g = Math.min(targetEntity.g, sourceEntity.g);
        if (sourceStack.b()) {
            sourceEntity.ai();
        }
    }

    @Override
    public boolean aU() {
        return this.j().d().w() || super.aU();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.j().b() && this.j().a(Items.ty) && source.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.j().d().a(source)) {
            return false;
        }
        if (this.dI().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bl();
        this.i = (int)((float)this.i - amount);
        this.a(GameEvent.o, source.d());
        if (this.i <= 0) {
            this.j().a(this);
            this.ai();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.i);
        nbt.a("Age", (short)this.g);
        nbt.a("PickupDelay", (short)this.h);
        if (this.j != null) {
            nbt.a("Thrower", this.j);
        }
        if (this.k != null) {
            nbt.a("Owner", this.k);
        }
        if (!this.j().b()) {
            nbt.a("Item", this.j().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.i = nbt.g("Health");
        this.g = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.h = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.k = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.j = nbt.a("Thrower");
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + this);
            }
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.j().b()) {
            this.ai();
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dI().B) {
            ItemStack itemstack = this.j();
            Item item = itemstack.d();
            int i2 = itemstack.L();
            int canHold = player.fN().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.h <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dI().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.h <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.f(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dI().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.f(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dI().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                ItemStack current = this.j();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.f(canHold + remaining);
                }
                this.h = 0;
            } else if (this.h == 0) {
                this.h = -1;
            }
            if (this.h == 0 && (this.k == null || this.k.equals(player.ct())) && player.fN().e(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.b()) {
                    this.ai();
                    itemstack.f(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.j().q());
    }

    @Override
    public boolean cn() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = super.b(destination);
        if (!this.dI().B && entity instanceof EntityItem) {
            ((EntityItem)entity).A();
        }
        return entity;
    }

    public ItemStack j() {
        return this.aj().b(c);
    }

    public void a(ItemStack stack) {
        this.aj().b(c, stack);
        this.despawnRate = this.dI().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dI().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.d(), this.dI().spigotConfig.itemDespawnRate) : this.dI().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.j().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.k = owner;
    }

    public void c(@Nullable UUID thrower) {
        this.j = thrower;
    }

    public int k() {
        return this.g;
    }

    public void o() {
        this.h = 10;
    }

    public void p() {
        this.h = 0;
    }

    public void q() {
        this.h = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.h = pickupDelay;
    }

    public boolean r() {
        return this.h > 0;
    }

    public void s() {
        this.g = Short.MIN_VALUE;
    }

    public void t() {
        this.g = -6000;
    }

    public void w() {
        this.q();
        this.g = this.despawnRate - 1;
    }

    public float a(float tickDelta) {
        return ((float)this.k() + tickDelta) / 20.0f + this.b;
    }

    public EntityItem x() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.i;
    }

    @Override
    public float dz() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }
}

