/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep e;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> type, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, world);
        this.bJ = 10;
    }

    @Override
    protected void x() {
        super.x();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new b());
        this.bO.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bO.a(4, new c());
        this.bO.a(5, new a());
        this.bO.a(6, new d());
        this.bO.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder r() {
        return EntityMonster.ge().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 12.0).a(GenericAttributes.a, 24.0);
    }

    @Override
    protected void a_() {
        super.a_();
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
    }

    @Override
    public SoundEffect Y_() {
        return SoundEffects.hs;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
    }

    @Override
    protected void W() {
        super.W();
    }

    @Override
    public boolean p(Entity other) {
        return other == null ? false : (other == this ? true : (super.p(other) ? true : (other instanceof EntityVex ? this.p(((EntityVex)other).r()) : (other instanceof EntityLiving && ((EntityLiving)other).eN() == EnumMonsterType.d ? this.cd() == null && other.cd() == null : false))));
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.hq;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.ht;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.hv;
    }

    public void a(@Nullable EntitySheep wololoTarget) {
        this.e = wololoTarget;
    }

    @Nullable
    public EntitySheep gr() {
        return this.e;
    }

    @Override
    protected SoundEffect fY() {
        return SoundEffects.hr;
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    private class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void e() {
            if (EntityEvoker.this.j() != null) {
                EntityEvoker.this.E().a(EntityEvoker.this.j(), (float)EntityEvoker.this.fC(), (float)EntityEvoker.this.X());
            } else if (EntityEvoker.this.gr() != null) {
                EntityEvoker.this.E().a(EntityEvoker.this.gr(), (float)EntityEvoker.this.fC(), (float)EntityEvoker.this.X());
            }
        }
    }

    private class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean a() {
            if (!super.a()) {
                return false;
            }
            int i2 = EntityEvoker.this.dI().a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cE().g(16.0)).size();
            return EntityEvoker.this.af.a(8) + 1 > i2;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer worldserver = (WorldServer)EntityEvoker.this.dI();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition = EntityEvoker.this.di().b(-2 + EntityEvoker.this.af.a(5), 1, -2 + EntityEvoker.this.af.a(5));
                EntityVex entityvex = EntityTypes.be.a(EntityEvoker.this.dI());
                if (entityvex == null) continue;
                entityvex.a(blockposition, 0.0f, 0.0f);
                entityvex.a(worldserver, EntityEvoker.this.dI().d_(blockposition), EnumMobSpawn.f, (GroupDataEntity)null, null);
                entityvex.a(EntityEvoker.this);
                entityvex.i(blockposition);
                entityvex.b(20 * (30 + EntityEvoker.this.af.a(90)));
                worldserver.addFreshEntityWithPassengers(entityvex, CreatureSpawnEvent.SpawnReason.SPELL);
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.hx;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving entityliving = EntityEvoker.this.j();
            double d0 = Math.min(entityliving.dp(), EntityEvoker.this.dp());
            double d1 = Math.max(entityliving.dp(), EntityEvoker.this.dp()) + 1.0;
            float f2 = (float)MathHelper.d(entityliving.dt() - EntityEvoker.this.dt(), entityliving.dn() - EntityEvoker.this.dn());
            if (EntityEvoker.this.f((Entity)entityliving) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dn() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dt() + (double)MathHelper.a(f1) * 1.5, d0, d1, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dn() + (double)MathHelper.b(f1) * 2.5, EntityEvoker.this.dt() + (double)MathHelper.a(f1) * 2.5, d0, d1, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d2 = 1.25 * (double)(i3 + 1);
                    int j2 = 1 * i3;
                    this.a(EntityEvoker.this.dn() + (double)MathHelper.b(f2) * d2, EntityEvoker.this.dt() + (double)MathHelper.a(f2) * d2, d0, d1, f2, j2);
                }
            }
        }

        private void a(double x2, double z2, double maxY, double y2, float yaw, int warmup) {
            BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
            boolean flag = false;
            double d4 = 0.0;
            do {
                IBlockData iblockdata1;
                VoxelShape voxelshape;
                BlockPosition blockposition1 = blockposition.d();
                IBlockData iblockdata = EntityEvoker.this.dI().a_(blockposition1);
                if (!iblockdata.d(EntityEvoker.this.dI(), blockposition1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.dI().t(blockposition) && !(voxelshape = (iblockdata1 = EntityEvoker.this.dI().a_(blockposition)).k(EntityEvoker.this.dI(), blockposition)).b()) {
                    d4 = voxelshape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockposition = blockposition.d()).v() >= MathHelper.a(maxY) - 1);
            if (flag) {
                EntityEvoker.this.dI().b(new EntityEvokerFangs(EntityEvoker.this.dI(), x2, (double)blockposition.v() + d4, z2, yaw, warmup, EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.hw;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entityliving) -> ((EntitySheep)entityliving).r() == EnumColor.l);
        }

        @Override
        public boolean a() {
            if (EntityEvoker.this.j() != null) {
                return false;
            }
            if (EntityEvoker.this.gi()) {
                return false;
            }
            if (EntityEvoker.this.ag < this.c) {
                return false;
            }
            if (!EntityEvoker.this.dI().X().b(GameRules.c)) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.dI().a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cE().c(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(list.get(EntityEvoker.this.af.a(list.size())));
            return true;
        }

        @Override
        public boolean b() {
            return EntityEvoker.this.gr() != null && this.b > 0;
        }

        @Override
        public void d() {
            super.d();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep entitysheep = EntityEvoker.this.gr();
            if (entitysheep != null && entitysheep.bs()) {
                entitysheep.b(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.hy;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

