/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int e = 5;
    private static final int bT = 300;
    private static final float bU = 1.6f;
    public final InventorySubcontainer bV = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World world) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, world);
    }

    @Override
    @Override
    protected void x() {
        super.x();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(2, new EntityRaider.a(this, this, 10.0f));
        this.bO.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder r() {
        return EntityMonster.ge().a(GenericAttributes.d, 0.35f).a(GenericAttributes.a, 24.0).a(GenericAttributes.f, 5.0).a(GenericAttributes.b, 32.0);
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, false);
    }

    @Override
    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.uZ;
    }

    public boolean fY() {
        return this.am.b(b);
    }

    @Override
    @Override
    public void b(boolean charging) {
        this.am.b(b, charging);
    }

    @Override
    @Override
    public void a() {
        this.bc = 0;
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.a_(nbt);
    }

    @Override
    @Override
    public EntityIllagerAbstract.a q() {
        if (this.fY()) {
            return EntityIllagerAbstract.a.f;
        }
        if (this.b(Items.uZ)) {
            return EntityIllagerAbstract.a.e;
        }
        if (this.fS()) {
            return EntityIllagerAbstract.a.b;
        }
        return EntityIllagerAbstract.a.h;
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.c(nbt);
        this.s(true);
    }

    @Override
    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    @Override
    public int fE() {
        return 1;
    }

    @Override
    @Nullable
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomSource = world.y_();
        this.a(randomSource, difficulty);
        this.b(randomSource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.uZ));
    }

    @Override
    @Override
    protected void a(RandomSource random, float power) {
        ItemStack itemStack;
        super.a(random, power);
        if (random.a(300) == 0 && (itemStack = this.eO()).a(Items.uZ)) {
            Map<Enchantment, Integer> map = EnchantmentManager.a(itemStack);
            map.putIfAbsent(Enchantments.K, 1);
            EnchantmentManager.a(map, itemStack);
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    @Override
    public boolean p(Entity other) {
        if (super.p(other)) {
            return true;
        }
        if (other instanceof EntityLiving && ((EntityLiving)other).eN() == EnumMonsterType.d) {
            return this.cd() == null && other.cd() == null;
        }
        return false;
    }

    @Override
    @Override
    protected SoundEffect s() {
        return SoundEffects.sj;
    }

    @Override
    @Override
    public SoundEffect g_() {
        return SoundEffects.sl;
    }

    @Override
    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.sm;
    }

    @Override
    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    @Override
    public InventorySubcontainer w() {
        return this.bV;
    }

    @Override
    @Override
    protected void b(EntityItem item) {
        ItemStack itemStack = item.j();
        if (itemStack.d() instanceof ItemBanner) {
            super.b(item);
        } else if (this.l(itemStack)) {
            this.a(item);
            ItemStack itemStack2 = this.bV.a(itemStack);
            if (itemStack2.b()) {
                item.ai();
            } else {
                itemStack.f(itemStack2.L());
            }
        }
    }

    private boolean l(ItemStack stack) {
        return this.gn() && stack.a(Items.tV);
    }

    @Override
    @Override
    public SlotAccess a_(int mappedIndex) {
        int i2 = mappedIndex - 300;
        if (i2 >= 0 && i2 < this.bV.b()) {
            return SlotAccess.a(this.bV, i2);
        }
        return super.a_(mappedIndex);
    }

    @Override
    @Override
    public void a(int wave, boolean unused) {
        boolean bl;
        Raid raid = this.gm();
        boolean bl2 = bl = this.af.i() <= raid.w();
        if (bl) {
            ItemStack itemStack = new ItemStack(Items.uZ);
            HashMap map = Maps.newHashMap();
            if (wave > raid.a(EnumDifficulty.c)) {
                map.put(Enchantments.J, 2);
            } else if (wave > raid.a(EnumDifficulty.b)) {
                map.put(Enchantments.J, 1);
            }
            map.put(Enchantments.I, 1);
            EnchantmentManager.a(map, itemStack);
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    @Override
    public SoundEffect Y_() {
        return SoundEffects.sk;
    }
}

