/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bZ = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> ca = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int bV = 12;
    public static final Map<Item, Integer> bW = ImmutableMap.of((Object)Items.oJ, (Object)4, (Object)Items.tm, (Object)1, (Object)Items.tl, (Object)1, (Object)Items.uq, (Object)1);
    private static final int cb = 2;
    private static final Set<Item> cc = ImmutableSet.of((Object)Items.oJ, (Object)Items.tm, (Object)Items.tl, (Object)Items.oI, (Object)Items.oH, (Object)Items.uq, (Object[])new Item[]{Items.ur, Items.uo, Items.up});
    private static final int cd = 10;
    private static final int ce = 1200;
    private static final int cf = 24000;
    private static final int cg = 25;
    private static final int ch = 10;
    private static final int ci = 5;
    private static final long cj = 24000L;
    @VisibleForTesting
    public static final float bX = 0.5f;
    private int ck;
    private boolean cl;
    @Nullable
    private EntityHuman cm;
    private boolean cn;
    private int co;
    private final Reputation cp = new Reputation();
    private long cq;
    private long cr;
    private int cs;
    private long ct;
    public int cu;
    private long cv;
    private boolean cw;
    private static final ImmutableList<MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.K, MemoryModuleType.aO, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.G, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cy = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bY = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gj().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world) {
        this(entityType, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world, VillagerType type) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, world);
        ((Navigation)this.J()).b(true);
        this.J().a(true);
        this.s(true);
        this.a(this.gj().a(type).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> dK() {
        return super.dK();
    }

    protected BehaviorController.b<EntityVillager> dL() {
        return BehaviorController.a(cx, cy);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dL().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void c(WorldServer world) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dK();
        behaviorcontroller.b(world, this);
        this.bA = behaviorcontroller.i();
        this.a(this.dK());
    }

    @Override
    private void a(BehaviorController<EntityVillager> brain) {
        VillagerProfession villagerprofession = this.gj().b();
        if (this.h_()) {
            brain.a(Schedule.e);
            brain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            brain.a(Schedule.f);
            brain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        brain.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        brain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        brain.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        brain.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        brain.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        brain.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        brain.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        brain.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.a(Activity.b);
        brain.a(this.dI().W(), this.dI().V());
    }

    @Override
    protected void m() {
        super.m();
        if (this.dI() instanceof WorldServer) {
            this.c((WorldServer)this.dI());
        }
    }

    public static AttributeProvider.Builder gh() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 48.0);
    }

    public boolean gi() {
        return this.cw;
    }

    @Override
    public void inactiveTick() {
        if (this.q() > 0) {
            this.s(this.q() - 1);
        }
        if (this.cV()) {
            if (this.dI().spigotConfig.tickInactiveVillagers) {
                this.W();
            } else {
                this.customServerAiStep(true);
            }
        }
        this.gH();
        super.inactiveTick();
    }

    @Override
    @Deprecated
    protected void W() {
        this.customServerAiStep(false);
    }

    protected void customServerAiStep(boolean inactive) {
        Raid raid;
        this.dI().ad().a("villagerBrain");
        if (!inactive) {
            this.dK().a((WorldServer)this.dI(), this);
        }
        this.dI().ad().c();
        if (this.cw) {
            this.cw = false;
        }
        if (!this.fZ() && this.ck > 0) {
            --this.ck;
            if (this.ck <= 0) {
                if (this.cl) {
                    this.gF();
                    this.cl = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cm != null && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(ReputationEvent.e, (Entity)this.cm, this);
            this.dI().a((Entity)this, (byte)14);
            this.cm = null;
        }
        if (!inactive && !this.fQ() && this.af.a(100) == 0 && (raid = ((WorldServer)this.dI()).c(this.di())) != null && raid.v() && !raid.a()) {
            this.dI().a((Entity)this, (byte)42);
        }
        if (this.gj().b() == VillagerProfession.b && this.fZ()) {
            this.ge();
        }
        if (inactive) {
            return;
        }
        super.W();
    }

    @Override
    public void l() {
        super.l();
        if (this.q() > 0) {
            this.s(this.q() - 1);
        }
        this.gH();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.sR) && this.bs() && !this.fZ() && !this.fy()) {
            if (this.h_()) {
                this.gu();
                return EnumInteractionResult.a(this.dI().B);
            }
            boolean flag = this.ga().isEmpty();
            if (hand == EnumHand.a) {
                if (flag && !this.dI().B) {
                    this.gu();
                }
                player.a(StatisticList.S);
            }
            if (flag) {
                return EnumInteractionResult.a(this.dI().B);
            }
            if (!this.dI().B && !this.bU.isEmpty()) {
                this.h(player);
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        return super.b(player, hand);
    }

    public void gu() {
        this.s(40);
        if (!this.dI().r_()) {
            this.a(SoundEffects.yF, this.eR(), this.eS());
        }
    }

    private void h(EntityHuman customer) {
        this.voidTrade = false;
        this.i(customer);
        this.f(customer);
        this.a(customer, this.H_(), this.gj().c());
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        boolean flag = this.fY() != null && customer == null;
        super.f(customer);
        if (flag) {
            this.ge();
        }
    }

    @Override
    protected void ge() {
        super.ge();
        this.gv();
    }

    private void gv() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            merchantrecipe.l();
        }
    }

    @Override
    public boolean gk() {
        return true;
    }

    @Override
    public boolean gg() {
        return this.dI().B;
    }

    public void gl() {
        this.gA();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.h();
        }
        this.gw();
        this.ct = this.dI().V();
        ++this.cu;
    }

    private void gw() {
        MerchantRecipeList merchantrecipelist = this.ga();
        EntityHuman entityhuman = this.fY();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.bR.j, merchantrecipelist, this.gj().c(), this.r(), this.gb(), this.gk());
        }
    }

    private boolean gx() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.ga().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).r());
        return true;
    }

    private boolean gy() {
        return this.cu == 0 || this.cu < 2 && this.dI().V() > this.ct + 2400L;
    }

    public boolean gm() {
        long i2 = this.ct + 12000L;
        long j2 = this.dI().V();
        boolean flag = j2 > i2;
        long k2 = this.dI().W();
        if (this.cv > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cv / 24000L;
            flag |= i1 > l2;
        }
        this.cv = k2;
        if (flag) {
            this.ct = j2;
            this.gI();
        }
        return this.gy() && this.gx();
    }

    private void gz() {
        int i2 = 2 - this.cu;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.h();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gA();
        }
        this.gw();
    }

    private void gA() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            merchantrecipe.e();
        }
    }

    private void i(EntityHuman player) {
        int i2 = this.g(player);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
                if (merchantrecipe.ignoreDiscounts) continue;
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.n()));
            }
        }
        if (player.a(MobEffects.F)) {
            MobEffect mobeffect = player.b(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.ga()) {
                if (merchantrecipe1.ignoreDiscounts) continue;
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().L());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(ca, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gj());
        Logger logger = bZ;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        nbt.a("FoodLevel", (byte)this.co);
        nbt.a("Gossips", this.cp.a(DynamicOpsNBT.a));
        nbt.a("Xp", this.cs);
        nbt.a("LastRestock", this.ct);
        nbt.a("LastGossipDecay", this.cr);
        nbt.a("RestocksToday", this.cu);
        if (this.cw) {
            nbt.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = bZ;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbt.p("Offers"));
        }
        if (nbt.b("FoodLevel", 1)) {
            this.co = nbt.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbt.c("Gossips", 10);
        this.cp.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbttaglist));
        if (nbt.b("Xp", 3)) {
            this.cs = nbt.h("Xp");
        }
        this.ct = nbt.i("LastRestock");
        this.cr = nbt.i("LastGossipDecay");
        this.s(true);
        if (this.dI() instanceof WorldServer) {
            this.c((WorldServer)this.dI());
        }
        this.cu = nbt.h("RestocksToday");
        if (nbt.e("AssignProfessionWhenSpawned")) {
            this.cw = nbt.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.fy() ? null : (this.fZ() ? SoundEffects.yG : SoundEffects.yB);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.yE;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.yD;
    }

    public void gn() {
        SoundEffect soundeffect = this.gj().b().f();
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gj();
        if (villagerdata1.b() != villagerData.b()) {
            this.bU = null;
        }
        this.am.b(ca, villagerData);
    }

    @Override
    public VillagerData gj() {
        return this.am.b(ca);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.af.a(4);
        if (!this.voidTrade) {
            this.cs += offer.o();
            this.cm = this.fY();
        }
        if (this.gE()) {
            this.ck = 40;
            this.cl = true;
            i2 += 5;
        }
        if (offer.s()) {
            this.dI().b(new EntityExperienceOrb(this.dI(), this.dn(), this.dp() + 0.5, this.dt(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.fY(), this));
        }
    }

    public void x(boolean flag) {
        this.cn = flag;
    }

    public boolean go() {
        return this.cn;
    }

    @Override
    public void a(@Nullable EntityLiving attacker) {
        if (attacker != null && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(ReputationEvent.c, (Entity)attacker, this);
            if (this.bs() && attacker instanceof EntityHuman) {
                this.dI().a((Entity)this, (byte)13);
            }
        }
        super.a(attacker);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bZ.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.a(entity);
        }
        this.gB();
        super.a(damageSource);
    }

    public void gB() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    @Override
    private void a(Entity killer) {
        World world = this.dI();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bA.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, killer, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> pos) {
        if (this.dI() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dI()).n();
            this.bA.c(pos).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.w();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = bY.get(pos);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean P_() {
        return this.co + this.gG() >= 12 && !this.fy() && this.h() == 0;
    }

    private boolean gC() {
        return this.co < 12;
    }

    private void gD() {
        if (this.gC() && this.gG() != 0) {
            for (int i2 = 0; i2 < this.w().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.w().a(i2);
                if (itemstack.b() || (integer = bW.get(itemstack.d())) == null) continue;
                for (int k2 = j2 = itemstack.L(); k2 > 0; --k2) {
                    this.co += integer.intValue();
                    this.w().a(i2, 1);
                    if (this.gC()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman player) {
        return this.cp.a(player.ct(), (ReputationType reputationtype) -> true);
    }

    private void v(int amount) {
        this.co -= amount;
    }

    public void gp() {
        this.gD();
        this.v(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bU = offers;
    }

    private boolean gE() {
        int i2 = this.gj().c();
        return VillagerData.d(i2) && this.cs >= VillagerData.c(i2);
    }

    public void gF() {
        this.a(this.gj().a(this.gj().c() + 1));
        this.gf();
    }

    @Override
    protected IChatBaseComponent cl() {
        String s2 = this.ae().g();
        return IChatBaseComponent.c(s2 + "." + BuiltInRegistries.A.b(this.gj().b()).a());
    }

    @Override
    public void b(byte status) {
        if (status == 12) {
            this.a(Particles.M);
        } else if (status == 13) {
            this.a(Particles.b);
        } else if (status == 14) {
            this.a(Particles.K);
        } else if (status == 42) {
            this.a(Particles.ag);
        } else {
            super.b(status);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (spawnReason == EnumMobSpawn.e) {
            this.a(this.gj().a(VillagerProfession.b));
        }
        if (spawnReason == EnumMobSpawn.n || spawnReason == EnumMobSpawn.m || spawnReason == EnumMobSpawn.c || spawnReason == EnumMobSpawn.o) {
            this.a(this.gj().a(VillagerType.a(world.s(this.di()))));
        }
        if (spawnReason == EnumMobSpawn.d) {
            this.cw = true;
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public EntityVillager b(WorldServer world, EntityAgeable entity) {
        double d0 = this.af.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(world.s(this.di())) : (d0 < 0.75 ? this.gj().a() : ((EntityVillager)entity).gj().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bf, world, villagertype);
        entityvillager.a(world, world.d_(entityvillager.di()), EnumMobSpawn.e, (GroupDataEntity)null, null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.ai() != EnumDifficulty.a) {
            EntityWitch entitywitch = EntityTypes.bj.a(world);
            if (entitywitch != null) {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, entitywitch).isCancelled()) {
                    return;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    bZ.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                entitywitch.b(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
                entitywitch.a(world, world.d_(entitywitch.di()), EnumMobSpawn.i, (GroupDataEntity)null, null);
                entitywitch.t(this.fQ());
                if (this.aa()) {
                    entitywitch.b(this.ab());
                    entitywitch.n(this.cy());
                }
                entitywitch.fF();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                    return;
                }
                world.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.gB();
                this.ai();
            } else {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void b(EntityItem item) {
        InventoryCarrier.a(this, this, item);
    }

    @Override
    public boolean k(ItemStack stack) {
        Item item = stack.d();
        return (cc.contains(item) || this.gj().b().d().contains((Object)item)) && this.w().b(stack);
    }

    public boolean gq() {
        return this.gG() >= 24;
    }

    public boolean gr() {
        return this.gG() < 12;
    }

    private int gG() {
        InventorySubcontainer inventorysubcontainer = this.w();
        return bW.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gs() {
        return this.w().a_((ItemStack itemstack) -> itemstack.a(TagsItem.aU));
    }

    @Override
    protected void gf() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        VillagerData villagerdata = this.gj();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.ga();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer world, EntityVillager villager, long time) {
        if (!(time >= this.cq && time < this.cq + 1200L || time >= villager.cq && time < villager.cq + 1200L)) {
            this.cp.a(villager.cp, this.af, 10);
            this.cq = time;
            villager.cq = time;
            this.a(world, time, 5);
        }
    }

    private void gH() {
        long i2 = this.dI().V();
        if (this.cr == 0L) {
            this.cr = i2;
        } else if (i2 >= this.cr + 24000L) {
            this.cp.b();
            this.cr = i2;
        }
    }

    public void a(WorldServer world, long time, int requiredCount) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(time) && (list1 = (list = world.a(EntityVillager.class, axisalignedbb = this.cE().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(time)).limit(5L).collect(Collectors.toList())).size() >= requiredCount && SpawnUtil.trySpawnMob(EntityTypes.ac, EnumMobSpawn.f, world, this.di(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long time) {
        return !this.b(this.dI().V()) ? false : !this.bA.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent interaction, Entity entity) {
        if (interaction == ReputationEvent.a) {
            Reputation.a playerReputation;
            if (!LeavesConfig.mcTechnicalMode && this.dI().paperConfig().fixes.fixCuringZombieVillagerDiscountExploit && (playerReputation = this.gt().c.get(entity.ct())) != null) {
                playerReputation.b(ReputationType.d);
                playerReputation.b(ReputationType.c);
            }
            this.cp.a(entity.ct(), ReputationType.d, 20);
            this.cp.a(entity.ct(), ReputationType.c, 25);
        } else if (interaction == ReputationEvent.e) {
            this.cp.a(entity.ct(), ReputationType.e, 2);
        } else if (interaction == ReputationEvent.c) {
            this.cp.a(entity.ct(), ReputationType.b, 25);
        } else if (interaction == ReputationEvent.d) {
            this.cp.a(entity.ct(), ReputationType.a, 25);
        }
    }

    @Override
    public int r() {
        return this.cs;
    }

    public void u(int experience) {
        this.cs = experience;
    }

    private void gI() {
        this.gz();
        this.cu = 0;
    }

    public Reputation gt() {
        return this.cp;
    }

    @Override
    public void a(NBTBase nbt) {
        this.cp.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt));
    }

    @Override
    protected void V() {
        super.V();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bA.a(MemoryModuleType.G, Long.valueOf(this.dI().V()));
        this.bA.b(MemoryModuleType.m);
        this.bA.b(MemoryModuleType.E);
    }

    @Override
    public void fz() {
        super.fz();
        this.bA.a(MemoryModuleType.H, Long.valueOf(this.dI().V()));
    }

    private boolean b(long worldTime) {
        Optional<Long> optional = this.bA.c(MemoryModuleType.G);
        return optional.isPresent() ? worldTime - optional.get() < 24000L : false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        if (LeavesConfig.villagersDontReleaseMemoryFix) {
            this.gB();
            this.dK().b(MemoryModuleType.b);
            this.dK().b(MemoryModuleType.c);
            this.dK().b(MemoryModuleType.d);
            this.dK().b(MemoryModuleType.e);
            this.c(destination);
        }
        return super.b(destination);
    }
}

