/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityRaider.class, DataWatcherRegistry.k);
    static final Predicate<EntityItem> b = entityitem -> !entityitem.r() && entityitem.bs() && ItemStack.a(entityitem.j(), LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s());
    @Nullable
    protected Raid d;
    private int e;
    private boolean bT;
    private int bU;

    protected EntityRaider(EntityTypes<? extends EntityRaider> type, World world) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)type, world);
    }

    @Override
    protected void x() {
        super.x();
        this.bO.a(1, new b(this, this));
        this.bO.a(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.bO.a(4, new d(this, 1.05f, 1));
        this.bO.a(5, new c(this));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(c, false);
    }

    public abstract void a(int var1, boolean var2);

    public boolean gl() {
        return this.bT;
    }

    public void z(boolean ableToJoinRaid) {
        this.bT = ableToJoinRaid;
    }

    @Override
    public void b_() {
        if (this.dI() instanceof WorldServer && this.bs()) {
            Raid raid = this.gm();
            if (this.gl()) {
                if (raid == null) {
                    Raid raid1;
                    if (this.dI().V() % 20L == 0L && (raid1 = ((WorldServer)this.dI()).c(this.di())) != null && PersistentRaid.a(this, raid1)) {
                        raid1.a(raid1.k(), this, null, true);
                    }
                } else {
                    EntityLiving entityliving = this.j();
                    if (entityliving != null && (entityliving.ae() == EntityTypes.bt || entityliving.ae() == EntityTypes.ac)) {
                        this.bc = 0;
                    }
                }
            }
        }
        super.b_();
    }

    @Override
    protected void gd() {
        this.bc += 2;
    }

    @Override
    public void a(DamageSource damageSource) {
        if (this.dI() instanceof WorldServer) {
            Entity entity = damageSource.d();
            Raid raid = this.gm();
            if (raid != null) {
                if (this.gc()) {
                    raid.c(this.go());
                }
                if (entity != null && entity.ae() == EntityTypes.bt) {
                    raid.a(entity);
                }
                raid.a(this, false);
            }
            if (this.gc() && (LeavesConfig.skipSelfRaidCheck || raid == null) && ((WorldServer)this.dI()).c(this.di()) == null) {
                ItemStack itemstack = this.c(EnumItemSlot.f);
                EntityHuman entityhuman = null;
                if (entity instanceof EntityHuman) {
                    entityhuman = (EntityHuman)entity;
                } else if (entity instanceof EntityWolf) {
                    EntityWolf entitywolf = (EntityWolf)entity;
                    EntityLiving entityliving = entitywolf.I_();
                    if (entitywolf.q() && entityliving instanceof EntityHuman) {
                        entityhuman = (EntityHuman)entityliving;
                    }
                }
                if (!itemstack.b() && ItemStack.a(itemstack, LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s()) && entityhuman != null) {
                    int i2;
                    MobEffect mobeffect = entityhuman.b(MobEffects.E);
                    int b0 = 1;
                    if (mobeffect != null) {
                        i2 = b0 + mobeffect.e();
                        entityhuman.c(MobEffects.E);
                    } else {
                        i2 = b0 - 1;
                    }
                    i2 = MathHelper.a(i2, 0, 4);
                    MobEffect mobeffect1 = new MobEffect(MobEffects.E, 120000, i2, false, false, true);
                    if (!this.dI().X().b(GameRules.z)) {
                        entityhuman.addEffect(mobeffect1, EntityPotionEffectEvent.Cause.PATROL_CAPTAIN);
                    }
                }
            }
        }
        super.a(damageSource);
    }

    @Override
    public boolean gf() {
        return !this.gn();
    }

    public void a(@Nullable Raid raid) {
        this.d = raid;
    }

    @Nullable
    public Raid gm() {
        return this.d;
    }

    public boolean gn() {
        return this.gm() != null && this.gm().v();
    }

    public void b(int wave) {
        this.e = wave;
    }

    public int go() {
        return this.e;
    }

    public boolean gp() {
        return this.am.b(c);
    }

    public void A(boolean celebrating) {
        this.am.b(c, celebrating);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Wave", this.e);
        nbt.a("CanJoinRaid", this.bT);
        if (this.d != null) {
            nbt.a("RaidId", this.d.u());
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Wave");
        this.bT = nbt.q("CanJoinRaid");
        if (nbt.b("RaidId", 3)) {
            if (this.dI() instanceof WorldServer) {
                this.d = ((WorldServer)this.dI()).x().a(nbt.h("RaidId"));
            }
            if (this.d != null) {
                this.d.a(this.e, this, false);
                if (this.gc()) {
                    this.d.a(this.e, this);
                }
            }
        }
    }

    @Override
    protected void b(EntityItem item) {
        boolean flag;
        ItemStack itemstack = item.j();
        boolean bl = flag = this.gn() && this.gm().b(this.go()) != null;
        if (this.gn() && !flag && ItemStack.a(itemstack, LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s())) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, item, 0, false).isCancelled()) {
                return;
            }
            EnumItemSlot enumitemslot = EnumItemSlot.f;
            ItemStack itemstack1 = this.c(enumitemslot);
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.af.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            this.a(item);
            this.a(enumitemslot, itemstack);
            this.a((Entity)item, itemstack.L());
            item.ai();
            this.gm().a(this.go(), this);
            this.w(true);
        } else {
            super.b(item);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return this.gm() == null ? super.h(distanceSquared) : false;
    }

    @Override
    public boolean T() {
        return super.T() || this.gm() != null;
    }

    public int gq() {
        return this.bU;
    }

    public void c(int outOfRaidCounter) {
        this.bU = outOfRaidCounter;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.gn()) {
            this.gm().p();
        }
        return super.a(source, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.z(this.ae() != EntityTypes.bj || spawnReason != EnumMobSpawn.a);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public abstract SoundEffect Y_();

    public static class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T b;
        final /* synthetic */ EntityRaider this$0;

        public b(T entityraider) {
            this.this$0 = this$0;
            this.b = entityraider;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!((Entity)this.b).dI().X().b(GameRules.c) || !((EntityInsentient)this.b).fG()) {
                return false;
            }
            Raid raid = ((EntityRaider)this.b).gm();
            if (((EntityRaider)this.b).gn() && !((EntityRaider)this.b).gm().a() && ((EntityMonsterPatrolling)this.b).fZ() && !ItemStack.a(((EntityInsentient)this.b).c(EnumItemSlot.f), LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s())) {
                List<EntityItem> list;
                EntityRaider entityraider = raid.b(((EntityRaider)this.b).go());
                if (!(entityraider != null && entityraider.bs() || (list = ((Entity)this.b).dI().a(EntityItem.class, ((Entity)this.b).cE().c(16.0, 8.0, 16.0), b)).isEmpty())) {
                    return ((EntityInsentient)this.b).J().a((Entity)list.get(0), (double)1.15f);
                }
                return false;
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list;
            if (((EntityInsentient)this.b).J().h().a(((Entity)this.b).dg(), 1.414) && !(list = ((Entity)this.b).dI().a(EntityItem.class, ((Entity)this.b).cE().c(4.0, 4.0, 4.0), b)).isEmpty()) {
                ((EntityRaider)this.b).b(list.get(0));
            }
        }
    }

    private static class d
    extends PathfinderGoal {
        private final EntityRaider a;
        private final double b;
        private BlockPosition c;
        private final List<BlockPosition> d = Lists.newArrayList();
        private final int e;
        private boolean f;

        public d(EntityRaider raider, double speed, int distance) {
            this.a = raider;
            this.b = speed;
            this.e = distance;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.k();
            return this.h() && this.i() && this.a.j() == null;
        }

        private boolean h() {
            return this.a.gn() && !this.a.gm().a();
        }

        private boolean i() {
            WorldServer worldserver = (WorldServer)this.a.dI();
            BlockPosition blockposition = this.a.di();
            Optional<BlockPosition> optional = worldserver.w().a(holder -> holder.a(PoiTypes.n), this::a, VillagePlace.Occupancy.c, blockposition, 48, this.a.af);
            if (!optional.isPresent()) {
                return false;
            }
            this.c = optional.get().i();
            return true;
        }

        @Override
        public boolean b() {
            return this.a.J().l() ? false : this.a.j() == null && !this.c.a(this.a.dg(), (double)(this.a.dd() + (float)this.e)) && !this.f;
        }

        @Override
        public void d() {
            if (this.c.a(this.a.dg(), (double)this.e)) {
                this.d.add(this.c);
            }
        }

        @Override
        public void c() {
            super.c();
            this.a.o(0);
            this.a.J().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), this.b);
            this.f = false;
        }

        @Override
        public void e() {
            if (this.a.J().l()) {
                Vec3D vec3d = Vec3D.c(this.c);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 7, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.f = true;
                    return;
                }
                this.a.J().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }

        private boolean a(BlockPosition pos) {
            BlockPosition blockposition1;
            Iterator<BlockPosition> iterator = this.d.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!Objects.equals(pos, blockposition1 = iterator.next()));
            return false;
        }

        private void k() {
            if (this.d.size() > 2) {
                this.d.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider b;

        c(EntityRaider entityraider) {
            this.b = entityraider;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            Raid raid = this.b.gm();
            return this.b.bs() && this.b.j() == null && raid != null && raid.f();
        }

        @Override
        public void c() {
            this.b.A(true);
            super.c();
        }

        @Override
        public void d() {
            this.b.A(false);
            super.d();
        }

        @Override
        public void e() {
            if (!this.b.aQ() && this.b.af.a(this.a(100)) == 0) {
                EntityRaider.this.a(EntityRaider.this.Y_(), EntityRaider.this.eR(), EntityRaider.this.eS());
            }
            if (!this.b.bM() && this.b.af.a(this.a(50)) == 0) {
                this.b.I().a();
            }
            super.e();
        }
    }

    protected class a
    extends PathfinderGoal {
        private final EntityRaider c;
        private final float d;
        public final PathfinderTargetCondition a = PathfinderTargetCondition.b().a(8.0).d().e();

        public a(EntityIllagerAbstract entityillagerabstract, float f2) {
            this.c = entityillagerabstract;
            this.d = f2 * f2;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.c.ed();
            return this.c.gm() == null && this.c.gh() && this.c.j() != null && !this.c.fS() && (entityliving == null || entityliving.ae() != EntityTypes.bt);
        }

        @Override
        public void c() {
            super.c();
            this.c.J().n();
            List<EntityRaider> list = this.c.dI().a(EntityRaider.class, this.a, this.c, this.c.cE().c(8.0, 8.0, 8.0));
            for (EntityRaider entityraider : list) {
                entityraider.setTarget(this.c.j(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        @Override
        public void d() {
            super.d();
            EntityLiving entityliving = this.c.j();
            if (entityliving != null) {
                List<EntityRaider> list = this.c.dI().a(EntityRaider.class, this.a, this.c, this.c.cE().c(8.0, 8.0, 8.0));
                for (EntityRaider entityraider : list) {
                    entityraider.setTarget(this.c.j(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    entityraider.v(true);
                }
                this.c.v(true);
            }
        }

        @Override
        public boolean K_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.c.j();
            if (entityliving != null) {
                if (this.c.f((Entity)entityliving) > (double)this.d) {
                    this.c.E().a(entityliving, 30.0f, 30.0f);
                    if (this.c.af.a(50) == 0) {
                        this.c.N();
                    }
                } else {
                    this.c.v(true);
                }
                super.e();
            }
        }
    }
}

