/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private static final String a = "instrument";
    private final TagKey<Instrument> b;

    public InstrumentItem(Item.Info settings, TagKey<Instrument> instrumentTag) {
        super(settings);
        this.b = instrumentTag;
    }

    @Override
    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        super.a(stack, world, tooltip, context);
        Optional optional = this.d(stack).flatMap(Holder::e);
        if (optional.isPresent()) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.c(SystemUtils.a(a, ((ResourceKey)optional.get()).a()));
            tooltip.add(mutableComponent.a(EnumChatFormat.h));
        }
    }

    public static ItemStack a(Item item, Holder<Instrument> instrument) {
        ItemStack itemStack = new ItemStack(item);
        InstrumentItem.a(itemStack, instrument);
        return itemStack;
    }

    public static void a(ItemStack stack, TagKey<Instrument> instrumentTag, RandomSource random) {
        Optional optional = BuiltInRegistries.am.b(instrumentTag).flatMap(entryList -> entryList.a(random));
        optional.ifPresent(instrument -> InstrumentItem.a(stack, (Holder<Instrument>)instrument));
    }

    private static void a(ItemStack stack, Holder<Instrument> instrument) {
        NBTTagCompound compoundTag = stack.w();
        compoundTag.a(a, instrument.e().orElseThrow(() -> new IllegalStateException("Invalid instrument")).a().toString());
    }

    @Override
    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        Optional<? extends Holder<Instrument>> optional = this.d(itemStack);
        if (optional.isPresent()) {
            Instrument instrument = optional.get().a();
            user.c(hand);
            InstrumentItem.a(world, user, instrument);
            user.gi().a((Item)this, instrument.b());
            user.b(StatisticList.c.b(this));
            return InteractionResultWrapper.b(itemStack);
        }
        return InteractionResultWrapper.d(itemStack);
    }

    @Override
    @Override
    public int b(ItemStack stack) {
        Optional<? extends Holder<Instrument>> optional = this.d(stack);
        return optional.map(instrument -> ((Instrument)instrument.a()).b()).orElse(0);
    }

    private Optional<? extends Holder<Instrument>> d(ItemStack stack) {
        MinecraftKey resourceLocation;
        NBTTagCompound compoundTag = stack.v();
        if (compoundTag != null && compoundTag.b(a, 8) && (resourceLocation = MinecraftKey.a(compoundTag.l(a))) != null) {
            return BuiltInRegistries.am.b(ResourceKey.a(Registries.B, resourceLocation));
        }
        Iterator<Holder<Instrument>> iterator = BuiltInRegistries.am.c(this.b).iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    @Override
    @Override
    public EnumAnimation c(ItemStack stack) {
        return EnumAnimation.i;
    }

    private static void a(World world, EntityHuman player, Instrument instrument) {
        SoundEffect soundEvent = instrument.a().a();
        float f2 = instrument.c() / 16.0f;
        world.a(player, player, soundEvent, SoundCategory.c, f2, 1.0f);
        world.a(GameEvent.C, player.dg(), GameEvent.a.a(player));
    }
}

