/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger b = LogUtils.getLogger();
    public Map<Recipes<?>, Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>>> c = ImmutableMap.of();
    public Map<MinecraftKey, IRecipe<?>> d = ImmutableMap.of();
    private boolean e;

    public CraftingManager() {
        super(a, "recipes");
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        this.e = false;
        HashMap map1 = Maps.newHashMap();
        for (Recipes recipes2 : BuiltInRegistries.t) {
            map1.put(recipes2, new Object2ObjectLinkedOpenHashMap());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MinecraftKey, JsonElement> entry : prepared.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                IRecipe<?> irecipe = CraftingManager.a(minecraftkey, ChatDeserializer.m(entry.getValue(), "top element"));
                map1.computeIfAbsent(irecipe.f(), recipes -> new Object2ObjectLinkedOpenHashMap()).put((Object)minecraftkey, irecipe);
                builder.put((Object)minecraftkey, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                b.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.c = (Map)map1.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry1 -> (Object2ObjectLinkedOpenHashMap)entry1.getValue()));
        this.d = Maps.newHashMap((Map)builder.build());
        b.info("Loaded {} recipes", (Object)map1.size());
    }

    public void addRecipe(IRecipe<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>> map = this.c.get(irecipe.f());
        if (this.d.containsKey(irecipe.e()) || map.containsKey((Object)irecipe.e())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + irecipe.e());
        }
        map.putAndMoveToFirst((Object)irecipe.e(), irecipe);
        this.d.put(irecipe.e(), irecipe);
    }

    public boolean a() {
        return this.e;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> a(Recipes<T> type, C inventory, World world) {
        Optional<IRecipe> recipe = this.c(type).values().stream().filter(irecipe -> irecipe.a(inventory, world)).findFirst();
        inventory.setCurrentRecipe(recipe.orElse(null));
        return recipe;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<Pair<MinecraftKey, T>> a(Recipes<T> type, C inventory, World world, @Nullable MinecraftKey id) {
        IRecipe t0;
        Map<MinecraftKey, T> map = this.c(type);
        if (id != null && (t0 = (IRecipe)map.get(id)) != null && t0.a(inventory, world)) {
            inventory.setCurrentRecipe(t0);
            return Optional.of(Pair.of((Object)id, (Object)t0));
        }
        inventory.setCurrentRecipe(null);
        return map.entrySet().stream().filter(entry -> ((IRecipe)entry.getValue()).a(inventory, world)).findFirst().map(entry -> {
            inventory.setCurrentRecipe((IRecipe)entry.getValue());
            return Pair.of((Object)((MinecraftKey)entry.getKey()), (Object)((IRecipe)entry.getValue()));
        });
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> a(Recipes<T> type) {
        return List.copyOf(this.c(type).values());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> b(Recipes<T> type, C inventory, World world) {
        return this.c(type).values().stream().filter(irecipe -> irecipe.a(inventory, world)).sorted(Comparator.comparing(irecipe -> irecipe.a(world.B_()).q())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<MinecraftKey, T> c(Recipes<T> type) {
        return (Map)this.c.getOrDefault(type, new Object2ObjectLinkedOpenHashMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> c(Recipes<T> type, C inventory, World world) {
        return this.getRemainingItemsFor(type, inventory, world, null);
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> type, C inventory, World world, @Nullable MinecraftKey firstToCheck) {
        Optional<T> optional;
        Optional<Object> optional2 = optional = firstToCheck == null ? this.a(type, inventory, world) : this.a(type, inventory, world, firstToCheck).map(Pair::getSecond);
        if (optional.isPresent()) {
            return ((IRecipe)optional.get()).a(inventory);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.a(inventory.b(), ItemStack.b);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, inventory.a(i2));
        }
        return nonnulllist;
    }

    public Optional<? extends IRecipe<?>> a(MinecraftKey id) {
        return Optional.ofNullable(this.d.get(id));
    }

    public Collection<IRecipe<?>> b() {
        return this.c.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
    }

    public Stream<MinecraftKey> d() {
        return this.c.values().stream().flatMap(map -> map.keySet().stream());
    }

    public static IRecipe<?> a(MinecraftKey id, JsonObject json) {
        String s2 = ChatDeserializer.i(json, "type");
        return BuiltInRegistries.u.b(new MinecraftKey(s2)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s2 + "'")).a(id, json);
    }

    public void a(Iterable<IRecipe<?>> recipes) {
        this.e = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        recipes.forEach(irecipe -> {
            Map map1 = (Map)map.computeIfAbsent(irecipe.f(), recipes_ -> new Object2ObjectLinkedOpenHashMap());
            MinecraftKey minecraftkey = irecipe.e();
            IRecipe irecipe1 = map1.put(minecraftkey, irecipe);
            builder.put((Object)minecraftkey, irecipe);
            if (irecipe1 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + minecraftkey);
            }
        });
        this.c = ImmutableMap.copyOf((Map)map);
        this.d = Maps.newHashMap((Map)builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        for (Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>> recipes : this.c.values()) {
            recipes.remove((Object)mcKey);
        }
        return this.d.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.c = Maps.newHashMap();
        for (Recipes recipes : BuiltInRegistries.t) {
            this.c.put(recipes, new Object2ObjectLinkedOpenHashMap());
        }
        this.d = Maps.newHashMap();
    }

    public static <C extends IInventory, T extends IRecipe<C>> a<C, T> b(final Recipes<T> type) {
        return new a<C, T>(){
            @Nullable
            private MinecraftKey b;

            @Override
            public Optional<T> a(C inventory, World world) {
                CraftingManager craftingmanager = world.q();
                Optional optional = craftingmanager.a(type, inventory, world, this.b);
                if (optional.isPresent()) {
                    Pair pair = optional.get();
                    this.b = (MinecraftKey)pair.getFirst();
                    return Optional.of((IRecipe)pair.getSecond());
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<C extends IInventory, T extends IRecipe<C>> {
        public Optional<T> a(C var1, World var2);
    }
}

