/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.structs.Long2FloatAgingCache;

public final class BiomeBase {
    public static final Codec<BiomeBase> a = RecordCodecBuilder.create(instance -> instance.group((App)ClimateSettings.a.forGetter(biome -> biome.i), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.l), (App)BiomeSettingsGeneration.b.forGetter(biome -> biome.j), (App)BiomeSettingsMobs.c.forGetter(biome -> biome.k)).apply((Applicative)instance, BiomeBase::new));
    public static final Codec<BiomeBase> b = RecordCodecBuilder.create(instance -> instance.group((App)ClimateSettings.a.forGetter(biome -> biome.i), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.l)).apply((Applicative)instance, (weather, effects) -> new BiomeBase((ClimateSettings)weather, (BiomeFog)effects, BiomeSettingsGeneration.a, BiomeSettingsMobs.b)));
    public static final Codec<Holder<BiomeBase>> c = RegistryFileCodec.a(Registries.ap, a);
    public static final Codec<HolderSet<BiomeBase>> d = RegistryCodecs.a(Registries.ap, a);
    private static final NoiseGenerator3 f = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 g = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 e = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int h = 1024;
    public final ClimateSettings i;
    private final BiomeSettingsGeneration j;
    private final BiomeSettingsMobs k;
    private final BiomeFog l;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> m;
    private final ThreadLocal<Long2FloatAgingCache> temperatureAgingCache;

    BiomeBase(ClimateSettings weather, BiomeFog effects, BiomeSettingsGeneration generationSettings, BiomeSettingsMobs spawnSettings) {
        this.i = weather;
        this.j = generationSettings;
        this.k = spawnSettings;
        this.l = effects;
        if (LeavesConfig.biomeTemperaturesUseAgingCache) {
            this.m = null;
            this.temperatureAgingCache = ThreadLocal.withInitial(() -> SystemUtils.a(() -> new Long2FloatAgingCache(1024)));
        } else {
            this.m = ThreadLocal.withInitial(() -> SystemUtils.a(() -> {
                Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

                    protected void rehash(int i2) {
                    }
                };
                long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
                return long2FloatLinkedOpenHashMap;
            }));
            this.temperatureAgingCache = null;
        }
    }

    public int a() {
        return this.l.d();
    }

    public BiomeSettingsMobs b() {
        return this.k;
    }

    public boolean c() {
        return this.i.a();
    }

    public Precipitation a(BlockPosition pos) {
        if (!this.c()) {
            return Precipitation.a;
        }
        return this.b(pos) ? Precipitation.c : Precipitation.b;
    }

    private float e(BlockPosition pos) {
        float f2 = this.i.d.a(pos, this.g());
        if (pos.v() > 80) {
            float g2 = (float)(f.a((float)pos.u() / 8.0f, (float)pos.w() / 8.0f, false) * 8.0);
            return f2 - (g2 + (float)pos.v() - 80.0f) * 0.05f / 40.0f;
        }
        return f2;
    }

    @Deprecated
    public float f(BlockPosition blockPos) {
        long l2 = blockPos.a();
        if (LeavesConfig.biomeTemperaturesUseAgingCache) {
            Long2FloatAgingCache cache = this.temperatureAgingCache.get();
            float f2 = cache.getValue(l2);
            if (!Float.isNaN(f2)) {
                return f2;
            }
            float g2 = this.e(blockPos);
            cache.putValue(l2, g2);
            return g2;
        }
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = this.m.get();
        float f3 = long2FloatLinkedOpenHashMap.get(l2);
        if (!Float.isNaN(f3)) {
            return f3;
        }
        float g3 = this.e(blockPos);
        if (long2FloatLinkedOpenHashMap.size() == 1024) {
            long2FloatLinkedOpenHashMap.removeFirstFloat();
        }
        long2FloatLinkedOpenHashMap.put(l2, g3);
        return g3;
    }

    public boolean a(IWorldReader world, BlockPosition blockPos) {
        return this.a(world, blockPos, true);
    }

    public boolean a(IWorldReader world, BlockPosition pos, boolean doWaterCheck) {
        if (this.c(pos)) {
            return false;
        }
        if (pos.v() >= world.C_() && pos.v() < world.aj() && world.a(EnumSkyBlock.b, pos) < 10) {
            IBlockData blockState = world.a_(pos);
            Fluid fluidState = world.b_(pos);
            if (fluidState.a() == FluidTypes.c && blockState.b() instanceof BlockFluids) {
                boolean bl;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl2 = bl = world.y(pos.g()) && world.y(pos.h()) && world.y(pos.e()) && world.y(pos.f());
                if (!bl) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(BlockPosition pos) {
        return !this.c(pos);
    }

    public boolean c(BlockPosition pos) {
        return this.f(pos) >= 0.15f;
    }

    public boolean d(BlockPosition pos) {
        return this.f(pos) > 0.1f;
    }

    public boolean b(IWorldReader world, BlockPosition pos) {
        IBlockData blockState;
        if (this.c(pos)) {
            return false;
        }
        return pos.v() >= world.C_() && pos.v() < world.aj() && world.a(EnumSkyBlock.b, pos) < 10 && ((blockState = world.a_(pos)).i() || blockState.a(Blocks.dN)) && Blocks.dN.n().a(world, pos);
    }

    public BiomeSettingsGeneration d() {
        return this.j;
    }

    public int e() {
        return this.l.a();
    }

    public int a(double x2, double z2) {
        int i2 = this.l.f().orElseGet(this::p);
        return this.l.g().a(x2, z2, i2);
    }

    private int p() {
        double d2 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double e2 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return GrassColor.a(d2, e2);
    }

    public int f() {
        return this.l.e().orElseGet(this::q);
    }

    private int q() {
        double d2 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double e2 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return FoliageColor.a(d2, e2);
    }

    public float g() {
        return this.i.c;
    }

    public BiomeFog h() {
        return this.l;
    }

    public int i() {
        return this.l.b();
    }

    public int j() {
        return this.l.c();
    }

    public Optional<BiomeParticles> k() {
        return this.l.h();
    }

    public Optional<Holder<SoundEffect>> l() {
        return this.l.i();
    }

    public Optional<CaveSoundSettings> m() {
        return this.l.j();
    }

    public Optional<CaveSound> n() {
        return this.l.k();
    }

    public Optional<Music> o() {
        return this.l.l();
    }

    public static final class ClimateSettings
    extends Record {
        private final boolean b;
        private final float c;
        private final TemperatureModifier d;
        private final float e;
        public static final MapCodec<ClimateSettings> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(weather -> weather.b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(weather -> Float.valueOf(weather.c)), (App)TemperatureModifier.c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.a).forGetter(weather -> weather.d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(weather -> Float.valueOf(weather.e))).apply((Applicative)instance, ClimateSettings::new));

        public ClimateSettings(boolean hasPrecipitation, float temperature, TemperatureModifier temperatureModifier, float downfall) {
            this.b = hasPrecipitation;
            this.c = temperature;
            this.d = temperatureModifier;
            this.e = downfall;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this, o2);
        }

        public boolean a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public TemperatureModifier c() {
            return this.d;
        }

        public float d() {
            return this.e;
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation> {
        public static final /* enum */ Precipitation a = new Precipitation();
        public static final /* enum */ Precipitation b = new Precipitation();
        public static final /* enum */ Precipitation c = new Precipitation();
        private static final /* synthetic */ Precipitation[] d;

        public static Precipitation[] values() {
            return (Precipitation[])d.clone();
        }

        public static Precipitation valueOf(String name) {
            return Enum.valueOf(Precipitation.class, name);
        }

        private static /* synthetic */ Precipitation[] a() {
            return new Precipitation[]{a, b, c};
        }

        static {
            d = Precipitation.a();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier a = new TemperatureModifier("none"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                return temperature;
            }
        };
        public static final /* enum */ TemperatureModifier b = new TemperatureModifier("frozen"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                double g2;
                double e2;
                double d2 = g.a((double)pos.u() * 0.05, (double)pos.w() * 0.05, false) * 7.0;
                double f2 = d2 + (e2 = BiomeBase.e.a((double)pos.u() * 0.2, (double)pos.w() * 0.2, false));
                if (f2 < 0.3 && (g2 = BiomeBase.e.a((double)pos.u() * 0.09, (double)pos.w() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return temperature;
            }
        };
        private final String d;
        public static final Codec<TemperatureModifier> c;
        private static final /* synthetic */ TemperatureModifier[] e;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])e.clone();
        }

        public static TemperatureModifier valueOf(String name) {
            return Enum.valueOf(TemperatureModifier.class, name);
        }

        public abstract float a(BlockPosition var1, float var2);

        private TemperatureModifier(String name) {
            this.d = name;
        }

        public String a() {
            return this.d;
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{a, b};
        }

        static {
            e = TemperatureModifier.b();
            c = INamable.a(TemperatureModifier::values);
        }
    }

    public static class a {
        private boolean a = true;
        @Nullable
        private Float b;
        private TemperatureModifier c = TemperatureModifier.a;
        @Nullable
        private Float d;
        @Nullable
        private BiomeFog e;
        @Nullable
        private BiomeSettingsMobs f;
        @Nullable
        private BiomeSettingsGeneration g;

        public a a(boolean precipitation) {
            this.a = precipitation;
            return this;
        }

        public a a(float temperature) {
            this.b = Float.valueOf(temperature);
            return this;
        }

        public a b(float downfall) {
            this.d = Float.valueOf(downfall);
            return this;
        }

        public a a(BiomeFog effects) {
            this.e = effects;
            return this;
        }

        public a a(BiomeSettingsMobs spawnSettings) {
            this.f = spawnSettings;
            return this;
        }

        public a a(BiomeSettingsGeneration generationSettings) {
            this.g = generationSettings;
            return this;
        }

        public a a(TemperatureModifier temperatureModifier) {
            this.c = temperatureModifier;
            return this;
        }

        public BiomeBase a() {
            if (this.b != null && this.d != null && this.e != null && this.f != null && this.g != null) {
                return new BiomeBase(new ClimateSettings(this.a, this.b.floatValue(), this.c, this.d.floatValue()), this.e, this.g, this.f);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
        }

        public String toString() {
            return "BiomeBuilder{\nhasPrecipitation=" + this.a + ",\ntemperature=" + this.b + ",\ntemperatureModifier=" + this.c + ",\ndownfall=" + this.d + ",\nspecialEffects=" + this.e + ",\nmobSpawnSettings=" + this.f + ",\ngenerationSettings=" + this.g + ",\n}";
        }
    }
}

