/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockMobSpawner
extends BlockTileEntity {
    protected BlockMobSpawner(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityMobSpawner(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockMobSpawner.a(type, TileEntityTypes.j, world.B ? TileEntityMobSpawner::a : TileEntityMobSpawner::b);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            int i2 = 15 + worldserver.z.a(15) + worldserver.z.a(15);
            return i2;
        }
        return 0;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public void a(ItemStack stack, @Nullable IBlockAccess world, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, world, tooltip, options);
        Optional<IChatBaseComponent> optional = this.a(stack);
        if (optional.isPresent()) {
            tooltip.add(optional.get());
        } else {
            tooltip.add(CommonComponents.a);
            tooltip.add(IChatBaseComponent.c("block.minecraft.spawner.desc1").a(EnumChatFormat.h));
            tooltip.add(CommonComponents.a().b(IChatBaseComponent.c("block.minecraft.spawner.desc2").a(EnumChatFormat.j)));
        }
    }

    private Optional<IChatBaseComponent> a(ItemStack stack) {
        String s2;
        MinecraftKey minecraftkey;
        NBTTagCompound nbttagcompound = ItemBlock.a(stack);
        if (nbttagcompound != null && nbttagcompound.b("SpawnData", 10) && (minecraftkey = MinecraftKey.a(s2 = nbttagcompound.p("SpawnData").p("entity").l("id"))) != null) {
            return BuiltInRegistries.h.b(minecraftkey).map(entitytypes -> IChatBaseComponent.c(entitytypes.g()).a(EnumChatFormat.h));
        }
        return Optional.empty();
    }
}

