/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.util.RedstoneWireTurbo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.papermc.paper.configuration.WorldConfiguration;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import top.leavesmc.leaves.LeavesConfig;

public class BlockRedstoneWire
extends Block {
    public static final BlockStateEnum<BlockPropertyRedstoneSide> a = BlockProperties.ab;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> b = BlockProperties.aa;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> c = BlockProperties.ac;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> d = BlockProperties.ad;
    public static final BlockStateInteger e = BlockProperties.aT;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> f = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, a, (Object)EnumDirection.f, b, (Object)EnumDirection.d, c, (Object)EnumDirection.e, d));
    protected static final int g = 1;
    protected static final int h = 3;
    protected static final int i = 13;
    protected static final int j = 3;
    protected static final int k = 13;
    private static final VoxelShape l = Block.a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<EnumDirection, VoxelShape> m = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)Block.a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)EnumDirection.d, (Object)Block.a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)EnumDirection.f, (Object)Block.a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)EnumDirection.e, (Object)Block.a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<EnumDirection, VoxelShape> n = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)VoxelShapes.a(m.get(EnumDirection.c), Block.a(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)EnumDirection.d, (Object)VoxelShapes.a(m.get(EnumDirection.d), Block.a(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)EnumDirection.f, (Object)VoxelShapes.a(m.get(EnumDirection.f), Block.a(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)EnumDirection.e, (Object)VoxelShapes.a(m.get(EnumDirection.e), Block.a(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<IBlockData, VoxelShape> D = Maps.newHashMap();
    private static final Vec3D[] E = SystemUtils.a(new Vec3D[16], (T avec3d) -> {
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f2;
            float f1 = f2 * 0.6f + ((f2 = (float)i2 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f22 = MathHelper.a(f2 * f2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = MathHelper.a(f2 * f2 * 0.6f - 0.7f, 0.0f, 1.0f);
            avec3d[i2] = new Vec3D(f1, f22, f3);
        }
    });
    private static final float F = 0.2f;
    private final IBlockData G;
    public boolean H = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public BlockRedstoneWire(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().a(a, BlockPropertyRedstoneSide.c)).a(b, BlockPropertyRedstoneSide.c)).a(c, BlockPropertyRedstoneSide.c)).a(d, BlockPropertyRedstoneSide.c)).a(e, 0));
        this.G = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.n().a(a, BlockPropertyRedstoneSide.b)).a(b, BlockPropertyRedstoneSide.b)).a(c, BlockPropertyRedstoneSide.b)).a(d, BlockPropertyRedstoneSide.b);
        for (IBlockData iblockdata : this.l().a()) {
            if (iblockdata.c(e) != 0) continue;
            D.put(iblockdata, this.n(iblockdata));
        }
    }

    private VoxelShape n(IBlockData state) {
        VoxelShape voxelshape = l;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)state.c(f.get(enumdirection));
            if (blockpropertyredstoneside == BlockPropertyRedstoneSide.b) {
                voxelshape = VoxelShapes.a(voxelshape, m.get(enumdirection));
                continue;
            }
            if (blockpropertyredstoneside != BlockPropertyRedstoneSide.a) continue;
            voxelshape = VoxelShapes.a(voxelshape, n.get(enumdirection));
        }
        return voxelshape;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return D.get(state.a(e, 0));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.a((IBlockAccess)ctx.q(), this.G, ctx.a());
    }

    private IBlockData a(IBlockAccess world, IBlockData state, BlockPosition pos) {
        boolean flag6;
        boolean flag = BlockRedstoneWire.p(state);
        state = this.b(world, (IBlockData)this.n().a(e, state.c(e)), pos);
        if (flag && BlockRedstoneWire.p(state)) {
            return state;
        }
        boolean flag1 = state.c(a).a();
        boolean flag2 = state.c(c).a();
        boolean flag3 = state.c(b).a();
        boolean flag4 = state.c(d).a();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            state = (IBlockData)state.a(d, BlockPropertyRedstoneSide.b);
        }
        if (!flag3 && flag5) {
            state = (IBlockData)state.a(b, BlockPropertyRedstoneSide.b);
        }
        if (!flag1 && flag6) {
            state = (IBlockData)state.a(a, BlockPropertyRedstoneSide.b);
        }
        if (!flag2 && flag6) {
            state = (IBlockData)state.a(c, BlockPropertyRedstoneSide.b);
        }
        return state;
    }

    private IBlockData b(IBlockAccess world, IBlockData state, BlockPosition pos) {
        boolean flag = !world.a_(pos.c()).g(world, pos);
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            if (((BlockPropertyRedstoneSide)state.c(f.get(enumdirection))).a()) continue;
            BlockPropertyRedstoneSide blockpropertyredstoneside = this.a(world, pos, enumdirection, flag);
            state = (IBlockData)state.a(f.get(enumdirection), blockpropertyredstoneside);
        }
        return state;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == EnumDirection.a) {
            return state;
        }
        if (direction == EnumDirection.b) {
            return this.a((IBlockAccess)world, state, pos);
        }
        BlockPropertyRedstoneSide blockpropertyredstoneside = this.a((IBlockAccess)world, pos, direction);
        return blockpropertyredstoneside.a() == ((BlockPropertyRedstoneSide)state.c(f.get(direction))).a() && !BlockRedstoneWire.o(state) ? (IBlockData)state.a(f.get(direction), blockpropertyredstoneside) : this.a((IBlockAccess)world, (IBlockData)((IBlockData)this.G.a(e, state.c(e))).a(f.get(direction), blockpropertyredstoneside), pos);
    }

    private static boolean o(IBlockData state) {
        return state.c(a).a() && state.c(c).a() && state.c(b).a() && state.c(d).a();
    }

    private static boolean p(IBlockData state) {
        return !state.c(a).a() && !state.c(c).a() && !state.c(b).a() && !state.c(d).a();
    }

    @Override
    public void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)state.c(f.get(enumdirection));
            if (blockpropertyredstoneside == BlockPropertyRedstoneSide.c || world.a_(blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection)).a(this)) continue;
            blockposition_mutableblockposition.c(EnumDirection.a);
            IBlockData iblockdata1 = world.a_(blockposition_mutableblockposition);
            if (iblockdata1.a(this)) {
                BlockPosition blockposition1 = blockposition_mutableblockposition.a(enumdirection.g());
                world.a(enumdirection.g(), world.a_(blockposition1), blockposition_mutableblockposition, blockposition1, flags, maxUpdateDepth);
            }
            blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection).c(EnumDirection.b);
            IBlockData iblockdata2 = world.a_(blockposition_mutableblockposition);
            if (!iblockdata2.a(this)) continue;
            BlockPosition blockposition2 = blockposition_mutableblockposition.a(enumdirection.g());
            world.a(enumdirection.g(), world.a_(blockposition2), blockposition_mutableblockposition, blockposition2, flags, maxUpdateDepth);
        }
    }

    private BlockPropertyRedstoneSide a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return this.a(world, pos, direction, !world.a_(pos.c()).g(world, pos));
    }

    private BlockPropertyRedstoneSide a(IBlockAccess world, BlockPosition pos, EnumDirection direction, boolean flag) {
        BlockPosition blockposition1 = pos.a(direction);
        IBlockData iblockdata = world.a_(blockposition1);
        if (flag) {
            boolean flag1;
            boolean bl = flag1 = !LeavesConfig.redstoneDontCantOnTrapDoor && iblockdata.b() instanceof BlockTrapdoor || this.b(world, blockposition1, iblockdata);
            if (flag1 && BlockRedstoneWire.h(world.a_(blockposition1.c()))) {
                if (iblockdata.d(world, blockposition1, direction.g())) {
                    return BlockPropertyRedstoneSide.a;
                }
                return BlockPropertyRedstoneSide.b;
            }
        }
        return !BlockRedstoneWire.a(iblockdata, direction) && (iblockdata.g(world, blockposition1) || !BlockRedstoneWire.h(world.a_(blockposition1.d()))) ? BlockPropertyRedstoneSide.c : BlockPropertyRedstoneSide.b;
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata1 = world.a_(blockposition1);
        return this.b((IBlockAccess)world, blockposition1, iblockdata1);
    }

    private boolean b(IBlockAccess world, BlockPosition pos, IBlockData floor) {
        return floor.d(world, pos, EnumDirection.b) || floor.a(Blocks.hc);
    }

    private void updateSurroundingRedstone(World worldIn, BlockPosition pos, IBlockData state, BlockPosition source) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.a(worldIn, pos, state);
    }

    public IBlockData calculateCurrentChanges(World worldIn, BlockPosition pos1, BlockPosition pos2, IBlockData state) {
        IBlockData iblockstate = state;
        int i2 = state.c(e);
        int j2 = 0;
        j2 = this.getPower(j2, worldIn.a_(pos2));
        this.H = false;
        int k2 = worldIn.C(pos1);
        this.H = true;
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA && k2 > 0 && k2 > j2 - 1) {
            j2 = k2;
        }
        int l2 = 0;
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA || k2 < 15) {
            for (EnumDirection enumfacing : EnumDirection.EnumDirectionLimit.a) {
                boolean flag;
                BlockPosition blockpos = pos1.a(enumfacing);
                boolean bl = flag = blockpos.u() != pos2.u() || blockpos.w() != pos2.w();
                if (flag) {
                    l2 = this.getPower(l2, worldIn.a_(blockpos));
                }
                if (worldIn.a_(blockpos).g(worldIn, blockpos) && !worldIn.a_(pos1.c()).g(worldIn, pos1)) {
                    if (!flag || pos1.v() < pos2.v()) continue;
                    l2 = this.getPower(l2, worldIn.a_(blockpos.c()));
                    continue;
                }
                if (worldIn.a_(blockpos).g(worldIn, blockpos) || !flag || pos1.v() > pos2.v()) continue;
                l2 = this.getPower(l2, worldIn.a_(blockpos.d()));
            }
        }
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA) {
            j2 = l2 > j2 ? l2 - 1 : (j2 > 0 ? --j2 : 0);
            if (k2 > j2 - 1) {
                j2 = k2;
            }
        } else {
            j2 = l2 - 1;
            if (k2 > j2) {
                j2 = k2;
            }
        }
        if (i2 != j2) {
            BlockRedstoneEvent event = new BlockRedstoneEvent(worldIn.getWorld().getBlockAt(pos1.u(), pos1.v(), pos1.w()), i2, j2);
            worldIn.getCraftServer().getPluginManager().callEvent((Event)event);
            j2 = event.getNewCurrent();
            state = (IBlockData)state.a(e, j2);
            if (worldIn.a_(pos1) == iblockstate && worldIn.a(pos1, state, 18)) {
                this.turbo.updateNeighborShapes(worldIn, pos1, state);
            }
        }
        return state;
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        int i2 = this.a(world, pos);
        int oldPower = state.c(e);
        if (oldPower != i2) {
            BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()), oldPower, i2);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            i2 = event.getNewCurrent();
        }
        if (oldPower != i2) {
            if (world.a_(pos) == state) {
                world.a(pos, (IBlockData)state.a(e, i2), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (EnumDirection enumdirection : EnumDirection.values()) {
                set.add(pos.a(enumdirection));
            }
            for (BlockPosition blockposition1 : set) {
                world.a(blockposition1, this);
            }
        }
    }

    private int a(World world, BlockPosition pos) {
        this.H = false;
        int i2 = world.C(pos);
        this.H = true;
        int j2 = 0;
        if (i2 < 15) {
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
                BlockPosition blockposition1 = pos.a(enumdirection);
                IBlockData iblockdata = world.a_(blockposition1);
                j2 = Math.max(j2, this.q(iblockdata));
                BlockPosition blockposition2 = pos.c();
                if (iblockdata.g(world, blockposition1) && !world.a_(blockposition2).g(world, blockposition2)) {
                    j2 = Math.max(j2, this.q(world.a_(blockposition1.c())));
                    continue;
                }
                if (iblockdata.g(world, blockposition1)) continue;
                j2 = Math.max(j2, this.q(world.a_(blockposition1.d())));
            }
        }
        return Math.max(i2, j2 - 1);
    }

    private int getPower(int min, IBlockData iblockdata) {
        return Math.max(min, this.q(iblockdata));
    }

    private int q(IBlockData state) {
        return state.a(this) ? state.c(e) : 0;
    }

    private void b(World world, BlockPosition pos) {
        if (world.a_(pos).a(this)) {
            world.a(pos, this);
            for (EnumDirection enumdirection : EnumDirection.values()) {
                world.a(pos.a(enumdirection), this);
            }
        }
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b()) && !world.B) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireAdded(pos);
            } else {
                this.updateSurroundingRedstone(world, pos, state, null);
            }
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.b) {
                world.a(pos.a(enumdirection), this);
            }
            this.c(world, pos);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            super.a(state, world, pos, newState, moved);
            if (!world.B) {
                for (EnumDirection enumdirection : EnumDirection.values()) {
                    world.a(pos.a(enumdirection), this);
                }
                if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                    world.getWireHandler().onWireRemoved(pos, state);
                } else {
                    this.updateSurroundingRedstone(world, pos, state, null);
                }
                this.c(world, pos);
            }
        }
    }

    private void c(World world, BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            this.b(world, pos.a(enumdirection));
        }
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (world.a_(blockposition1).g(world, blockposition1)) {
                this.b(world, blockposition1.c());
                continue;
            }
            this.b(world, blockposition1.d());
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        if (!world.B) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireUpdated(pos);
            } else if (state.a((IWorldReader)world, pos)) {
                this.updateSurroundingRedstone(world, pos, state, sourcePos);
            } else {
                BlockRedstoneWire.c(state, world, pos);
                world.a(pos, false);
            }
        }
    }

    @Override
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return !this.H ? 0 : state.b(world, pos, direction);
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        if (this.H && direction != EnumDirection.a) {
            int i2 = state.c(e);
            return i2 == 0 ? 0 : (direction != EnumDirection.b && !((BlockPropertyRedstoneSide)this.a(world, state, pos).c(f.get(direction.g()))).a() ? 0 : i2);
        }
        return 0;
    }

    protected static boolean h(IBlockData state) {
        return BlockRedstoneWire.a(state, (EnumDirection)null);
    }

    protected static boolean a(IBlockData state, @Nullable EnumDirection dir) {
        if (state.a(Blocks.cw)) {
            return true;
        }
        if (state.a(Blocks.ei)) {
            EnumDirection enumdirection1 = state.c(BlockFacingHorizontal.aC);
            return enumdirection1 == dir || enumdirection1.g() == dir;
        }
        return state.a(Blocks.kO) ? dir == state.c(BlockDirectional.a) : state.m() && dir != null;
    }

    @Override
    public boolean f_(IBlockData state) {
        return this.H;
    }

    public static int b(int powerLevel) {
        Vec3D vec3d = E[powerLevel];
        return MathHelper.f((float)vec3d.a(), (float)vec3d.b(), (float)vec3d.c());
    }

    private void a(World world, RandomSource random, BlockPosition pos, Vec3D color, EnumDirection enumdirection, EnumDirection enumdirection1, float f2, float f1) {
        float f22 = f1 - f2;
        if (random.i() < 0.2f * f22) {
            float f3 = 0.4375f;
            float f4 = f2 + f22 * random.i();
            double d0 = 0.5 + (double)(0.4375f * (float)enumdirection.j()) + (double)(f4 * (float)enumdirection1.j());
            double d1 = 0.5 + (double)(0.4375f * (float)enumdirection.k()) + (double)(f4 * (float)enumdirection1.k());
            double d2 = 0.5 + (double)(0.4375f * (float)enumdirection.l()) + (double)(f4 * (float)enumdirection1.l());
            world.a(new ParticleParamRedstone(color.j(), 1.0f), (double)pos.u() + d0, (double)pos.v() + d1, (double)pos.w() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        int i2 = state.c(e);
        if (i2 != 0) {
            block4: for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
                BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)state.c(f.get(enumdirection));
                switch (blockpropertyredstoneside) {
                    case a: {
                        this.a(world, random, pos, E[i2], enumdirection, EnumDirection.b, -0.5f, 0.5f);
                    }
                    case b: {
                        this.a(world, random, pos, E[i2], EnumDirection.a, enumdirection, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.a(world, random, pos, E[i2], EnumDirection.a, enumdirection, 0.0f, 0.3f);
            }
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(a, state.c(c))).a(b, state.c(d))).a(c, state.c(a))).a(d, state.c(b));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(a, state.c(b))).a(b, state.c(c))).a(c, state.c(d))).a(d, state.c(a));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(a, state.c(d))).a(b, state.c(a))).a(c, state.c(b))).a(d, state.c(c));
            }
        }
        return state;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.a(a, state.c(c))).a(c, state.c(a));
            }
            case c: {
                return (IBlockData)((IBlockData)state.a(b, state.c(d))).a(d, state.c(b));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c, d, e);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (!player.fO().e) {
            return EnumInteractionResult.d;
        }
        if (BlockRedstoneWire.o(state) || BlockRedstoneWire.p(state)) {
            IBlockData iblockdata1 = BlockRedstoneWire.o(state) ? this.n() : this.G;
            iblockdata1 = (IBlockData)iblockdata1.a(e, state.c(e));
            if ((iblockdata1 = this.a((IBlockAccess)world, iblockdata1, pos)) != state) {
                world.a(pos, iblockdata1, 3);
                this.a(world, pos, state, iblockdata1);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.d;
    }

    private void a(World world, BlockPosition pos, IBlockData oldState, IBlockData newState) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (((BlockPropertyRedstoneSide)oldState.c(f.get(enumdirection))).a() == ((BlockPropertyRedstoneSide)newState.c(f.get(enumdirection))).a() || !world.a_(blockposition1).g(world, blockposition1)) continue;
            world.a(blockposition1, newState.b(), enumdirection.g());
        }
    }
}

