/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import top.leavesmc.leaves.LeavesConfig;

public class BlockSoil
extends Block {
    public static final BlockStateInteger a = BlockProperties.aQ;
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);
    public static final int c = 7;

    protected BlockSoil(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.C.b().a(a, 0));
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == EnumDirection.b && !state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        IBlockData iblockdata1 = world.a_(pos.c());
        return !iblockdata1.e() || iblockdata1.b() instanceof BlockFenceGate || iblockdata1.b() instanceof BlockPistonMoving;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return !this.n().a((IWorldReader)ctx.q(), ctx.a()) ? Blocks.j.n() : super.a(ctx);
    }

    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)world, pos)) {
            BlockSoil.a((net.minecraft.world.entity.Entity)null, state, world, pos);
        }
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2 = state.c(a);
        if (!BlockSoil.a(world, pos) && !world.q(pos.c())) {
            if (i2 > 0) {
                CraftEventFactory.handleMoistureChangeEvent(world, pos, (IBlockData)state.a(a, i2 - 1), 2);
            } else if (!BlockSoil.a((IBlockAccess)world, pos)) {
                BlockSoil.a((net.minecraft.world.entity.Entity)null, state, world, pos);
            }
        } else if (i2 < 7) {
            CraftEventFactory.handleMoistureChangeEvent(world, pos, (IBlockData)state.a(a, 7), 2);
        }
    }

    @Override
    public void a(World world, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, float fallDistance) {
        super.a(world, state, pos, entity, fallDistance);
        if (!world.B && world.z.i() < fallDistance - 0.5f && entity instanceof EntityLiving && (entity instanceof EntityHuman || world.X().b(GameRules.c)) && entity.dd() * entity.dd() * entity.de() > 0.512f) {
            PlayerInteractEvent cancellable;
            if (LeavesConfig.noFeatherFallingTrample && EnchantmentManager.a(Enchantments.c, (EntityLiving)entity) > 0) {
                return;
            }
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.j.n())) {
                return;
            }
            BlockSoil.a(entity, state, world, pos);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, World world, BlockPosition pos) {
        if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.j.n()).isCancelled()) {
            return;
        }
        IBlockData iblockdata1 = BlockSoil.a(state, Blocks.j.n(), world, pos);
        world.b(pos, iblockdata1);
        world.a(GameEvent.c, pos, GameEvent.a.a(entity, iblockdata1));
    }

    private static boolean a(IBlockAccess world, BlockPosition pos) {
        return world.a_(pos.c()).a(TagsBlock.cn);
    }

    private static boolean a(IWorldReader world, BlockPosition pos) {
        int xOff = pos.u();
        int yOff = pos.v();
        int zOff = pos.w();
        for (int dz = -4; dz <= 4; ++dz) {
            int z2 = dz + zOff;
            for (int dx = -4; dx <= 4; ++dx) {
                int x2 = xOff + dx;
                for (int dy = 0; dy <= 1; ++dy) {
                    int y2 = dy + yOff;
                    Chunk chunk = (Chunk)world.a(x2 >> 4, z2 >> 4);
                    Fluid fluid = chunk.getBlockStateFinal(x2, y2, z2).u();
                    if (!fluid.a(TagsFluid.a)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{a});
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

