/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookShelfBlock
extends BlockTileEntity {
    private static final int c = 6;
    public static final int a = 3;
    public static final List<BlockStateBoolean> b = List.of(BlockProperties.bp, BlockProperties.bq, BlockProperties.br, BlockProperties.bs, BlockProperties.bt, BlockProperties.bu);

    public ChiseledBookShelfBlock(BlockBase.Info settings) {
        super(settings);
        IBlockData iblockdata = (IBlockData)this.C.b().a(BlockFacingHorizontal.aC, EnumDirection.c);
        for (BlockStateBoolean blockstateboolean : b) {
            iblockdata = (IBlockData)iblockdata.a(blockstateboolean, false);
        }
        this.k(iblockdata);
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)tileentity;
            Optional<Vec2F> optional = ChiseledBookShelfBlock.a(hit, state.c(BlockFacingHorizontal.aC));
            if (optional.isEmpty()) {
                return EnumInteractionResult.d;
            }
            int i2 = ChiseledBookShelfBlock.a(optional.get());
            if (((Boolean)state.c(b.get(i2))).booleanValue()) {
                ChiseledBookShelfBlock.a(world, pos, player, chiseledbookshelfblockentity, i2);
                return EnumInteractionResult.a(world.B);
            }
            ItemStack itemstack = player.b(hand);
            if (itemstack.a(TagsItem.av)) {
                ChiseledBookShelfBlock.a(world, pos, player, chiseledbookshelfblockentity, itemstack, i2);
                return EnumInteractionResult.a(world.B);
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    private static Optional<Vec2F> a(MovingObjectPositionBlock hit, EnumDirection facing) {
        EnumDirection enumdirection1 = hit.b();
        if (facing != enumdirection1) {
            return Optional.empty();
        }
        BlockPosition blockposition = hit.a().a(enumdirection1);
        Vec3D vec3d = hit.e().a(blockposition.u(), blockposition.v(), blockposition.w());
        double d0 = vec3d.a();
        double d1 = vec3d.b();
        double d2 = vec3d.c();
        return switch (enumdirection1) {
            case EnumDirection.c -> Optional.of(new Vec2F((float)(1.0 - d0), (float)d1));
            case EnumDirection.d -> Optional.of(new Vec2F((float)d0, (float)d1));
            case EnumDirection.e -> Optional.of(new Vec2F((float)d2, (float)d1));
            case EnumDirection.f -> Optional.of(new Vec2F((float)(1.0 - d2), (float)d1));
            case EnumDirection.a, EnumDirection.b -> Optional.empty();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static int a(Vec2F hitPos) {
        int i2 = hitPos.j >= 0.5f ? 0 : 1;
        int j2 = ChiseledBookShelfBlock.a(hitPos.i);
        return j2 + i2 * 3;
    }

    private static int a(float x2) {
        float f1 = 0.0625f;
        float f2 = 0.375f;
        if (x2 < 0.375f) {
            return 0;
        }
        float f3 = 0.6875f;
        return x2 < 0.6875f ? 1 : 2;
    }

    private static void a(World world, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, ItemStack stack, int slot) {
        if (!world.B) {
            player.b(StatisticList.c.b(stack.d()));
            SoundEffect soundeffect = stack.a(Items.tC) ? SoundEffects.et : SoundEffects.es;
            blockEntity.a(slot, stack.a(1));
            world.a((EntityHuman)null, pos, soundeffect, SoundCategory.e, 1.0f, 1.0f);
            if (player.f()) {
                stack.g(1);
            }
            world.a((Entity)player, GameEvent.c, pos);
        }
    }

    private static void a(World world, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, int slot) {
        if (!world.B) {
            ItemStack itemstack = blockEntity.a(slot, 1);
            SoundEffect soundeffect = itemstack.a(Items.tC) ? SoundEffects.ew : SoundEffects.ev;
            world.a((EntityHuman)null, pos, soundeffect, SoundCategory.e, 1.0f, 1.0f);
            if (!player.fN().e(itemstack)) {
                player.a(itemstack, false);
            }
            world.a((Entity)player, GameEvent.c, pos);
        }
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new ChiseledBookShelfBlockEntity(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{BlockFacingHorizontal.aC});
        List<BlockStateBoolean> list = b;
        Objects.requireNonNull(builder);
        list.forEach(iblockstate -> builder.a(new IBlockState[]{(BlockStateBoolean)iblockstate}));
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity;
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof ChiseledBookShelfBlockEntity && !(chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)tileentity).ab_()) {
                for (int i2 = 0; i2 < 6; ++i2) {
                    ItemStack itemstack = chiseledbookshelfblockentity.a(i2);
                    if (itemstack.b()) continue;
                    InventoryUtils.a(world, (double)pos.u(), (double)pos.v(), (double)pos.w(), itemstack);
                }
                chiseledbookshelfblockentity.a();
                world.c(pos, this);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.n().a(BlockFacingHorizontal.aC, ctx.g().g());
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(BlockFacingHorizontal.aC, rotation.a(state.c(BlockFacingHorizontal.aC)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(BlockFacingHorizontal.aC)));
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        if (world.r_()) {
            return 0;
        }
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)tileentity;
            return chiseledbookshelfblockentity.g() + 1;
        }
        return 0;
    }
}

