/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreTileUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger c;
    private final TileEntityTypes<?> d;
    @Nullable
    protected World o;
    protected final BlockPosition p;
    protected boolean q;
    private IBlockData e;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        this.d = type;
        this.p = pos.i();
        this.e = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    public static BlockPosition c(NBTTagCompound nbt) {
        return new BlockPosition(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    @Nullable
    public World k() {
        return this.o;
    }

    public void a(World world) {
        this.o = world;
    }

    public boolean l() {
        return this.o != null;
    }

    public void a(NBTTagCompound nbt) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = nbt.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    protected void b(NBTTagCompound nbt) {
    }

    public final NBTTagCompound m() {
        NBTTagCompound nbttagcompound = this.o();
        this.e(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound n() {
        NBTTagCompound nbttagcompound = this.o();
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound o() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private void d(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.u());
        if (minecraftkey == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbt.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbt, TileEntityTypes<?> type) {
        nbt.a("id", TileEntityTypes.a(type).toString());
    }

    public void e(ItemStack stack) {
        ItemBlock.a(stack, this.u(), this.o());
    }

    private void e(NBTTagCompound nbt) {
        this.d(nbt);
        nbt.a("x", this.p.u());
        nbt.a("y", this.p.v());
        nbt.a("z", this.p.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound nbt) {
        String s2 = nbt.l("id");
        MinecraftKey minecraftkey = MinecraftKey.a(s2);
        if (minecraftkey == null) {
            c.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.l.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(pos, state);
            }
            catch (Throwable throwable) {
                c.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.a(nbt);
                return tileentity;
            }
            catch (Throwable throwable) {
                c.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            c.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.o != null) {
            if (ignoreTileUpdates) {
                return;
            }
            TileEntity.a(this.o, this.p, this.e);
        }
    }

    protected static void a(World world, BlockPosition pos, IBlockData state) {
        world.p(pos);
        if (!state.i()) {
            world.c(pos, state.b());
        }
    }

    public BlockPosition p() {
        return this.p;
    }

    public IBlockData q() {
        return this.e;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> h() {
        return null;
    }

    public NBTTagCompound ao_() {
        return new NBTTagCompound();
    }

    public boolean r() {
        return this.q;
    }

    public void ap_() {
        this.q = true;
    }

    public void s() {
        this.q = false;
    }

    public boolean a_(int type, int data) {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSection) {
        crashReportSection.a("Name", () -> {
            MinecraftKey minecraftkey = BuiltInRegistries.l.b(this.u());
            return minecraftkey + " // " + this.getClass().getCanonicalName();
        });
        if (this.o != null) {
            IBlockData block = this.q();
            if (block != null) {
                CrashReportSystemDetails.a(crashReportSection, this.o, this.p, block);
            }
            CrashReportSystemDetails.a(crashReportSection, this.o, this.p, this.o.a_(this.p));
        }
    }

    public boolean t() {
        return false;
    }

    public TileEntityTypes<?> u() {
        return this.d;
    }

    @Deprecated
    public void b(IBlockData state) {
        this.e = state;
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.o == null) {
            return null;
        }
        Block block = this.o.getWorld().getBlockAt(this.p.u(), this.p.v(), this.p.w());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        c = LogUtils.getLogger();
    }
}

