/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.util.CollisionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] aD = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    public final boolean aE;
    protected final float aF;
    protected final boolean aG;
    protected final SoundEffectType aH;
    protected final float aI;
    protected final float aJ;
    protected final float aK;
    protected final boolean aL;
    protected final FeatureFlagSet aM;
    protected final Info aN;
    @Nullable
    protected MinecraftKey aO;

    public BlockBase(Info settings) {
        this.aE = settings.b;
        this.aO = settings.l;
        this.aF = settings.e;
        this.aG = settings.h;
        this.aH = settings.c;
        this.aI = settings.i;
        this.aJ = settings.j;
        this.aK = settings.k;
        this.aL = settings.C;
        this.aM = settings.D;
        this.aN = settings;
    }

    @Deprecated
    public void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
    }

    @Deprecated
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return !state.r(world, pos);
            }
            case b: {
                return world.b_(pos).a(TagsFluid.a);
            }
            case c: {
                return !state.r(world, pos);
            }
        }
        return false;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return state;
    }

    @Deprecated
    public boolean a(IBlockData state, IBlockData stateFrom, EnumDirection direction) {
        return false;
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        PacketDebug.a(world, pos);
    }

    @Deprecated
    public void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext itemActionContext) {
        this.b(iblockdata, world, blockposition, iblockdata1, flag);
    }

    @Deprecated
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        AsyncCatcher.catchOp("block onPlace");
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        AsyncCatcher.catchOp("block remove");
        if (state.t() && !state.a(newState.b())) {
            world.n(pos);
        }
    }

    @Deprecated
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return EnumInteractionResult.d;
    }

    @Deprecated
    public boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        return false;
    }

    @Deprecated
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Deprecated
    public boolean g_(IBlockData state) {
        return false;
    }

    @Deprecated
    public boolean f_(IBlockData state) {
        return false;
    }

    @Deprecated
    public Fluid c_(IBlockData state) {
        return FluidTypes.a.g();
    }

    @Deprecated
    public boolean d_(IBlockData state) {
        return false;
    }

    public float al_() {
        return 0.25f;
    }

    public float an_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet m() {
        return this.aM;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return state;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state;
    }

    @Deprecated
    public boolean a(IBlockData state, BlockActionContext context) {
        return state.r() && (context.n().b() || !context.n().a(this.k())) && (state.isDestroyable() || context.o() != null && context.o().fO().d);
    }

    @Deprecated
    public boolean a(IBlockData state, FluidType fluid) {
        return state.r() || !state.e();
    }

    @Deprecated
    public List<ItemStack> a(IBlockData state, LootParams.a builder) {
        MinecraftKey minecraftkey = this.r();
        if (minecraftkey == LootTables.a) {
            return Collections.emptyList();
        }
        LootParams lootparams = builder.a(LootContextParameters.g, state).a(LootContextParameterSets.n);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.n().aH().getLootTable(minecraftkey);
        return loottable.a(lootparams);
    }

    @Deprecated
    public long a(IBlockData state, BlockPosition pos) {
        return MathHelper.a(pos);
    }

    @Deprecated
    public VoxelShape f(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.j(world, pos);
    }

    @Deprecated
    public VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.c(state, world, pos, VoxelShapeCollision.a());
    }

    @Deprecated
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return VoxelShapes.a();
    }

    @Deprecated
    public int g(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.i(world, pos) ? world.M() : (state.a(world, pos) ? 0 : 1);
    }

    @Nullable
    @Deprecated
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        return null;
    }

    @Deprecated
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return true;
    }

    @Deprecated
    public float b(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.r(world, pos) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int a(IBlockData state, World world, BlockPosition pos) {
        return 0;
    }

    @Deprecated
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.b();
    }

    @Deprecated
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.aE ? state.j(world, pos) : VoxelShapes.a();
    }

    @Deprecated
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.k(world, pos));
    }

    @Deprecated
    public boolean h(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.c(world, pos));
    }

    @Deprecated
    public VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.c(state, world, pos, context);
    }

    @Deprecated
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        this.a(state, world, pos, random);
    }

    @Deprecated
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
    }

    @Deprecated
    public float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        float f2 = state.h(world, pos);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = player.e(state) ? 30 : 100;
        return player.d(state) / f2 / (float)i2;
    }

    @Deprecated
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
    }

    @Deprecated
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, Entity entity) {
    }

    @Deprecated
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    public final MinecraftKey r() {
        if (this.aO == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.f.b(this.p());
            this.aO = minecraftkey.d("blocks/");
        }
        return this.aO;
    }

    @Deprecated
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
    }

    public abstract Item k();

    protected abstract Block p();

    public MaterialMapColor s() {
        return this.aN.a.apply(this.p().n());
    }

    public float t() {
        return this.aN.f;
    }

    public static class Info {
        Function<IBlockData, MaterialMapColor> a = iblockdata -> MaterialMapColor.a;
        boolean b = true;
        SoundEffectType c = SoundEffectType.f;
        ToIntFunction<IBlockData> d = iblockdata -> 0;
        float e;
        float f;
        boolean g;
        boolean h;
        float i = 0.6f;
        float j = 1.0f;
        float k = 1.0f;
        MinecraftKey l;
        boolean m = true;
        boolean n;
        boolean o;
        @Deprecated
        boolean p;
        @Deprecated
        boolean q;
        boolean r;
        EnumPistonReaction s = EnumPistonReaction.a;
        boolean t = true;
        BlockPropertyInstrument u = BlockPropertyInstrument.a;
        boolean v;
        e<EntityTypes<?>> w = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.d(iblockaccess, blockposition, EnumDirection.b) && iblockdata.h() < 14;
        f x = (iblockdata, iblockaccess, blockposition) -> iblockdata.r(iblockaccess, blockposition);
        f y;
        f z = this.y = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.r(iblockaccess, blockposition);
        f A = (iblockdata, iblockaccess, blockposition) -> false;
        f B = (iblockdata, iblockaccess, blockposition) -> false;
        boolean C;
        FeatureFlagSet D = FeatureFlags.e;
        Optional<b> E = Optional.empty();

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase block) {
            Info blockbase_info = new Info();
            blockbase_info.f = block.aN.f;
            blockbase_info.e = block.aN.e;
            blockbase_info.b = block.aN.b;
            blockbase_info.h = block.aN.h;
            blockbase_info.d = block.aN.d;
            blockbase_info.a = block.aN.a;
            blockbase_info.c = block.aN.c;
            blockbase_info.i = block.aN.i;
            blockbase_info.j = block.aN.j;
            blockbase_info.C = block.aN.C;
            blockbase_info.m = block.aN.m;
            blockbase_info.n = block.aN.n;
            blockbase_info.o = block.aN.o;
            blockbase_info.p = block.aN.p;
            blockbase_info.q = block.aN.q;
            blockbase_info.r = block.aN.r;
            blockbase_info.s = block.aN.s;
            blockbase_info.g = block.aN.g;
            blockbase_info.E = block.aN.E;
            blockbase_info.t = block.aN.t;
            blockbase_info.D = block.aN.D;
            blockbase_info.B = block.aN.B;
            blockbase_info.u = block.aN.u;
            blockbase_info.v = block.aN.v;
            return blockbase_info;
        }

        public Info a(EnumColor color) {
            this.a = iblockdata -> color.e();
            return this;
        }

        public Info a(MaterialMapColor color) {
            this.a = iblockdata -> color;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> mapColorProvider) {
            this.a = mapColorProvider;
            return this;
        }

        public Info b() {
            this.b = false;
            this.m = false;
            return this;
        }

        public Info c() {
            this.m = false;
            return this;
        }

        public Info a(float slipperiness) {
            this.i = slipperiness;
            return this;
        }

        public Info b(float velocityMultiplier) {
            this.j = velocityMultiplier;
            return this;
        }

        public Info c(float jumpVelocityMultiplier) {
            this.k = jumpVelocityMultiplier;
            return this;
        }

        public Info a(SoundEffectType soundGroup) {
            this.c = soundGroup;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> luminance) {
            this.d = luminance;
            return this;
        }

        public Info a(float hardness, float resistance) {
            return this.e(hardness).f(resistance);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float strength) {
            this.a(strength, strength);
            return this;
        }

        public Info e() {
            this.h = true;
            return this;
        }

        public Info f() {
            this.C = true;
            return this;
        }

        public Info g() {
            this.l = LootTables.a;
            return this;
        }

        public Info a(Block source) {
            this.l = source.r();
            return this;
        }

        public Info h() {
            this.o = true;
            return this;
        }

        public Info i() {
            this.p = true;
            return this;
        }

        public Info j() {
            this.r = true;
            return this;
        }

        @Deprecated
        public Info k() {
            this.q = true;
            return this;
        }

        public Info a(EnumPistonReaction pistonBehavior) {
            this.s = pistonBehavior;
            return this;
        }

        public Info l() {
            this.n = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> predicate) {
            this.w = predicate;
            return this;
        }

        public Info a(f predicate) {
            this.x = predicate;
            return this;
        }

        public Info b(f predicate) {
            this.y = predicate;
            return this;
        }

        public Info c(f predicate) {
            this.z = predicate;
            return this;
        }

        public Info d(f predicate) {
            this.A = predicate;
            return this;
        }

        public Info e(f predicate) {
            this.B = predicate;
            return this;
        }

        public Info m() {
            this.g = true;
            return this;
        }

        public Info e(float hardness) {
            this.f = hardness;
            return this;
        }

        public Info f(float resistance) {
            this.e = Math.max(0.0f, resistance);
            return this;
        }

        public Info a(EnumRandomOffset offsetType) {
            switch (offsetType) {
                case c: {
                    this.E = Optional.of((iblockdata, iblockaccess, blockposition) -> {
                        Block block = iblockdata.b();
                        long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                        double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.an_();
                        float f2 = block.al_();
                        double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        return new Vec3D(d1, d0, d2);
                    });
                    break;
                }
                case b: {
                    this.E = Optional.of((iblockdata, iblockaccess, blockposition) -> {
                        Block block = iblockdata.b();
                        long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                        float f2 = block.al_();
                        double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        return new Vec3D(d0, 0.0, d1);
                    });
                    break;
                }
                default: {
                    this.E = Optional.empty();
                }
            }
            return this;
        }

        public Info n() {
            this.t = false;
            return this;
        }

        public Info a(FeatureFlag ... features) {
            this.D = FeatureFlags.c.a(features);
            return this;
        }

        public Info a(BlockPropertyInstrument instrument) {
            this.u = instrument;
            return this;
        }

        public Info o() {
            this.v = true;
            return this;
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private final int b;
        private final boolean g;
        private final boolean h;
        private final boolean i;
        @Deprecated
        private final boolean j;
        @Deprecated
        private boolean k;
        private final EnumPistonReaction l;
        private final MaterialMapColor m;
        public final float n;
        private final boolean o;
        private final boolean p;
        private final f q;
        private final f r;
        private final f s;
        private final f t;
        private final f u;
        private final Optional<b> v;
        private final boolean w;
        private final BlockPropertyInstrument x;
        private final boolean y;
        @Nullable
        protected Cache a;
        private Fluid z = FluidTypes.a.g();
        private boolean A;
        private CraftBlockData cachedCraftBlockData;
        protected boolean shapeExceedsCube = true;
        protected int opacityIfCached = -1;
        protected final boolean conditionallyFullOpaque;
        private long blockCollisionBehavior = 3L;

        public final int getEmittedLight() {
            return this.b;
        }

        public final boolean isTransparentOnSomeFaces() {
            return this.g;
        }

        public final boolean isOpaque() {
            return this.p;
        }

        protected BlockData(Block block, ImmutableMap<IBlockState<?>, Comparable<?>> propertyMap, MapCodec<IBlockData> codec) {
            super(block, propertyMap, codec);
            Info blockbase_info = block.aN;
            this.b = blockbase_info.d.applyAsInt(this.x());
            this.g = block.g_(this.x());
            this.h = blockbase_info.n;
            this.i = blockbase_info.o;
            this.j = blockbase_info.p;
            this.l = blockbase_info.s;
            this.m = blockbase_info.a.apply(this.x());
            this.n = blockbase_info.f;
            this.o = blockbase_info.g;
            this.p = blockbase_info.m;
            this.q = blockbase_info.x;
            this.r = blockbase_info.y;
            this.s = blockbase_info.z;
            this.t = blockbase_info.A;
            this.u = blockbase_info.B;
            this.v = blockbase_info.E;
            this.w = blockbase_info.t;
            this.x = blockbase_info.u;
            this.y = blockbase_info.v;
            this.conditionallyFullOpaque = this.isOpaque() & this.isTransparentOnSomeFaces();
        }

        public CraftBlockData createCraftBlockData() {
            if (this.cachedCraftBlockData == null) {
                this.cachedCraftBlockData = CraftBlockData.createData(this.x());
            }
            return (CraftBlockData)this.cachedCraftBlockData.clone();
        }

        private boolean D() {
            if (((Block)this.e).aN.r) {
                return true;
            }
            if (((Block)this.e).aN.q) {
                return false;
            }
            if (this.a == null) {
                return false;
            }
            VoxelShape voxelshape = this.a.b;
            if (voxelshape.b()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public final boolean shapeExceedsCube() {
            return this.shapeExceedsCube;
        }

        public final int getOpacityIfCached() {
            return this.opacityIfCached;
        }

        public final boolean isConditionallyFullOpaque() {
            return this.conditionallyFullOpaque;
        }

        public final long getBlockCollisionBehavior() {
            return this.blockCollisionBehavior;
        }

        public void a() {
            this.z = ((Block)this.e).c_(this.x());
            this.A = ((Block)this.e).e_(this.x());
            if (!this.b().o()) {
                this.a = new Cache(this.x());
            }
            this.shapeExceedsCube = this.a == null || this.a.c;
            this.opacityIfCached = this.a == null || this.isConditionallyFullOpaque() ? -1 : this.a.h;
            this.k = this.D();
            if (CollisionUtil.isSpecialCollidingBlock(this)) {
                this.blockCollisionBehavior = 3L;
            } else {
                try {
                    VoxelShape constantShape = this.b((IBlockAccess)null, (BlockPosition)null, (VoxelShapeCollision)null);
                    if (constantShape == null) {
                        this.blockCollisionBehavior = 2L;
                    } else if ((constantShape = constantShape.c()).b()) {
                        this.blockCollisionBehavior = 0L;
                    } else {
                        List<AxisAlignedBB> boxes = constantShape.d();
                        this.blockCollisionBehavior = constantShape == VoxelShapes.getFullUnoptimisedCube() || boxes.size() == 1 && boxes.get(0).equals(VoxelShapes.BLOCK_OPTIMISED.aabb) ? 1L : 2L;
                    }
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    this.blockCollisionBehavior = 2L;
                }
            }
        }

        public Block b() {
            return (Block)this.e;
        }

        public Holder<Block> c() {
            return ((Block)this.e).q();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bs && block != Blocks.mY && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.k;
        }

        public final boolean isDestroyable() {
            return this.b().isDestroyable();
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EntityTypes<?> type) {
            return this.b().aN.w.test(this.x(), world, pos, type);
        }

        public boolean a(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.g : this.b().c(this.x(), world, pos);
        }

        public int b(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.h : this.b().g(this.x(), world, pos);
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a != null && this.a.i != null ? this.a.i[direction.ordinal()] : VoxelShapes.a(this.c(world, pos), direction);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos) {
            return this.b().f(this.x(), world, pos);
        }

        public final boolean f() {
            return this.shapeExceedsCube;
        }

        public final boolean g() {
            return this.g;
        }

        public final int h() {
            return this.b;
        }

        public final boolean i() {
            return this.h;
        }

        public boolean j() {
            return this.i;
        }

        @Deprecated
        public boolean k() {
            return this.j;
        }

        public MaterialMapColor d(IBlockAccess world, BlockPosition pos) {
            return this.m;
        }

        public IBlockData a(EnumBlockRotation rotation) {
            return this.b().a(this.x(), rotation);
        }

        public IBlockData a(EnumBlockMirror mirror) {
            return this.b().a(this.x(), mirror);
        }

        public EnumRenderType l() {
            return this.b().b_(this.x());
        }

        public boolean e(IBlockAccess world, BlockPosition pos) {
            return this.u.test(this.x(), world, pos);
        }

        public float f(IBlockAccess world, BlockPosition pos) {
            return this.b().b(this.x(), world, pos);
        }

        public boolean g(IBlockAccess world, BlockPosition pos) {
            return this.q.test(this.x(), world, pos);
        }

        public boolean m() {
            return this.b().f_(this.x());
        }

        public int b(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.x(), world, pos, direction);
        }

        public boolean n() {
            return this.b().d_(this.x());
        }

        public int a(World world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public float h(IBlockAccess world, BlockPosition pos) {
            return this.n;
        }

        public float a(EntityHuman player, IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.x(), player, world, pos);
        }

        public int c(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().b(this.x(), world, pos, direction);
        }

        public EnumPistonReaction o() {
            return !this.isDestroyable() ? EnumPistonReaction.c : (this.b().getResetPushReaction() == null ? this.l : this.b().getResetPushReaction());
        }

        public boolean i(IBlockAccess world, BlockPosition pos) {
            if (this.a != null) {
                return this.a.a;
            }
            IBlockData iblockdata = this.x();
            return iblockdata.p() ? Block.a(iblockdata.c(world, pos)) : false;
        }

        public final boolean p() {
            return this.p;
        }

        public boolean a(IBlockData state, EnumDirection direction) {
            return this.b().a(this.x(), state, direction);
        }

        public VoxelShape j(IBlockAccess world, BlockPosition pos) {
            return this.a(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().a(this.x(), world, pos, context);
        }

        public VoxelShape k(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.b : this.b(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().c(this.x(), world, pos, context);
        }

        public VoxelShape l(IBlockAccess world, BlockPosition pos) {
            return this.b().b_(this.x(), world, pos);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().b(this.x(), world, pos, context);
        }

        public VoxelShape m(IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity) {
            return this.a(world, pos, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity, EnumDirection direction) {
            return Block.a(this.b(world, pos, VoxelShapeCollision.a(entity)), direction);
        }

        public Vec3D n(IBlockAccess world, BlockPosition pos) {
            return this.v.map(blockbase_b -> blockbase_b.evaluate(this.x(), world, pos)).orElse(Vec3D.b);
        }

        public boolean q() {
            return !this.v.isEmpty();
        }

        public boolean a(World world, BlockPosition pos, int type, int data) {
            return this.b().a(this.x(), world, pos, type, data);
        }

        @Deprecated
        public void a(World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
            this.b().a(this.x(), world, pos, sourceBlock, sourcePos, notify);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags) {
            this.a(world, pos, flags, 512);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : aD) {
                blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
                world.a(enumdirection.g(), this.x(), blockposition_mutableblockposition, pos, flags, maxUpdateDepth);
            }
        }

        public final void b(GeneratorAccess world, BlockPosition pos, int flags) {
            this.b(world, pos, flags, 512);
        }

        public void b(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            this.b().a(this.x(), world, pos, flags, maxUpdateDepth);
        }

        public void a(World world, BlockPosition pos, IBlockData state, boolean notify) {
            this.b().b(this.x(), world, pos, state, notify);
        }

        public void b(World world, BlockPosition pos, IBlockData state, boolean moved) {
            this.b().a(this.x(), world, pos, state, moved);
        }

        public void a(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().a(this.x(), world, pos, random);
        }

        public void b(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().b(this.x(), world, pos, random);
        }

        public void a(World world, BlockPosition pos, Entity entity) {
            this.b().a(this.x(), world, pos, entity);
        }

        public void a(WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
            this.b().a(this.x(), world, pos, tool, dropExperience);
        }

        public List<ItemStack> a(LootParams.a builder) {
            return this.b().a(this.x(), builder);
        }

        public EnumInteractionResult a(World world, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
            return this.b().a(this.x(), world, hit.a(), player, hand, hit);
        }

        public void a(World world, BlockPosition pos, EntityHuman player) {
            this.b().a(this.x(), world, pos, player);
        }

        public boolean o(IBlockAccess world, BlockPosition pos) {
            return this.r.test(this.x(), world, pos);
        }

        public boolean p(IBlockAccess world, BlockPosition pos) {
            return this.s.test(this.x(), world, pos);
        }

        public IBlockData a(EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
            return this.b().a(this.x(), direction, neighborState, world, pos, neighborPos);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, PathMode type) {
            return this.b().a(this.x(), world, pos, type);
        }

        public boolean a(BlockActionContext context) {
            return this.b().a(this.x(), context);
        }

        public boolean a(FluidType fluid) {
            return this.b().a(this.x(), fluid);
        }

        public boolean r() {
            return this.y;
        }

        public boolean a(IWorldReader world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public boolean q(IBlockAccess world, BlockPosition pos) {
            return this.t.test(this.x(), world, pos);
        }

        @Nullable
        public ITileInventory b(World world, BlockPosition pos) {
            return this.b().b(this.x(), world, pos);
        }

        @Override
        public boolean a(TagKey<Block> tag) {
            return this.b().q().a(tag);
        }

        @Override
        public boolean a(TagKey<Block> tag, Predicate<BlockData> predicate) {
            return this.a(tag) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> blocks) {
            return blocks.a(this.b().q());
        }

        public Stream<TagKey<Block>> s() {
            return this.b().q().c();
        }

        public boolean t() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> blockEntityType) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.x(), blockEntityType) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        public final Fluid u() {
            return this.z;
        }

        public final boolean v() {
            return this.A;
        }

        public long a(BlockPosition pos) {
            return this.b().a(this.x(), pos);
        }

        public SoundEffectType w() {
            return this.b().m(this.x());
        }

        public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
            this.b().a(world, state, hit, projectile);
        }

        public boolean d(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a(world, pos, direction, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction, EnumBlockSupport shapeType) {
            return this.a != null ? this.a.a(direction, shapeType) : shapeType.a(this.x(), world, pos, direction);
        }

        public boolean r(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.d : this.b().a_(this.x(), world, pos);
        }

        protected abstract IBlockData x();

        public boolean y() {
            return this.o;
        }

        public boolean z() {
            return this.w;
        }

        public BlockPropertyInstrument A() {
            return this.x;
        }

        private static final class Cache {
            private static final EnumDirection[] e = EnumDirection.values();
            private static final int f = EnumBlockSupport.values().length;
            protected final boolean a;
            final boolean g;
            final int h;
            @Nullable
            final VoxelShape[] i;
            protected final VoxelShape b;
            protected final boolean c;
            private final boolean[] j;
            protected final boolean d;

            Cache(IBlockData state) {
                Block block = state.b();
                this.a = state.i(BlockAccessAir.a, BlockPosition.b);
                this.g = block.c(state, BlockAccessAir.a, BlockPosition.b);
                this.h = block.g(state, BlockAccessAir.a, BlockPosition.b);
                if (!state.p()) {
                    this.i = null;
                } else {
                    this.i = new VoxelShape[e.length];
                    VoxelShape voxelshape = block.f(state, BlockAccessAir.a, BlockPosition.b);
                    EnumDirection[] aenumdirection = e;
                    int i2 = aenumdirection.length;
                    for (int j2 = 0; j2 < i2; ++j2) {
                        EnumDirection enumdirection = aenumdirection[j2];
                        this.i[enumdirection.ordinal()] = VoxelShapes.a(voxelshape, enumdirection);
                    }
                }
                this.b = block.c(state, BlockAccessAir.a, BlockPosition.b, VoxelShapeCollision.a());
                if (!this.b.b() && state.q()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.f.b(block)));
                }
                this.c = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.b.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.b.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.j = new boolean[e.length * f];
                for (EnumDirection enumdirection1 : e) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.j[Cache.b((EnumDirection)enumdirection1, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(state, BlockAccessAir.a, BlockPosition.b, enumdirection1);
                    }
                }
                this.d = Block.a(state.k(BlockAccessAir.a, BlockPosition.b));
            }

            public boolean a(EnumDirection direction, EnumBlockSupport shapeType) {
                return this.j[Cache.b(direction, shapeType)];
            }

            private static int b(EnumDirection direction, EnumBlockSupport shapeType) {
                return direction.ordinal() * f + shapeType.ordinal();
            }
        }
    }

    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface b {
        public Vec3D evaluate(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }
}

