/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockStateInteger
extends IBlockState<Integer> {
    private final ImmutableSet<Integer> a;
    public final int b;
    public final int c;

    @Override
    public final int getIdFor(Integer value) {
        int val = value;
        int ret = val - this.b;
        return ret | this.c - ret >> 31;
    }

    protected BlockStateInteger(String name, int min, int max) {
        super(name, Integer.class);
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max <= min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        this.b = min;
        this.c = max;
        HashSet set = Sets.newHashSet();
        for (int i2 = min; i2 <= max; ++i2) {
            set.add(i2);
        }
        this.a = ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public Collection<Integer> a() {
        return this.a;
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BlockStateInteger && super.equals(object)) {
            BlockStateInteger integerProperty = (BlockStateInteger)object;
            return this.a.equals(integerProperty.a);
        }
        return false;
    }

    @Override
    public int b() {
        return 31 * super.b() + this.a.hashCode();
    }

    public static BlockStateInteger a(String name, int min, int max) {
        return new BlockStateInteger(name, min, max);
    }

    @Override
    public Optional<Integer> b(String name) {
        try {
            Integer integer = Integer.valueOf(name);
            return integer >= this.b && integer <= this.c ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException var3) {
            return Optional.empty();
        }
    }

    @Override
    public String a(Integer value) {
        return value.toString();
    }
}

