/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ChunkStatus {
    public boolean isParallelCapable;
    public int writeRadius = -1;
    public int loadRange = 0;
    protected static final List<ChunkStatus> statuses = new ArrayList<ChunkStatus>();
    private ChunkStatus nextStatus;
    public final AtomicBoolean warnedAboutNoImmediateComplete = new AtomicBoolean();
    public static final int a = 8;
    private static final EnumSet<HeightMap.Type> o = EnumSet.of(HeightMap.Type.c, HeightMap.Type.a);
    public static final EnumSet<HeightMap.Type> b = EnumSet.of(HeightMap.Type.d, HeightMap.Type.b, HeightMap.Type.e, HeightMap.Type.f);
    private static final c p = (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> CompletableFuture.completedFuture(Either.left(ichunkaccess));
    public static final ChunkStatus c = ChunkStatus.a("empty", (ChunkStatus)null, -1, o, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {});
    public static final ChunkStatus d = ChunkStatus.a("structure_starts", c, 0, false, o, Type.a, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess) -> {
        if (worldserver.K.A().c()) {
            chunkgenerator.a(worldserver.B_(), worldserver.k().h(), worldserver.a(), ichunkaccess, structuretemplatemanager);
        }
        worldserver.a(ichunkaccess);
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    }, (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> {
        worldserver.a(ichunkaccess);
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    });
    public static final ChunkStatus e = ChunkStatus.a("structure_references", d, 8, o, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1);
        chunkgenerator.a((GeneratorAccessSeed)regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), ichunkaccess);
    });
    public static final ChunkStatus f = ChunkStatus.a("biomes", e, 8, o, Type.a, (ChunkStatus chunkstatus, Executor executor, WorldServer worldserver, ChunkGenerator chunkgenerator, StructureTemplateManager structuretemplatemanager, LightEngineThreaded lightenginethreaded, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1);
        return chunkgenerator.a(executor, worldserver.k().i(), Blender.a(regionlimitedworldaccess), worldserver.a().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> Either.left(ichunkaccess1));
    });
    public static final ChunkStatus g = ChunkStatus.a("noise", f, 8, o, Type.a, (ChunkStatus chunkstatus, Executor executor, WorldServer worldserver, ChunkGenerator chunkgenerator, StructureTemplateManager structuretemplatemanager, LightEngineThreaded lightenginethreaded, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        return chunkgenerator.a(executor, Blender.a(regionlimitedworldaccess), worldserver.k().i(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).x()) != null) {
                BelowZeroRetrogen.a(protochunk);
                if (belowzeroretrogen.b()) {
                    belowzeroretrogen.b(protochunk);
                }
            }
            return Either.left(ichunkaccess1);
        });
    });
    public static final ChunkStatus h = ChunkStatus.a("surface", g, 8, o, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        chunkgenerator.a(regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), worldserver.k().i(), ichunkaccess);
    });
    public static final ChunkStatus i = ChunkStatus.a("carvers", h, 8, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            Blender.a((GeneratorAccessSeed)regionlimitedworldaccess, protochunk);
        }
        chunkgenerator.a(regionlimitedworldaccess, worldserver.A(), worldserver.k().i(), worldserver.z_(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess, WorldGenStage.Features.a);
    });
    public static final ChunkStatus j = ChunkStatus.a("features", i, 8, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        HeightMap.a(ichunkaccess, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 1);
        chunkgenerator.a((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, worldserver.a().a(regionlimitedworldaccess));
        Blender.a(regionlimitedworldaccess, ichunkaccess);
    });
    public static final ChunkStatus k = ChunkStatus.a("initialize_light", j, 0, false, b, Type.a, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess) -> ChunkStatus.a(lightenginethreaded, ichunkaccess), (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> ChunkStatus.a(lightenginethreaded, ichunkaccess));
    public static final ChunkStatus l = ChunkStatus.a("light", k, 1, true, b, Type.a, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess) -> ChunkStatus.b(lightenginethreaded, ichunkaccess), (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> ChunkStatus.b(lightenginethreaded, ichunkaccess));
    public static final ChunkStatus m = ChunkStatus.a("spawn", l, 0, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        if (!ichunkaccess.y()) {
            chunkgenerator.a(new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1));
        }
    });
    public static final ChunkStatus n = ChunkStatus.a("full", m, 0, false, b, Type.b, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess) -> (CompletableFuture)function.apply(ichunkaccess), (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> (CompletableFuture)function.apply(ichunkaccess));
    private static final List<ChunkStatus> q = ImmutableList.of((Object)n, (Object)k, (Object)i, (Object)f, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object[])new ChunkStatus[0]);
    private static final IntList r = (IntList)SystemUtils.a(new IntArrayList(ChunkStatus.a().size()), (T intarraylist) -> {
        int i2 = 0;
        for (int j2 = ChunkStatus.a().size() - 1; j2 >= 0; --j2) {
            while (i2 + 1 < q.size() && j2 <= q.get(i2 + 1).c()) {
                ++i2;
            }
            intarraylist.add(0, i2);
        }
    });
    private final int s;
    private final ChunkStatus t;
    private final b u;
    private final c v;
    private final int w;
    private final boolean x;
    private final Type y;
    private final EnumSet<HeightMap.Type> z;

    public final ChunkStatus getNextStatus() {
        return this.nextStatus;
    }

    public final boolean isEmptyLoadStatus() {
        return this.v == p;
    }

    public final boolean isEmptyGenStatus() {
        return this == c;
    }

    private static CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(LightEngineThreaded lightingProvider, IChunkAccess chunk) {
        chunk.A();
        ((ProtoChunk)chunk).a(lightingProvider);
        boolean flag = ChunkStatus.a(chunk);
        return CompletableFuture.completedFuture(Either.left(chunk));
    }

    private static CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(LightEngineThreaded lightingProvider, IChunkAccess chunk) {
        boolean flag = ChunkStatus.a(chunk);
        return CompletableFuture.completedFuture(Either.left(chunk));
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, d task) {
        return ChunkStatus.a(id, previous, taskMargin, heightMapTypes, chunkType, (b)task);
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b task) {
        return ChunkStatus.a(id, previous, taskMargin, false, heightMapTypes, chunkType, task, p);
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, boolean shouldAlwaysUpgrade, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b generationTask, c loadTask) {
        return IRegistry.a(BuiltInRegistries.o, id, new ChunkStatus(previous, taskMargin, shouldAlwaysUpgrade, heightMapTypes, chunkType, generationTask, loadTask));
    }

    public static List<ChunkStatus> a() {
        ChunkStatus chunkstatus;
        ArrayList list = Lists.newArrayList();
        for (chunkstatus = n; chunkstatus.d() != chunkstatus; chunkstatus = chunkstatus.d()) {
            list.add(chunkstatus);
        }
        list.add(chunkstatus);
        Collections.reverse(list);
        return list;
    }

    private static boolean a(IChunkAccess chunk) {
        return chunk.j().b(l) && chunk.v();
    }

    public static ChunkStatus a(int level) {
        return level >= q.size() ? c : (level < 0 ? n : q.get(level));
    }

    public static int b() {
        return q.size();
    }

    public static int a(ChunkStatus status) {
        return r.getInt(status.c());
    }

    ChunkStatus(@Nullable ChunkStatus previous, int taskMargin, boolean shouldAlwaysUpgrade, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b generationTask, c loadTask) {
        this.t = previous == null ? this : previous;
        this.u = generationTask;
        this.v = loadTask;
        this.w = taskMargin;
        this.x = shouldAlwaysUpgrade;
        this.y = chunkType;
        this.z = heightMapTypes;
        this.s = previous == null ? 0 : previous.c() + 1;
        this.nextStatus = this;
        if (statuses.size() > 0) {
            ChunkStatus.statuses.get((int)(ChunkStatus.statuses.size() - 1)).nextStatus = this;
        }
        statuses.add(this);
    }

    public int c() {
        return this.s;
    }

    public ChunkStatus d() {
        return this.t;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(Executor executor, WorldServer world, ChunkGenerator generator, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, List<IChunkAccess> chunks) {
        IChunkAccess ichunkaccess = chunks.get(chunks.size() / 2);
        ProfiledDuration profiledduration = JvmProfiler.e.a(ichunkaccess.f(), world.ac(), this.toString());
        return this.u.doWork(this, executor, world, generator, structureTemplateManager, lightingProvider, fullChunkConverter, chunks, ichunkaccess).thenApply(either -> {
            either.ifLeft(ichunkaccess1 -> {
                ProtoChunk protochunk;
                if (ichunkaccess1 instanceof ProtoChunk && !(protochunk = (ProtoChunk)ichunkaccess1).j().b(this)) {
                    protochunk.a(this);
                }
            });
            if (profiledduration != null) {
                profiledduration.finish();
            }
            return either;
        });
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(WorldServer world, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, IChunkAccess chunk) {
        return this.v.doWork(this, world, structureTemplateManager, lightingProvider, fullChunkConverter, chunk);
    }

    public int e() {
        return this.w;
    }

    public boolean f() {
        return this.x;
    }

    public Type g() {
        return this.y;
    }

    public static ChunkStatus getStatus(String name) {
        try {
            MinecraftKey key = new MinecraftKey(name);
            return BuiltInRegistries.o.b(key).orElse(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ChunkStatus a(String id) {
        return BuiltInRegistries.o.a(MinecraftKey.a(id));
    }

    public EnumSet<HeightMap.Type> h() {
        return this.z;
    }

    public boolean b(ChunkStatus chunkStatus) {
        return this.c() >= chunkStatus.c();
    }

    public String toString() {
        return BuiltInRegistries.o.b(this).toString();
    }

    private static interface c {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, WorldServer var2, StructureTemplateManager var3, LightEngineThreaded var4, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var5, IChunkAccess var6);
    }

    public static enum Type {
        a,
        b;

    }

    private static interface b {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, Executor var2, WorldServer var3, ChunkGenerator var4, StructureTemplateManager var5, LightEngineThreaded var6, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var7, List<IChunkAccess> var8, IChunkAccess var9);
    }

    private static interface d
    extends b {
        @Override
        default public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus targetStatus, Executor executor, WorldServer world, ChunkGenerator generator, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, List<IChunkAccess> chunks, IChunkAccess chunk) {
            this.doWork(targetStatus, world, generator, chunks, chunk);
            return CompletableFuture.completedFuture(Either.left(chunk));
        }

        public void doWork(ChunkStatus var1, WorldServer var2, ChunkGenerator var3, List<IChunkAccess> var4, IChunkAccess var5);
    }
}

