/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.VisibleForDebug;

public class NibbleArray {
    public static final int a = 16;
    public static final int b = 128;
    public static final int c = 2048;
    private static final int e = 4;
    @Nullable
    protected byte[] d;
    private int f;

    public NibbleArray() {
        this(0);
    }

    public NibbleArray(int defaultValue) {
        this.f = defaultValue;
    }

    public NibbleArray(byte[] bytes) {
        this.d = bytes;
        this.f = 0;
        if (bytes.length != 2048) {
            throw SystemUtils.b(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + bytes.length));
        }
    }

    public int a(int x2, int y2, int z2) {
        return this.d(NibbleArray.b(x2, y2, z2));
    }

    public void a(int x2, int y2, int z2, int value) {
        this.a(NibbleArray.b(x2, y2, z2), value);
    }

    private static int b(int x2, int y2, int z2) {
        return y2 << 8 | z2 << 4 | x2;
    }

    private int d(int index) {
        if (this.d == null) {
            return this.f;
        }
        int j2 = NibbleArray.f(index);
        int k2 = NibbleArray.e(index);
        return this.d[j2] >> 4 * k2 & 0xF;
    }

    private void a(int index, int value) {
        byte[] abyte = this.a();
        int k2 = NibbleArray.f(index);
        int l2 = NibbleArray.e(index);
        int i1 = ~(15 << 4 * l2);
        int j1 = (value & 0xF) << 4 * l2;
        abyte[k2] = (byte)(abyte[k2] & i1 | j1);
    }

    private static int e(int i2) {
        return i2 & 1;
    }

    private static int f(int i2) {
        return i2 >> 1;
    }

    public void a(int defaultValue) {
        this.f = defaultValue;
        this.d = null;
    }

    private static byte g(int value) {
        byte b0 = (byte)value;
        for (int j2 = 4; j2 < 8; j2 += 4) {
            b0 = (byte)(b0 | value << j2);
        }
        return b0;
    }

    public byte[] a() {
        if (this.d == null) {
            this.d = new byte[2048];
            if (this.f != 0) {
                Arrays.fill(this.d, NibbleArray.g(this.f));
            }
        }
        return this.d;
    }

    public NibbleArray b() {
        return this.d == null ? new NibbleArray(this.f) : new NibbleArray((byte[])this.d.clone());
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        for (int i2 = 0; i2 < 4096; ++i2) {
            stringbuilder.append(Integer.toHexString(this.d(i2)));
            if ((i2 & 0xF) == 15) {
                stringbuilder.append("\n");
            }
            if ((i2 & 0xFF) != 255) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    @VisibleForDebug
    public String b(int unused) {
        StringBuilder stringbuilder = new StringBuilder();
        for (int j2 = 0; j2 < 256; ++j2) {
            stringbuilder.append(Integer.toHexString(this.d(j2)));
            if ((j2 & 0xF) != 15) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    public boolean c() {
        return this.d == null;
    }

    public boolean c(int expectedDefaultValue) {
        return this.d == null && this.f == expectedDefaultValue;
    }

    public boolean d() {
        return this.d == null && this.f == 0;
    }
}

