/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCanyon
extends WorldGenCarverAbstract<CanyonCarverConfiguration> {
    public WorldGenCanyon(Codec<CanyonCarverConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(CanyonCarverConfiguration config, RandomSource random) {
        return random.i() <= config.l;
    }

    @Override
    @Override
    public boolean a(CarvingContext context, CanyonCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, RandomSource random, Aquifer aquiferSampler, ChunkCoordIntPair pos, CarvingMask mask) {
        int i2 = (this.d() * 2 - 1) * 16;
        double d2 = pos.a(random.a(16));
        int j2 = config.e.a(random, context);
        double e2 = pos.b(random.a(16));
        float f2 = random.i() * ((float)Math.PI * 2);
        float g2 = config.b.a(random);
        double h2 = config.f.a(random);
        float k2 = config.c.c.a(random);
        int l2 = (int)((float)i2 * config.c.b.a(random));
        boolean m2 = false;
        this.a(context, config, chunk, posToBiome, random.g(), aquiferSampler, d2, j2, e2, k2, f2, g2, 0, l2, h2, mask);
        return true;
    }

    private void a(CarvingContext context2, CanyonCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, long seed, Aquifer aquiferSampler, double x2, double y3, double z2, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask) {
        RandomSource randomSource = RandomSource.a(seed);
        float[] fs = this.a(context2, config, randomSource);
        float f2 = 0.0f;
        float g2 = 0.0f;
        for (int i2 = branchStartIndex; i2 < branchCount; ++i2) {
            double d2 = 1.5 + (double)(MathHelper.a((float)i2 * (float)Math.PI / (float)branchCount) * width);
            double e2 = d2 * yawPitchRatio;
            d2 *= (double)config.c.e.a(randomSource);
            e2 = this.a(config, randomSource, e2, branchCount, i2);
            float h2 = MathHelper.b(pitch);
            float j2 = MathHelper.a(pitch);
            x2 += (double)(MathHelper.b(yaw) * h2);
            y3 += (double)j2;
            z2 += (double)(MathHelper.a(yaw) * h2);
            pitch *= 0.7f;
            pitch += g2 * 0.05f;
            yaw += f2 * 0.05f;
            g2 *= 0.8f;
            f2 *= 0.5f;
            g2 += (randomSource.i() - randomSource.i()) * randomSource.i() * 2.0f;
            f2 += (randomSource.i() - randomSource.i()) * randomSource.i() * 4.0f;
            if (randomSource.a(4) == 0) continue;
            if (!WorldGenCanyon.a(chunk.f(), x2, z2, i2, branchCount, width)) {
                return;
            }
            this.a(context2, config, chunk, posToBiome, aquiferSampler, x2, y3, z2, d2, e2, mask, (context, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y2) -> this.a(context, fs, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y2));
        }
    }

    private float[] a(CarvingContext context, CanyonCarverConfiguration config, RandomSource random) {
        int i2 = context.b();
        float[] fs = new float[i2];
        float f2 = 1.0f;
        for (int j2 = 0; j2 < i2; ++j2) {
            if (j2 == 0 || random.a(config.c.d) == 0) {
                f2 = 1.0f + random.i() * random.i();
            }
            fs[j2] = f2 * f2;
        }
        return fs;
    }

    private double a(CanyonCarverConfiguration config, RandomSource random, double pitch, float branchCount, float branchIndex) {
        float f2 = 1.0f - MathHelper.e(0.5f - branchIndex / branchCount) * 2.0f;
        float g2 = config.c.f + config.c.g * f2;
        return (double)g2 * pitch * (double)MathHelper.b(random, 0.75f, 1.0f);
    }

    private boolean a(CarvingContext context, float[] horizontalStretchFactors, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y2) {
        int i2 = y2 - context.a();
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)horizontalStretchFactors[i2 - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }
}

