/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class PlacedFeature
extends Record {
    private final Holder<WorldGenFeatureConfigured<?, ?>> e;
    private final List<PlacementModifier> f;
    public static final Codec<PlacedFeature> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldGenFeatureConfigured.b.fieldOf("feature").forGetter(placedFeature -> placedFeature.e), (App)PlacementModifier.b.listOf().fieldOf("placement").forGetter(placedFeature -> placedFeature.f)).apply((Applicative)instance, PlacedFeature::new));
    public static final Codec<Holder<PlacedFeature>> b = RegistryFileCodec.a(Registries.ay, a);
    public static final Codec<HolderSet<PlacedFeature>> c = RegistryCodecs.a(Registries.ay, a);
    public static final Codec<List<HolderSet<PlacedFeature>>> d = RegistryCodecs.a(Registries.ay, a, true).listOf();

    public PlacedFeature(Holder<WorldGenFeatureConfigured<?, ?>> holder, List<PlacementModifier> placementModifiers) {
        this.e = holder;
        this.f = placementModifiers;
    }

    public boolean a(GeneratorAccessSeed world, ChunkGenerator generator, RandomSource random, BlockPosition pos) {
        return this.a(new PlacementContext(world, generator, Optional.empty()), random, pos);
    }

    public boolean b(GeneratorAccessSeed world, ChunkGenerator generator, RandomSource random, BlockPosition pos) {
        return this.a(new PlacementContext(world, generator, Optional.of(this)), random, pos);
    }

    private boolean a(PlacementContext context, RandomSource random, BlockPosition pos2) {
        Stream<BlockPosition> stream = Stream.of(pos2);
        for (PlacementModifier placementModifier : this.f) {
            stream = stream.flatMap(pos -> placementModifier.a_(context, random, (BlockPosition)pos));
        }
        WorldGenFeatureConfigured<?, ?> configuredFeature = this.e.a();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(placedPos -> {
            if (configuredFeature.a(context.d(), context.f(), random, (BlockPosition)placedPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> a() {
        return this.e.a().a();
    }

    @Override
    @Override
    public String toString() {
        return "Placed " + this.e;
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlacedFeature.class, "feature;placement", "e", "f"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlacedFeature.class, "feature;placement", "e", "f"}, this, object);
    }

    public Holder<WorldGenFeatureConfigured<?, ?>> b() {
        return this.e;
    }

    public List<PlacementModifier> c() {
        return this.f;
    }
}

