/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class Structure {
    public static final Codec<Structure> a = BuiltInRegistries.U.q().dispatch(Structure::e, StructureType::codec);
    public static final Codec<Holder<Structure>> b = RegistryFileCodec.a(Registries.az, a);
    protected final c c;

    public static <S extends Structure> RecordCodecBuilder<S, c> a(RecordCodecBuilder.Instance<S> instance) {
        return net.minecraft.world.level.levelgen.structure.Structure$c.a.forGetter(feature -> feature.c);
    }

    public static <S extends Structure> Codec<S> a(Function<c, S> featureCreator) {
        return RecordCodecBuilder.create(instance -> instance.group(Structure.a(instance)).apply((Applicative)instance, featureCreator));
    }

    protected Structure(c config) {
        this.c = config;
    }

    public HolderSet<BiomeBase> a() {
        return this.c.b;
    }

    public Map<EnumCreatureType, StructureSpawnOverride> b() {
        return this.c.c;
    }

    public WorldGenStage.Decoration c() {
        return this.c.d;
    }

    public TerrainAdjustment d() {
        return this.c.e;
    }

    public StructureBoundingBox a(StructureBoundingBox box) {
        if (this.d() != TerrainAdjustment.a) {
            return box.a(12);
        }
        return box;
    }

    public StructureStart a(IRegistryCustom dynamicRegistryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, RandomState noiseConfig, StructureTemplateManager structureTemplateManager, long seed, ChunkCoordIntPair chunkPos, int references, LevelHeightAccessor world, Predicate<Holder<BiomeBase>> validBiomes) {
        StructurePiecesBuilder structurePiecesBuilder;
        StructureStart structureStart;
        a generationContext = new a(dynamicRegistryManager, chunkGenerator, biomeSource, noiseConfig, structureTemplateManager, seed, chunkPos, world, validBiomes);
        Optional<b> optional = this.b(generationContext);
        if (optional.isPresent() && (structureStart = new StructureStart(this, chunkPos, references, (structurePiecesBuilder = optional.get().a()).a())).b()) {
            return structureStart;
        }
        return StructureStart.b;
    }

    protected static Optional<b> a(a context, HeightMap.Type heightmap, Consumer<StructurePiecesBuilder> generator) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = chunkPos.b();
        int j2 = chunkPos.c();
        int k2 = context.b().c(i2, j2, heightmap, context.i(), context.d());
        return Optional.of(new b(new BlockPosition(i2, k2, j2), generator));
    }

    private static boolean a(b result, a context) {
        BlockPosition blockPos = result.b();
        return context.j.test(context.b.c().getNoiseBiome(QuartPos.a(blockPos.u()), QuartPos.a(blockPos.v()), QuartPos.a(blockPos.w()), context.d.b()));
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, PiecesContainer pieces) {
    }

    private static int[] b(a context, int x2, int width, int z2, int height) {
        ChunkGenerator chunkGenerator = context.b();
        LevelHeightAccessor levelHeightAccessor = context.i();
        RandomState randomState = context.d();
        return new int[]{chunkGenerator.c(x2, z2, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(x2, z2 + height, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(x2 + width, z2, HeightMap.Type.a, levelHeightAccessor, randomState), chunkGenerator.c(x2 + width, z2 + height, HeightMap.Type.a, levelHeightAccessor, randomState)};
    }

    protected static int a(a context, int width, int height) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = chunkPos.d();
        int j2 = chunkPos.e();
        return Structure.a(context, i2, j2, width, height);
    }

    protected static int a(a context, int x2, int z2, int width, int height) {
        int[] is = Structure.b(context, x2, width, z2, height);
        return Math.min(Math.min(is[0], is[1]), Math.min(is[2], is[3]));
    }

    @Deprecated
    protected BlockPosition a(a context, EnumBlockRotation rotation) {
        int i2 = 5;
        int j2 = 5;
        if (rotation == EnumBlockRotation.b) {
            i2 = -5;
        } else if (rotation == EnumBlockRotation.c) {
            i2 = -5;
            j2 = -5;
        } else if (rotation == EnumBlockRotation.d) {
            j2 = -5;
        }
        ChunkCoordIntPair chunkPos = context.h();
        int k2 = chunkPos.a(7);
        int l2 = chunkPos.b(7);
        return new BlockPosition(k2, Structure.a(context, k2, l2, i2, j2), l2);
    }

    protected abstract Optional<b> a(a var1);

    public Optional<b> b(a context) {
        return this.a(context).filter(position -> Structure.a(position, context));
    }

    public abstract StructureType<?> e();

    public static final class c
    extends Record {
        private final HolderSet<BiomeBase> b;
        private final Map<EnumCreatureType, StructureSpawnOverride> c;
        private final WorldGenStage.Decoration d;
        private final TerrainAdjustment e;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.a(Registries.ap).fieldOf("biomes").forGetter(c::a), (App)Codec.simpleMap(EnumCreatureType.i, StructureSpawnOverride.a, (Keyable)INamable.a(EnumCreatureType.values())).fieldOf("spawn_overrides").forGetter(c::b), (App)WorldGenStage.Decoration.l.fieldOf("step").forGetter(c::c), (App)TerrainAdjustment.e.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.a).forGetter(c::d)).apply((Applicative)instance, c::new));

        public c(HolderSet<BiomeBase> holderSet, Map<EnumCreatureType, StructureSpawnOverride> map, WorldGenStage.Decoration decoration, TerrainAdjustment terrainAdjustment) {
            this.b = holderSet;
            this.c = map;
            this.d = decoration;
            this.e = terrainAdjustment;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "b", "c", "d", "e"}, this, object);
        }

        public HolderSet<BiomeBase> a() {
            return this.b;
        }

        public Map<EnumCreatureType, StructureSpawnOverride> b() {
            return this.c;
        }

        public WorldGenStage.Decoration c() {
            return this.d;
        }

        public TerrainAdjustment d() {
            return this.e;
        }
    }

    public record a(IRegistryCustom a, ChunkGenerator b, WorldChunkManager c, RandomState d, StructureTemplateManager e, SeededRandom f, long g, ChunkCoordIntPair h, LevelHeightAccessor i, Predicate<Holder<BiomeBase>> j) {
        public a(IRegistryCustom dynamicRegistryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, RandomState noiseConfig, StructureTemplateManager structureTemplateManager, long seed, ChunkCoordIntPair chunkPos, LevelHeightAccessor world, Predicate<Holder<BiomeBase>> biomePredicate) {
            this(dynamicRegistryManager, chunkGenerator, biomeSource, noiseConfig, structureTemplateManager, net.minecraft.world.level.levelgen.structure.Structure$a.a(seed, chunkPos), seed, chunkPos, world, biomePredicate);
        }

        private static SeededRandom a(long seed, ChunkCoordIntPair chunkPos) {
            SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
            worldgenRandom.c(seed, chunkPos.e, chunkPos.f);
            return worldgenRandom;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this, object);
        }
    }

    public record b(BlockPosition a, Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> b) {
        private final BlockPosition a;
        private final Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> b;

        public b(BlockPosition pos, Consumer<StructurePiecesBuilder> generator) {
            this(pos, Either.left(generator));
        }

        public StructurePiecesBuilder a() {
            return this.b.map(generator -> {
                StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
                generator.accept(structurePiecesBuilder);
                return structurePiecesBuilder;
            }, collector -> collector);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "position;generator", "a", "b"}, this, object);
        }

        public BlockPosition b() {
            return this.a;
        }

        public Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> c() {
            return this.b;
        }
    }
}

