/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.LootTables;
import org.slf4j.Logger;

public class MineshaftPieces {
    static final Logger b = LogUtils.getLogger();
    private static final int c = 3;
    private static final int d = 3;
    private static final int e = 5;
    private static final int f = 20;
    private static final int g = 50;
    private static final int h = 8;
    public static final int a = 50;

    private static c a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int chainLength, MineshaftStructure.a type) {
        int i2 = random.a(100);
        if (i2 >= 80) {
            StructureBoundingBox boundingBox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$b.a(holder, random, x2, y2, z2, orientation);
            if (boundingBox != null) {
                return new b(chainLength, boundingBox, orientation, type);
            }
        } else if (i2 >= 70) {
            StructureBoundingBox boundingBox2 = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$e.a(holder, random, x2, y2, z2, orientation);
            if (boundingBox2 != null) {
                return new e(chainLength, boundingBox2, orientation, type);
            }
        } else {
            StructureBoundingBox boundingBox3 = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(holder, random, x2, y2, z2, orientation);
            if (boundingBox3 != null) {
                return new a(chainLength, random, boundingBox3, orientation, type);
            }
        }
        return null;
    }

    static c a(StructurePiece start, StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x2 - start.f().g()) > 80 || Math.abs(z2 - start.f().i()) > 80) {
            return null;
        }
        MineshaftStructure.a type = ((c)start).a;
        c mineShaftPiece = MineshaftPieces.a(holder, random, x2, y2, z2, orientation, chainLength + 1, type);
        if (mineShaftPiece != null) {
            holder.a(mineShaftPiece);
            mineShaftPiece.a(start, holder, random);
        }
        return mineShaftPiece;
    }

    public static class b
    extends c {
        private final EnumDirection b;
        private final boolean c;

        public b(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.b, nbt);
            this.c = nbt.q("tf");
            this.b = EnumDirection.b(nbt.h("D"));
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("tf", this.c);
            nbt.a("D", this.b.e());
        }

        public b(int chainLength, StructureBoundingBox boundingBox, @Nullable EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.b, chainLength, type, boundingBox);
            this.b = orientation;
            this.c = boundingBox.d() > 3;
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            StructureBoundingBox boundingBox4;
            int j2;
            if (random.a(4) == 0) {
                int i2 = 6;
            } else {
                j2 = 2;
            }
            switch (orientation) {
                default: {
                    StructureBoundingBox boundingBox = new StructureBoundingBox(-1, 0, -4, 3, j2, 0);
                    break;
                }
                case d: {
                    StructureBoundingBox boundingBox2 = new StructureBoundingBox(-1, 0, 0, 3, j2, 4);
                    break;
                }
                case e: {
                    StructureBoundingBox boundingBox3 = new StructureBoundingBox(-4, 0, -1, 0, j2, 3);
                    break;
                }
                case f: {
                    boundingBox4 = new StructureBoundingBox(0, 0, -1, 4, j2, 3);
                }
            }
            boundingBox4.a(x2, y2, z2);
            if (holder.a(boundingBox4) != null) {
                return null;
            }
            return boundingBox4;
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            int i2 = this.g();
            switch (this.b) {
                default: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                    break;
                }
                case d: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                    break;
                }
                case e: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    break;
                }
                case f: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                }
            }
            if (this.c) {
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h() + 3 + 1, this.f.i() - 1, EnumDirection.c, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() + 3 + 1, this.f.i() + 1, EnumDirection.e, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() + 3 + 1, this.f.i() + 1, EnumDirection.f, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h() + 3 + 1, this.f.l() + 1, EnumDirection.d, i2);
                }
            }
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (this.a(world, chunkBox)) {
                return;
            }
            IBlockData blockState = this.a.d();
            if (this.c) {
                this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i(), this.f.j() - 1, this.f.h() + 3 - 1, this.f.l(), StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, this.f.g(), this.f.h(), this.f.i() + 1, this.f.j(), this.f.h() + 3 - 1, this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, this.f.g() + 1, this.f.k() - 2, this.f.i(), this.f.j() - 1, this.f.k(), this.f.l(), StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, this.f.g(), this.f.k() - 2, this.f.i() + 1, this.f.j(), this.f.k(), this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, this.f.g() + 1, this.f.h() + 3, this.f.i() + 1, this.f.j() - 1, this.f.h() + 3, this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
            } else {
                this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i(), this.f.j() - 1, this.f.k(), this.f.l(), StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, this.f.g(), this.f.h(), this.f.i() + 1, this.f.j(), this.f.k(), this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
            }
            this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i() + 1, this.f.k());
            this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.l() - 1, this.f.k());
            this.a(world, chunkBox, this.f.j() - 1, this.f.h(), this.f.i() + 1, this.f.k());
            this.a(world, chunkBox, this.f.j() - 1, this.f.h(), this.f.l() - 1, this.f.k());
            int i2 = this.f.h() - 1;
            for (int j2 = this.f.g(); j2 <= this.f.j(); ++j2) {
                for (int k2 = this.f.i(); k2 <= this.f.l(); ++k2) {
                    this.a(world, chunkBox, blockState, j2, i2, k2);
                }
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, int x2, int minY, int z2, int maxY) {
            if (!this.a((IBlockAccess)world, x2, maxY + 1, z2, boundingBox).i()) {
                this.a(world, boundingBox, x2, minY, z2, x2, maxY, z2, this.a.d(), StructurePiece.e, false);
            }
        }
    }

    public static class e
    extends c {
        public e(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.d, chainLength, type, boundingBox);
            this.a(orientation);
        }

        public e(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.d, nbt);
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            StructureBoundingBox boundingBox4;
            switch (orientation) {
                default: {
                    StructureBoundingBox boundingBox = new StructureBoundingBox(0, -5, -8, 2, 2, 0);
                    break;
                }
                case d: {
                    StructureBoundingBox boundingBox2 = new StructureBoundingBox(0, -5, 0, 2, 2, 8);
                    break;
                }
                case e: {
                    StructureBoundingBox boundingBox3 = new StructureBoundingBox(-8, -5, 0, 0, 2, 2);
                    break;
                }
                case f: {
                    boundingBox4 = new StructureBoundingBox(0, -5, 0, 8, 2, 2);
                }
            }
            boundingBox4.a(x2, y2, z2);
            if (holder.a(boundingBox4) != null) {
                return null;
            }
            return boundingBox4;
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            int i2 = this.g();
            EnumDirection direction = this.i();
            if (direction != null) {
                switch (direction) {
                    default: {
                        MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                        break;
                    }
                    case d: {
                        MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                        break;
                    }
                    case e: {
                        MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i(), EnumDirection.e, i2);
                        break;
                    }
                    case f: {
                        MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i(), EnumDirection.f, i2);
                    }
                }
            }
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (this.a(world, chunkBox)) {
                return;
            }
            this.a(world, chunkBox, 0, 5, 0, 2, 7, 1, StructurePiece.e, StructurePiece.e, false);
            this.a(world, chunkBox, 0, 0, 7, 2, 2, 8, StructurePiece.e, StructurePiece.e, false);
            for (int i2 = 0; i2 < 5; ++i2) {
                this.a(world, chunkBox, 0, 5 - i2 - (i2 < 4 ? 1 : 0), 2 + i2, 2, 7 - i2, 2 + i2, StructurePiece.e, StructurePiece.e, false);
            }
        }
    }

    public static class a
    extends c {
        private final boolean b;
        private final boolean c;
        private boolean d;
        private final int h;

        public a(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.a, nbt);
            this.b = nbt.q("hr");
            this.c = nbt.q("sc");
            this.d = nbt.q("hps");
            this.h = nbt.h("Num");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("hr", this.b);
            nbt.a("sc", this.c);
            nbt.a("hps", this.d);
            nbt.a("Num", this.h);
        }

        public a(int chainLength, RandomSource random, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.a, chainLength, type, boundingBox);
            this.a(orientation);
            this.b = random.a(3) == 0;
            this.c = !this.b && random.a(23) == 0;
            this.h = this.i().o() == EnumDirection.EnumAxis.c ? boundingBox.e() / 5 : boundingBox.c() / 5;
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            for (int i2 = random.a(3) + 2; i2 > 0; --i2) {
                StructureBoundingBox boundingBox4;
                int j2 = i2 * 5;
                switch (orientation) {
                    default: {
                        StructureBoundingBox boundingBox = new StructureBoundingBox(0, 0, -(j2 - 1), 2, 2, 0);
                        break;
                    }
                    case d: {
                        StructureBoundingBox boundingBox2 = new StructureBoundingBox(0, 0, 0, 2, 2, j2 - 1);
                        break;
                    }
                    case e: {
                        StructureBoundingBox boundingBox3 = new StructureBoundingBox(-(j2 - 1), 0, 0, 0, 2, 2);
                        break;
                    }
                    case f: {
                        boundingBox4 = new StructureBoundingBox(0, 0, 0, j2 - 1, 2, 2);
                    }
                }
                boundingBox4.a(x2, y2, z2);
                if (holder.a(boundingBox4) != null) {
                    continue;
                }
                return boundingBox4;
            }
            return null;
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            block24: {
                int i2 = this.g();
                int j2 = random.a(4);
                EnumDirection direction = this.i();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.i() - 1, direction, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.i(), EnumDirection.e, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.i(), EnumDirection.f, i2);
                            break;
                        }
                        case d: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.l() + 1, direction, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.l() - 3, EnumDirection.e, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.l() - 3, EnumDirection.f, i2);
                            break;
                        }
                        case e: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.i(), direction, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.i() - 1, EnumDirection.c, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.l() + 1, EnumDirection.d, i2);
                            break;
                        }
                        case f: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.i(), direction, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.j() - 3, this.f.h() - 1 + random.a(3), this.f.i() - 1, EnumDirection.c, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() - 3, this.f.h() - 1 + random.a(3), this.f.l() + 1, EnumDirection.d, i2);
                        }
                    }
                }
                if (i2 >= 8) break block24;
                if (direction == EnumDirection.c || direction == EnumDirection.d) {
                    int k2 = this.f.i() + 3;
                    while (k2 + 3 <= this.f.l()) {
                        int l2 = random.a(5);
                        if (l2 == 0) {
                            MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), k2, EnumDirection.e, i2 + 1);
                        } else if (l2 == 1) {
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), k2, EnumDirection.f, i2 + 1);
                        }
                        k2 += 5;
                    }
                } else {
                    int m2 = this.f.g() + 3;
                    while (m2 + 3 <= this.f.j()) {
                        int n2 = random.a(5);
                        if (n2 == 0) {
                            MineshaftPieces.a(start, holder, random, m2, this.f.h(), this.f.i() - 1, EnumDirection.c, i2 + 1);
                        } else if (n2 == 1) {
                            MineshaftPieces.a(start, holder, random, m2, this.f.h(), this.f.l() + 1, EnumDirection.d, i2 + 1);
                        }
                        m2 += 5;
                    }
                }
            }
        }

        @Override
        @Override
        protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, MinecraftKey lootTableId) {
            BlockPosition.MutableBlockPosition blockPos = this.b(x2, y2, z2);
            if (boundingBox.b(blockPos) && world.a_(blockPos).i() && !world.a_(blockPos.d()).i()) {
                IBlockData blockState = (IBlockData)Blocks.cP.n().a(BlockMinecartTrack.d, random.h() ? BlockPropertyTrackPosition.a : BlockPropertyTrackPosition.b);
                this.a(world, blockState, x2, y2, z2, boundingBox);
                EntityMinecartChest minecartChest = new EntityMinecartChest(world.C(), (double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5);
                minecartChest.a(lootTableId, random.g());
                world.b(minecartChest);
                return true;
            }
            return false;
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (this.a(world, chunkBox)) {
                return;
            }
            boolean i2 = false;
            int j2 = 2;
            boolean k2 = false;
            int l2 = 2;
            int m2 = this.h * 5 - 1;
            IBlockData blockState = this.a.d();
            this.a(world, chunkBox, 0, 0, 0, 2, 1, m2, StructurePiece.e, StructurePiece.e, false);
            this.a(world, chunkBox, random, 0.8f, 0, 2, 0, 2, 2, m2, StructurePiece.e, StructurePiece.e, false, false);
            if (this.c) {
                this.a(world, chunkBox, random, 0.6f, 0, 0, 0, 2, 1, m2, Blocks.bs.n(), StructurePiece.e, false, true);
            }
            for (int n2 = 0; n2 < this.h; ++n2) {
                int o2 = 2 + n2 * 5;
                this.a(world, chunkBox, 0, 0, o2, 2, 2, random);
                this.a(world, chunkBox, random, 0.1f, 0, 2, o2 - 1);
                this.a(world, chunkBox, random, 0.1f, 2, 2, o2 - 1);
                this.a(world, chunkBox, random, 0.1f, 0, 2, o2 + 1);
                this.a(world, chunkBox, random, 0.1f, 2, 2, o2 + 1);
                this.a(world, chunkBox, random, 0.05f, 0, 2, o2 - 2);
                this.a(world, chunkBox, random, 0.05f, 2, 2, o2 - 2);
                this.a(world, chunkBox, random, 0.05f, 0, 2, o2 + 2);
                this.a(world, chunkBox, random, 0.05f, 2, 2, o2 + 2);
                if (random.a(100) == 0) {
                    this.a(world, chunkBox, random, 2, 0, o2 - 1, LootTables.u);
                }
                if (random.a(100) == 0) {
                    this.a(world, chunkBox, random, 0, 0, o2 + 1, LootTables.u);
                }
                if (!this.c || this.d) continue;
                boolean p2 = true;
                int q2 = o2 - 1 + random.a(3);
                BlockPosition.MutableBlockPosition blockPos = this.b(1, 0, q2);
                if (!chunkBox.b(blockPos) || !this.b(world, 1, 0, q2, chunkBox)) continue;
                this.d = true;
                world.a((BlockPosition)blockPos, Blocks.ct.n(), 2);
                TileEntity blockEntity = world.c_(blockPos);
                if (!(blockEntity instanceof TileEntityMobSpawner)) continue;
                TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
                spawnerBlockEntity.a(EntityTypes.n, random);
            }
            for (int r2 = 0; r2 <= 2; ++r2) {
                for (int s2 = 0; s2 <= m2; ++s2) {
                    this.a(world, chunkBox, blockState, r2, -1, s2);
                }
            }
            int t2 = 2;
            this.a(world, chunkBox, 0, -1, 2);
            if (this.h > 1) {
                int u2 = m2 - 2;
                this.a(world, chunkBox, 0, -1, u2);
            }
            if (this.b) {
                IBlockData blockState2 = (IBlockData)Blocks.cP.n().a(BlockMinecartTrack.d, BlockPropertyTrackPosition.a);
                for (int v2 = 0; v2 <= m2; ++v2) {
                    IBlockData blockState3 = this.a((IBlockAccess)world, 1, -1, v2, chunkBox);
                    if (blockState3.i() || !blockState3.i(world, this.b(1, -1, v2))) continue;
                    float f2 = this.b(world, 1, 0, v2, chunkBox) ? 0.7f : 0.9f;
                    this.a(world, chunkBox, random, f2, 1, 0, v2, blockState2);
                }
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox box, int x2, int y2, int z2) {
            IBlockData blockState = this.a.b();
            IBlockData blockState2 = this.a.d();
            if (this.a((IBlockAccess)world, x2, y2, z2, box).a(blockState2.b())) {
                this.c(world, blockState, x2, y2, z2, box);
            }
            if (this.a((IBlockAccess)world, x2 + 2, y2, z2, box).a(blockState2.b())) {
                this.c(world, blockState, x2 + 2, y2, z2, box);
            }
        }

        @Override
        @Override
        protected void b(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition mutableBlockPos = this.b(x2, y2, z2);
            if (!box.b(mutableBlockPos)) {
                return;
            }
            int i2 = mutableBlockPos.v();
            while (this.a(world.a_(mutableBlockPos)) && mutableBlockPos.v() > world.C_() + 1) {
                mutableBlockPos.c(EnumDirection.a);
            }
            if (!this.a(world, mutableBlockPos, world.a_(mutableBlockPos))) {
                return;
            }
            while (mutableBlockPos.v() < i2) {
                mutableBlockPos.c(EnumDirection.b);
                world.a((BlockPosition)mutableBlockPos, state, 2);
            }
        }

        protected void c(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition mutableBlockPos = this.b(x2, y2, z2);
            if (!box.b(mutableBlockPos)) {
                return;
            }
            int i2 = mutableBlockPos.v();
            int j2 = 1;
            boolean bl = true;
            boolean bl2 = true;
            while (bl || bl2) {
                if (bl) {
                    boolean bl3;
                    mutableBlockPos.q(i2 - j2);
                    IBlockData blockState = world.a_(mutableBlockPos);
                    boolean bl4 = bl3 = this.a(blockState) && !blockState.a(Blocks.H);
                    if (!bl3 && this.a(world, mutableBlockPos, blockState)) {
                        net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(world, state, mutableBlockPos, i2 - j2 + 1, i2);
                        return;
                    }
                    boolean bl5 = bl = j2 <= 20 && bl3 && mutableBlockPos.v() > world.C_() + 1;
                }
                if (bl2) {
                    mutableBlockPos.q(i2 + j2);
                    IBlockData blockState2 = world.a_(mutableBlockPos);
                    boolean bl4 = this.a(blockState2);
                    if (!bl4 && this.b(world, mutableBlockPos, blockState2)) {
                        world.a((BlockPosition)mutableBlockPos.q(i2 + 1), this.a.e(), 2);
                        net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(world, Blocks.eY.n(), mutableBlockPos, i2 + 2, i2 + j2);
                        return;
                    }
                    bl2 = j2 <= 50 && bl4 && mutableBlockPos.v() < world.aj() - 1;
                }
                ++j2;
            }
        }

        private static void a(GeneratorAccessSeed world, IBlockData state, BlockPosition.MutableBlockPosition pos, int startY, int endY) {
            for (int i2 = startY; i2 < endY; ++i2) {
                world.a((BlockPosition)pos.q(i2), state, 2);
            }
        }

        private boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
            return state.d(world, pos, EnumDirection.b);
        }

        private boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
            return Block.a(world, pos, EnumDirection.a) && !(state.b() instanceof BlockFalling);
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, int minX, int minY, int z2, int maxY, int maxX, RandomSource random) {
            if (!this.a((IBlockAccess)world, boundingBox, minX, maxX, maxY, z2)) {
                return;
            }
            IBlockData blockState = this.a.d();
            IBlockData blockState2 = this.a.e();
            this.a(world, boundingBox, minX, minY, z2, minX, maxY - 1, z2, (IBlockData)blockState2.a(BlockTall.d, true), StructurePiece.e, false);
            this.a(world, boundingBox, maxX, minY, z2, maxX, maxY - 1, z2, (IBlockData)blockState2.a(BlockTall.b, true), StructurePiece.e, false);
            if (random.a(4) == 0) {
                this.a(world, boundingBox, minX, maxY, z2, minX, maxY, z2, blockState, StructurePiece.e, false);
                this.a(world, boundingBox, maxX, maxY, z2, maxX, maxY, z2, blockState, StructurePiece.e, false);
            } else {
                this.a(world, boundingBox, minX, maxY, z2, maxX, maxY, z2, blockState, StructurePiece.e, false);
                this.a(world, boundingBox, random, 0.05f, minX + 1, maxY, z2 - 1, (IBlockData)Blocks.cq.n().a(BlockTorchWall.a, EnumDirection.d));
                this.a(world, boundingBox, random, 0.05f, minX + 1, maxY, z2 + 1, (IBlockData)Blocks.cq.n().a(BlockTorchWall.a, EnumDirection.c));
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox box, RandomSource random, float threshold, int x2, int y2, int z2) {
            if (this.b(world, x2, y2, z2, box) && random.i() < threshold && this.a(world, box, x2, y2, z2, 2)) {
                this.a(world, Blocks.bs.n(), x2, y2, z2, box);
            }
        }

        private boolean a(GeneratorAccessSeed world, StructureBoundingBox box, int x2, int y2, int z2, int count) {
            BlockPosition.MutableBlockPosition mutableBlockPos = this.b(x2, y2, z2);
            int i2 = 0;
            for (EnumDirection direction : EnumDirection.values()) {
                mutableBlockPos.c(direction);
                if (box.b(mutableBlockPos) && world.a_(mutableBlockPos).d(world, mutableBlockPos, direction.g()) && ++i2 >= count) {
                    return true;
                }
                mutableBlockPos.c(direction.g());
            }
            return false;
        }
    }

    static abstract class c
    extends StructurePiece {
        protected MineshaftStructure.a a;

        public c(WorldGenFeatureStructurePieceType structurePieceType, int chainLength, MineshaftStructure.a type, StructureBoundingBox box) {
            super(structurePieceType, chainLength, box);
            this.a = type;
        }

        public c(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
            this.a = MineshaftStructure.a.a(nbt.h("MST"));
        }

        @Override
        @Override
        protected boolean a(IWorldReader world, int x2, int y2, int z2, StructureBoundingBox box) {
            IBlockData blockState = this.a((IBlockAccess)world, x2, y2, z2, box);
            return !blockState.a(this.a.d().b()) && !blockState.a(this.a.b().b()) && !blockState.a(this.a.e().b()) && !blockState.a(Blocks.eY);
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            nbt.a("MST", this.a.ordinal());
        }

        protected boolean a(IBlockAccess world, StructureBoundingBox boundingBox, int minX, int maxX, int y2, int z2) {
            for (int i2 = minX; i2 <= maxX; ++i2) {
                if (!this.a(world, i2, y2 + 1, z2, boundingBox).i()) continue;
                return false;
            }
            return true;
        }

        protected boolean a(GeneratorAccess world, StructureBoundingBox box) {
            int n2;
            int m2;
            int i2 = Math.max(this.f.g() - 1, box.g());
            int j2 = Math.max(this.f.h() - 1, box.h());
            int k2 = Math.max(this.f.i() - 1, box.i());
            int l2 = Math.min(this.f.j() + 1, box.j());
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition((i2 + l2) / 2, (j2 + (m2 = Math.min(this.f.k() + 1, box.k()))) / 2, (k2 + (n2 = Math.min(this.f.l() + 1, box.l()))) / 2);
            if (world.s(mutableBlockPos).a(BiomeTags.X)) {
                return true;
            }
            for (int o2 = i2; o2 <= l2; ++o2) {
                for (int p2 = k2; p2 <= n2; ++p2) {
                    if (world.a_(mutableBlockPos.d(o2, j2, p2)).k()) {
                        return true;
                    }
                    if (!world.a_(mutableBlockPos.d(o2, m2, p2)).k()) continue;
                    return true;
                }
            }
            for (int q2 = i2; q2 <= l2; ++q2) {
                for (int r2 = j2; r2 <= m2; ++r2) {
                    if (world.a_(mutableBlockPos.d(q2, r2, k2)).k()) {
                        return true;
                    }
                    if (!world.a_(mutableBlockPos.d(q2, r2, n2)).k()) continue;
                    return true;
                }
            }
            for (int s2 = k2; s2 <= n2; ++s2) {
                for (int t2 = j2; t2 <= m2; ++t2) {
                    if (world.a_(mutableBlockPos.d(i2, t2, s2)).k()) {
                        return true;
                    }
                    if (!world.a_(mutableBlockPos.d(l2, t2, s2)).k()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void a(GeneratorAccessSeed world, StructureBoundingBox box, IBlockData state, int x2, int y2, int z2) {
            if (!this.b(world, x2, y2, z2, box)) {
                return;
            }
            BlockPosition.MutableBlockPosition blockPos = this.b(x2, y2, z2);
            IBlockData blockState = world.a_(blockPos);
            if (!blockState.d(world, blockPos, EnumDirection.b)) {
                world.a((BlockPosition)blockPos, state, 2);
            }
        }
    }

    public static class d
    extends c {
        private final List<StructureBoundingBox> b = Lists.newLinkedList();

        public d(int chainLength, RandomSource random, int x2, int z2, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.c, chainLength, type, new StructureBoundingBox(x2, 50, z2, x2 + 7 + random.a(6), 54 + random.a(6), z2 + 7 + random.a(6)));
            this.a = type;
        }

        public d(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.c, nbt);
            StructureBoundingBox.a.listOf().parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("Entrances", 11)).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).ifPresent(this.b::addAll);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            int k2;
            int i2 = this.g();
            int j2 = this.f.d() - 3 - 1;
            if (j2 <= 0) {
                j2 = 1;
            }
            for (k2 = 0; k2 < this.f.c() && (k2 += random.a(this.f.c())) + 3 <= this.f.c(); k2 += 4) {
                c mineShaftPiece = MineshaftPieces.a(start, holder, random, this.f.g() + k2, this.f.h() + random.a(j2) + 1, this.f.i() - 1, EnumDirection.c, i2);
                if (mineShaftPiece == null) continue;
                StructureBoundingBox boundingBox = mineShaftPiece.f();
                this.b.add(new StructureBoundingBox(boundingBox.g(), boundingBox.h(), this.f.i(), boundingBox.j(), boundingBox.k(), this.f.i() + 1));
            }
            for (k2 = 0; k2 < this.f.c() && (k2 += random.a(this.f.c())) + 3 <= this.f.c(); k2 += 4) {
                c mineShaftPiece2 = MineshaftPieces.a(start, holder, random, this.f.g() + k2, this.f.h() + random.a(j2) + 1, this.f.l() + 1, EnumDirection.d, i2);
                if (mineShaftPiece2 == null) continue;
                StructureBoundingBox boundingBox2 = mineShaftPiece2.f();
                this.b.add(new StructureBoundingBox(boundingBox2.g(), boundingBox2.h(), this.f.l() - 1, boundingBox2.j(), boundingBox2.k(), this.f.l()));
            }
            for (k2 = 0; k2 < this.f.e() && (k2 += random.a(this.f.e())) + 3 <= this.f.e(); k2 += 4) {
                c mineShaftPiece3 = MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() + random.a(j2) + 1, this.f.i() + k2, EnumDirection.e, i2);
                if (mineShaftPiece3 == null) continue;
                StructureBoundingBox boundingBox3 = mineShaftPiece3.f();
                this.b.add(new StructureBoundingBox(this.f.g(), boundingBox3.h(), boundingBox3.i(), this.f.g() + 1, boundingBox3.k(), boundingBox3.l()));
            }
            for (k2 = 0; k2 < this.f.e() && (k2 += random.a(this.f.e())) + 3 <= this.f.e(); k2 += 4) {
                c structurePiece = MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() + random.a(j2) + 1, this.f.i() + k2, EnumDirection.f, i2);
                if (structurePiece == null) continue;
                StructureBoundingBox boundingBox4 = structurePiece.f();
                this.b.add(new StructureBoundingBox(this.f.j() - 1, boundingBox4.h(), boundingBox4.i(), this.f.j(), boundingBox4.k(), boundingBox4.l()));
            }
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (this.a(world, chunkBox)) {
                return;
            }
            this.a(world, chunkBox, this.f.g(), this.f.h() + 1, this.f.i(), this.f.j(), Math.min(this.f.h() + 3, this.f.k()), this.f.l(), StructurePiece.e, StructurePiece.e, false);
            for (StructureBoundingBox boundingBox : this.b) {
                this.a(world, chunkBox, boundingBox.g(), boundingBox.k() - 2, boundingBox.i(), boundingBox.j(), boundingBox.k(), boundingBox.l(), StructurePiece.e, StructurePiece.e, false);
            }
            this.a(world, chunkBox, this.f.g(), this.f.h() + 4, this.f.i(), this.f.j(), this.f.k(), this.f.l(), StructurePiece.e, false);
        }

        @Override
        @Override
        public void a(int x2, int y2, int z2) {
            super.a(x2, y2, z2);
            for (StructureBoundingBox boundingBox : this.b) {
                boundingBox.a(x2, y2, z2);
            }
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            StructureBoundingBox.a.listOf().encodeStart((DynamicOps)DynamicOpsNBT.a, this.b).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).ifPresent(tag -> nbt.a("Entrances", (NBTBase)tag));
        }
    }
}

