/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;
import top.leavesmc.leaves.LeavesConfig;

public final class NoiseGeneratorPerlin {
    private static final float d = 1.0E-7f;
    private final byte[] e;
    public final double a;
    public final double b;
    public final double c;
    private static final double[] FLAT_SIMPLEX_GRAD = new double[]{1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0};

    public NoiseGeneratorPerlin(RandomSource random) {
        this.a = random.j() * 256.0;
        this.b = random.j() * 256.0;
        this.c = random.j() * 256.0;
        this.e = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.e[i2] = (byte)i2;
        }
        for (int j2 = 0; j2 < 256; ++j2) {
            int k2 = random.a(256 - j2);
            byte b2 = this.e[j2];
            this.e[j2] = this.e[j2 + k2];
            this.e[j2 + k2] = b2;
        }
    }

    public double a(double x2, double y2, double z2) {
        return this.a(x2, y2, z2, 0.0, 0.0);
    }

    @Deprecated
    public double a(double x2, double y2, double z2, double yScale, double yMax) {
        double o2;
        double l2;
        double h2;
        double g2;
        double d2 = x2 + this.a;
        double e2 = y2 + this.b;
        double f2 = z2 + this.c;
        int i2 = MathHelper.a(d2);
        int j2 = MathHelper.a(e2);
        int k2 = MathHelper.a(f2);
        if (!LeavesConfig.optimizeNoiseGeneration) {
            g2 = d2 - (double)i2;
            h2 = e2 - (double)j2;
            l2 = f2 - (double)k2;
        } else {
            g2 = d2 - (double)i2;
            h2 = e2 - (double)j2;
            l2 = f2 - (double)k2;
        }
        if (yScale != 0.0) {
            double m2 = yMax >= 0.0 && yMax < h2 ? yMax : h2;
            o2 = !LeavesConfig.optimizeNoiseGeneration ? (double)MathHelper.a(m2 / yScale + (double)1.0E-7f) * yScale : Math.floor(m2 / yScale + (double)1.0E-7f) * yScale;
        } else {
            o2 = 0.0;
        }
        if (!LeavesConfig.optimizeNoiseGeneration) {
            return this.a(i2, j2, k2, g2, h2 - o2, l2, h2);
        }
        return this.a(i2, j2, k2, g2, h2 - o2, l2, h2);
    }

    public double a(double x2, double y2, double z2, double[] ds) {
        double d2 = x2 + this.a;
        double e2 = y2 + this.b;
        double f2 = z2 + this.c;
        int i2 = MathHelper.a(d2);
        int j2 = MathHelper.a(e2);
        int k2 = MathHelper.a(f2);
        if (!LeavesConfig.optimizeNoiseGeneration) {
            double g2 = d2 - (double)i2;
            double h2 = e2 - (double)j2;
            double l2 = f2 - (double)k2;
            return this.a(i2, j2, k2, g2, h2, l2, ds);
        }
        double g3 = d2 - (double)i2;
        double h3 = e2 - (double)j2;
        double l3 = f2 - (double)k2;
        return this.a(i2, j2, k2, g3, h3, l3, ds);
    }

    private static double a(int hash, double x2, double y2, double z2) {
        return NoiseGenerator3Handler.a(NoiseGenerator3Handler.a[hash & 0xF], x2, y2, z2);
    }

    private int a(int input) {
        return this.e[input & 0xFF] & 0xFF;
    }

    private double a(int sectionX, int sectionY, int sectionZ, double localX, double localY, double localZ, double fadeLocalY) {
        if (!LeavesConfig.optimizeNoiseGeneration) {
            int i2 = this.a(sectionX);
            int j2 = this.a(sectionX + 1);
            int k2 = this.a(i2 + sectionY);
            int l2 = this.a(i2 + sectionY + 1);
            int m2 = this.a(j2 + sectionY);
            int n2 = this.a(j2 + sectionY + 1);
            double d2 = NoiseGeneratorPerlin.a(this.a(k2 + sectionZ), localX, localY, localZ);
            double e2 = NoiseGeneratorPerlin.a(this.a(m2 + sectionZ), localX - 1.0, localY, localZ);
            double f2 = NoiseGeneratorPerlin.a(this.a(l2 + sectionZ), localX, localY - 1.0, localZ);
            double g2 = NoiseGeneratorPerlin.a(this.a(n2 + sectionZ), localX - 1.0, localY - 1.0, localZ);
            double h2 = NoiseGeneratorPerlin.a(this.a(k2 + sectionZ + 1), localX, localY, localZ - 1.0);
            double o2 = NoiseGeneratorPerlin.a(this.a(m2 + sectionZ + 1), localX - 1.0, localY, localZ - 1.0);
            double p2 = NoiseGeneratorPerlin.a(this.a(l2 + sectionZ + 1), localX, localY - 1.0, localZ - 1.0);
            double q2 = NoiseGeneratorPerlin.a(this.a(n2 + sectionZ + 1), localX - 1.0, localY - 1.0, localZ - 1.0);
            double r2 = MathHelper.h(localX);
            double s2 = MathHelper.h(fadeLocalY);
            double t2 = MathHelper.h(localZ);
            return MathHelper.a(r2, s2, t2, d2, e2, f2, g2, h2, o2, p2, q2);
        }
        int var0 = sectionX & 0xFF;
        int var1 = sectionX + 1 & 0xFF;
        int var2 = this.e[var0] & 0xFF;
        int var3 = this.e[var1] & 0xFF;
        int var4 = var2 + sectionY & 0xFF;
        int var5 = var3 + sectionY & 0xFF;
        int var6 = var2 + sectionY + 1 & 0xFF;
        int var7 = var3 + sectionY + 1 & 0xFF;
        int var8 = this.e[var4] & 0xFF;
        int var9 = this.e[var5] & 0xFF;
        int var10 = this.e[var6] & 0xFF;
        int var11 = this.e[var7] & 0xFF;
        int var12 = var8 + sectionZ & 0xFF;
        int var13 = var9 + sectionZ & 0xFF;
        int var14 = var10 + sectionZ & 0xFF;
        int var15 = var11 + sectionZ & 0xFF;
        int var16 = var8 + sectionZ + 1 & 0xFF;
        int var17 = var9 + sectionZ + 1 & 0xFF;
        int var18 = var10 + sectionZ + 1 & 0xFF;
        int var19 = var11 + sectionZ + 1 & 0xFF;
        int var20 = (this.e[var12] & 0xF) << 2;
        int var21 = (this.e[var13] & 0xF) << 2;
        int var22 = (this.e[var14] & 0xF) << 2;
        int var23 = (this.e[var15] & 0xF) << 2;
        int var24 = (this.e[var16] & 0xF) << 2;
        int var25 = (this.e[var17] & 0xF) << 2;
        int var26 = (this.e[var18] & 0xF) << 2;
        int var27 = (this.e[var19] & 0xF) << 2;
        double var60 = localX - 1.0;
        double var61 = localY - 1.0;
        double var62 = localZ - 1.0;
        double var87 = FLAT_SIMPLEX_GRAD[var20 | 0] * localX + FLAT_SIMPLEX_GRAD[var20 | 1] * localY + FLAT_SIMPLEX_GRAD[var20 | 2] * localZ;
        double var88 = FLAT_SIMPLEX_GRAD[var21 | 0] * var60 + FLAT_SIMPLEX_GRAD[var21 | 1] * localY + FLAT_SIMPLEX_GRAD[var21 | 2] * localZ;
        double var89 = FLAT_SIMPLEX_GRAD[var22 | 0] * localX + FLAT_SIMPLEX_GRAD[var22 | 1] * var61 + FLAT_SIMPLEX_GRAD[var22 | 2] * localZ;
        double var90 = FLAT_SIMPLEX_GRAD[var23 | 0] * var60 + FLAT_SIMPLEX_GRAD[var23 | 1] * var61 + FLAT_SIMPLEX_GRAD[var23 | 2] * localZ;
        double var91 = FLAT_SIMPLEX_GRAD[var24 | 0] * localX + FLAT_SIMPLEX_GRAD[var24 | 1] * localY + FLAT_SIMPLEX_GRAD[var24 | 2] * var62;
        double var92 = FLAT_SIMPLEX_GRAD[var25 | 0] * var60 + FLAT_SIMPLEX_GRAD[var25 | 1] * localY + FLAT_SIMPLEX_GRAD[var25 | 2] * var62;
        double var93 = FLAT_SIMPLEX_GRAD[var26 | 0] * localX + FLAT_SIMPLEX_GRAD[var26 | 1] * var61 + FLAT_SIMPLEX_GRAD[var26 | 2] * var62;
        double var94 = FLAT_SIMPLEX_GRAD[var27 | 0] * var60 + FLAT_SIMPLEX_GRAD[var27 | 1] * var61 + FLAT_SIMPLEX_GRAD[var27 | 2] * var62;
        double var95 = localX * 6.0 - 15.0;
        double var96 = fadeLocalY * 6.0 - 15.0;
        double var97 = localZ * 6.0 - 15.0;
        double var98 = localX * var95 + 10.0;
        double var99 = fadeLocalY * var96 + 10.0;
        double var100 = localZ * var97 + 10.0;
        double var101 = localX * localX * localX * var98;
        double var102 = fadeLocalY * fadeLocalY * fadeLocalY * var99;
        double var103 = localZ * localZ * localZ * var100;
        double var113 = var87 + var101 * (var88 - var87);
        double var114 = var93 + var101 * (var94 - var93);
        double var115 = var91 + var101 * (var92 - var91);
        double var116 = var89 + var101 * (var90 - var89);
        double var117 = var114 - var115;
        double var118 = var102 * (var116 - var113);
        double var119 = var102 * var117;
        double var120 = var113 + var118;
        double var121 = var115 + var119;
        return var120 + var103 * (var121 - var120);
    }

    private double a(int sectionX, int sectionY, int sectionZ, double localX, double localY, double localZ, double[] ds) {
        int i2 = this.a(sectionX);
        int j2 = this.a(sectionX + 1);
        int k2 = this.a(i2 + sectionY);
        int l2 = this.a(i2 + sectionY + 1);
        int m2 = this.a(j2 + sectionY);
        int n2 = this.a(j2 + sectionY + 1);
        int o2 = this.a(k2 + sectionZ);
        int p2 = this.a(m2 + sectionZ);
        int q2 = this.a(l2 + sectionZ);
        int r2 = this.a(n2 + sectionZ);
        int s2 = this.a(k2 + sectionZ + 1);
        int t2 = this.a(m2 + sectionZ + 1);
        int u2 = this.a(l2 + sectionZ + 1);
        int v2 = this.a(n2 + sectionZ + 1);
        int[] is = NoiseGenerator3Handler.a[o2 & 0xF];
        int[] js = NoiseGenerator3Handler.a[p2 & 0xF];
        int[] ks = NoiseGenerator3Handler.a[q2 & 0xF];
        int[] ls = NoiseGenerator3Handler.a[r2 & 0xF];
        int[] ms = NoiseGenerator3Handler.a[s2 & 0xF];
        int[] ns = NoiseGenerator3Handler.a[t2 & 0xF];
        int[] os = NoiseGenerator3Handler.a[u2 & 0xF];
        int[] ps = NoiseGenerator3Handler.a[v2 & 0xF];
        double d2 = NoiseGenerator3Handler.a(is, localX, localY, localZ);
        double e2 = NoiseGenerator3Handler.a(js, localX - 1.0, localY, localZ);
        double f2 = NoiseGenerator3Handler.a(ks, localX, localY - 1.0, localZ);
        double g2 = NoiseGenerator3Handler.a(ls, localX - 1.0, localY - 1.0, localZ);
        double h2 = NoiseGenerator3Handler.a(ms, localX, localY, localZ - 1.0);
        double w2 = NoiseGenerator3Handler.a(ns, localX - 1.0, localY, localZ - 1.0);
        double x2 = NoiseGenerator3Handler.a(os, localX, localY - 1.0, localZ - 1.0);
        double y2 = NoiseGenerator3Handler.a(ps, localX - 1.0, localY - 1.0, localZ - 1.0);
        double z2 = MathHelper.h(localX);
        double aa2 = MathHelper.h(localY);
        double ab = MathHelper.h(localZ);
        double ac = MathHelper.a(z2, aa2, ab, is[0], js[0], ks[0], ls[0], ms[0], ns[0], os[0], ps[0]);
        double ad = MathHelper.a(z2, aa2, ab, is[1], js[1], ks[1], ls[1], ms[1], ns[1], os[1], ps[1]);
        double ae = MathHelper.a(z2, aa2, ab, is[2], js[2], ks[2], ls[2], ms[2], ns[2], os[2], ps[2]);
        double af = MathHelper.a(aa2, ab, e2 - d2, g2 - f2, w2 - h2, y2 - x2);
        double ag = MathHelper.a(ab, z2, f2 - d2, x2 - h2, g2 - e2, y2 - w2);
        double ah = MathHelper.a(z2, aa2, h2 - d2, w2 - e2, x2 - f2, y2 - g2);
        double ai = MathHelper.i(localX);
        double aj = MathHelper.i(localY);
        double ak = MathHelper.i(localZ);
        double al = ac + ai * af;
        double am = ad + aj * ag;
        double an = ae + ak * ah;
        ds[0] = ds[0] + al;
        ds[1] = ds[1] + am;
        ds[2] = ds[2] + an;
        return MathHelper.a(z2, aa2, ab, d2, e2, f2, g2, h2, w2, x2, y2);
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        NoiseUtils.a(info, this.a, this.b, this.c, this.e);
    }
}

