/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathEntity {
    public final List<PathPoint> a;
    private PathPoint[] b = new PathPoint[0];
    private PathPoint[] c = new PathPoint[0];
    @Nullable
    private Set<PathDestination> d;
    private int e;
    private final BlockPosition f;
    private final float g;
    private final boolean h;

    public boolean hasNext() {
        return this.f() < this.a.size();
    }

    public PathEntity(List<PathPoint> nodes, BlockPosition target, boolean reachesTarget) {
        this.a = nodes;
        this.f = target;
        this.g = nodes.isEmpty() ? Float.MAX_VALUE : this.a.get(this.a.size() - 1).c(this.f);
        this.h = reachesTarget;
    }

    public void a() {
        ++this.e;
    }

    public boolean b() {
        return this.e <= 0;
    }

    public boolean c() {
        return this.e >= this.a.size();
    }

    @Nullable
    public PathPoint d() {
        return !this.a.isEmpty() ? this.a.get(this.a.size() - 1) : null;
    }

    public PathPoint a(int index) {
        return this.a.get(index);
    }

    public void b(int length) {
        if (this.a.size() > length) {
            this.a.subList(length, this.a.size()).clear();
        }
    }

    public void a(int index, PathPoint node) {
        this.a.set(index, node);
    }

    public int e() {
        return this.a.size();
    }

    public int f() {
        return this.e;
    }

    public void c(int nodeIndex) {
        this.e = nodeIndex;
    }

    public Vec3D a(Entity entity, int index) {
        PathPoint node = this.a.get(index);
        double d2 = (double)node.a + (double)((int)(entity.dd() + 1.0f)) * 0.5;
        double e2 = node.b;
        double f2 = (double)node.c + (double)((int)(entity.dd() + 1.0f)) * 0.5;
        return new Vec3D(d2, e2, f2);
    }

    public BlockPosition d(int index) {
        return this.a.get(index).a();
    }

    public Vec3D a(Entity entity) {
        return this.a(entity, this.e);
    }

    public BlockPosition g() {
        return this.a.get(this.e).a();
    }

    public PathPoint h() {
        return this.a.get(this.e);
    }

    @Nullable
    public PathPoint i() {
        return this.e > 0 ? this.a.get(this.e - 1) : null;
    }

    public boolean a(@Nullable PathEntity o2) {
        if (o2 == null) {
            return false;
        }
        if (o2.a.size() != this.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            PathPoint node = this.a.get(i2);
            PathPoint node2 = o2.a.get(i2);
            if (node.a == node2.a && node.b == node2.b && node.c == node2.c) continue;
            return false;
        }
        return true;
    }

    public boolean j() {
        return this.h;
    }

    @VisibleForDebug
    void a(PathPoint[] debugNodes, PathPoint[] debugSecondNodes, Set<PathDestination> debugTargetNodes) {
        this.b = debugNodes;
        this.c = debugSecondNodes;
        this.d = debugTargetNodes;
    }

    @VisibleForDebug
    public PathPoint[] k() {
        return this.b;
    }

    @VisibleForDebug
    public PathPoint[] l() {
        return this.c;
    }

    public void a(PacketDataSerializer buffer) {
        if (this.d != null && !this.d.isEmpty()) {
            buffer.writeBoolean(this.h);
            buffer.writeInt(this.e);
            buffer.writeInt(this.d.size());
            this.d.forEach(target -> target.a(buffer));
            buffer.writeInt(this.f.u());
            buffer.writeInt(this.f.v());
            buffer.writeInt(this.f.w());
            buffer.writeInt(this.a.size());
            for (PathPoint node : this.a) {
                node.a(buffer);
            }
            buffer.writeInt(this.b.length);
            for (PathPoint node2 : this.b) {
                node2.a(buffer);
            }
            buffer.writeInt(this.c.length);
            for (PathPoint node3 : this.c) {
                node3.a(buffer);
            }
        }
    }

    public static PathEntity b(PacketDataSerializer buffer) {
        boolean bl = buffer.readBoolean();
        int i2 = buffer.readInt();
        int j2 = buffer.readInt();
        HashSet set = Sets.newHashSet();
        for (int k2 = 0; k2 < j2; ++k2) {
            set.add(PathDestination.c(buffer));
        }
        BlockPosition blockPos = new BlockPosition(buffer.readInt(), buffer.readInt(), buffer.readInt());
        ArrayList list = Lists.newArrayList();
        int l2 = buffer.readInt();
        for (int m2 = 0; m2 < l2; ++m2) {
            list.add(PathPoint.b(buffer));
        }
        PathPoint[] nodes = new PathPoint[buffer.readInt()];
        for (int n2 = 0; n2 < nodes.length; ++n2) {
            nodes[n2] = PathPoint.b(buffer);
        }
        PathPoint[] nodes2 = new PathPoint[buffer.readInt()];
        for (int o2 = 0; o2 < nodes2.length; ++o2) {
            nodes2[o2] = PathPoint.b(buffer);
        }
        PathEntity path = new PathEntity(list, blockPos, bl);
        path.b = nodes;
        path.c = nodes2;
        path.d = set;
        path.e = i2;
        return path;
    }

    public String toString() {
        return "Path(length=" + this.a.size() + ")";
    }

    public BlockPosition m() {
        return this.f;
    }

    public float n() {
        return this.g;
    }
}

