/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.PoiAccess;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalTravelAgent {
    private static final int a = 3;
    private static final int b = 128;
    private static final int c = 16;
    private static final int d = 5;
    private static final int e = 4;
    private static final int f = 3;
    private static final int g = -1;
    private static final int h = 4;
    private static final int i = -1;
    private static final int j = 3;
    private static final int k = -1;
    private static final int l = 2;
    private static final int m = -1;
    private final WorldServer n;

    public PortalTravelAgent(WorldServer world) {
        this.n = world;
    }

    public Optional<BlockUtil.Rectangle> a(BlockPosition pos, boolean destIsNether, WorldBorder worldBorder) {
        return this.findPortalAround(pos, worldBorder, destIsNether ? this.n.paperConfig().environment.portalCreateRadius : this.n.paperConfig().environment.portalSearchRadius);
    }

    public Optional<BlockUtil.Rectangle> findPortalAround(BlockPosition blockposition, WorldBorder worldborder, int i2) {
        VillagePlace villageplace = this.n.w();
        ArrayList<VillagePlaceRecord> records = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(villageplace, type -> type.a(PoiTypes.r), pos -> {
            IChunkAccess lowest = this.n.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.c);
            if (!(lowest.j().b(ChunkStatus.n) || lowest.x() != null && lowest.x().a().b(ChunkStatus.m))) {
                return false;
            }
            if (!worldborder.a((BlockPosition)pos) || this.n.getTypeKey() == WorldDimension.c && this.n.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> pos.v() >= v2)) {
                return false;
            }
            return lowest.a_((BlockPosition)pos).b(BlockProperties.H);
        }, blockposition, i2, Double.MAX_VALUE, VillagePlace.Occupancy.c, true, records);
        VillagePlaceRecord lowestYRecord = null;
        for (VillagePlaceRecord record : records) {
            if (lowestYRecord == null) {
                lowestYRecord = record;
                continue;
            }
            if (lowestYRecord.f().v() <= record.f().v()) continue;
            lowestYRecord = record;
        }
        Optional<Object> optional = Optional.ofNullable(lowestYRecord);
        return optional.map(villageplacerecord -> {
            BlockPosition blockposition1 = villageplacerecord.f();
            this.n.k().a(TicketType.f, new ChunkCoordIntPair(blockposition1), 3, blockposition1);
            IBlockData iblockdata = this.n.a_(blockposition1);
            return BlockUtil.a(blockposition1, iblockdata.c(BlockProperties.H), 21, EnumDirection.EnumAxis.b, 21, blockposition2 -> this.n.a_((BlockPosition)blockposition2) == iblockdata);
        });
    }

    public Optional<BlockUtil.Rectangle> a(BlockPosition pos, EnumDirection.EnumAxis axis) {
        return this.createPortal(pos, axis, null, 16);
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        int k1;
        int l2;
        int k2;
        int j2;
        EnumDirection enumdirection = EnumDirection.a(EnumDirection.EnumAxisDirection.a, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPosition blockposition1 = null;
        double d1 = -1.0;
        BlockPosition blockposition2 = null;
        WorldBorder worldborder = this.n.w_();
        int i2 = Math.min(this.n.aj(), this.n.C_() + this.n.j()) - 1;
        if (this.n.getTypeKey() == WorldDimension.c && this.n.paperConfig().environment.netherCeilingVoidDamageHeight.enabled()) {
            i2 = Math.min(i2, this.n.paperConfig().environment.netherCeilingVoidDamageHeight.intValue() - 1);
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.j();
        for (BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 : BlockPosition.a(blockposition, createRadius, EnumDirection.f, EnumDirection.d)) {
            j2 = Math.min(i2, this.n.a(HeightMap.Type.e, blockposition_mutableblockposition1.u(), blockposition_mutableblockposition1.w()));
            boolean flag = true;
            if (!worldborder.a(blockposition_mutableblockposition1) || !worldborder.a(blockposition_mutableblockposition1.c(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.c(enumdirection.g(), 1);
            for (k2 = j2; k2 >= this.n.C_(); --k2) {
                int i1;
                blockposition_mutableblockposition1.q(k2);
                if (!this.a(blockposition_mutableblockposition1)) continue;
                l2 = k2;
                while (k2 > this.n.C_() && this.a(blockposition_mutableblockposition1.c(EnumDirection.a))) {
                    --k2;
                }
                if (k2 + 4 > i2 || (i1 = l2 - k2) > 0 && i1 < 3) continue;
                blockposition_mutableblockposition1.q(k2);
                if (!this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.j(blockposition_mutableblockposition1);
                if (this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.i();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.i();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.n);
        if (d0 == -1.0) {
            k1 = i2 - 9;
            int j1 = Math.max(this.n.C_() - -1, 70);
            if (k1 < j1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPosition(blockposition.u(), MathHelper.a(blockposition.v(), j1, k1), blockposition.w()).i();
            EnumDirection enumdirection1 = enumdirection.h();
            if (!worldborder.a(blockposition1)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (k2 = 0; k2 < 2; ++k2) {
                    for (l2 = -1; l2 < 3; ++l2) {
                        IBlockData iblockdata = l2 < 0 ? Blocks.co.n() : Blocks.a.n();
                        blockposition_mutableblockposition.a(blockposition1, k2 * enumdirection.j() + l1 * enumdirection1.j(), l2, k2 * enumdirection.l() + l1 * enumdirection1.l());
                        blockList.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int j1 = -1; j1 < 3; ++j1) {
            for (k1 = -1; k1 < 4; ++k1) {
                if (j1 != -1 && j1 != 2 && k1 != -1 && k1 != 3) continue;
                blockposition_mutableblockposition.a(blockposition1, j1 * enumdirection.j(), k1, j1 * enumdirection.l());
                blockList.a((BlockPosition)blockposition_mutableblockposition, Blocks.co.n(), 3);
            }
        }
        IBlockData iblockdata1 = (IBlockData)Blocks.ee.n().a(BlockPortal.a, enumdirection_enumaxis);
        for (k1 = 0; k1 < 2; ++k1) {
            for (j2 = 0; j2 < 3; ++j2) {
                blockposition_mutableblockposition.a(blockposition1, k1 * enumdirection.j(), j2, k1 * enumdirection.l());
                blockList.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.n.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.n.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.Rectangle(blockposition1.i(), 2, 3));
    }

    private boolean a(BlockPosition.MutableBlockPosition pos) {
        IBlockData iblockdata = this.n.a_(pos);
        return iblockdata.r() && iblockdata.u().c();
    }

    private boolean a(BlockPosition pos, BlockPosition.MutableBlockPosition temp, EnumDirection portalDirection, int distanceOrthogonalToPortal) {
        EnumDirection enumdirection1 = portalDirection.h();
        for (int j2 = -1; j2 < 3; ++j2) {
            for (int k2 = -1; k2 < 4; ++k2) {
                temp.a(pos, portalDirection.j() * j2 + enumdirection1.j() * distanceOrthogonalToPortal, k2, portalDirection.l() * j2 + enumdirection1.l() * distanceOrthogonalToPortal);
                if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && !this.n.a_(temp).isDestroyable()) {
                    return false;
                }
                if (k2 < 0 && !this.n.a_(temp).e()) {
                    return false;
                }
                if (k2 < 0 || this.a(temp)) continue;
                return false;
            }
        }
        return true;
    }
}

