/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.NeighborUpdater;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.slf4j.Logger;
import top.leavesmc.leaves.command.NoBlockUpdateCommand;

public class CollectingNeighborUpdater
implements NeighborUpdater {
    private static final Logger b = LogUtils.getLogger();
    private final World c;
    private final int d;
    private final ArrayDeque<c> e = new ArrayDeque();
    private final List<c> f = new ArrayList<c>();
    private int g = 0;

    public CollectingNeighborUpdater(World world, int maxChainDepth) {
        this.c = world;
        this.d = maxChainDepth;
    }

    @Override
    public void a(EnumDirection direction, IBlockData neighborState, BlockPosition pos, BlockPosition neighborPos, int flags, int maxUpdateDepth) {
        this.a(pos, new d(direction, neighborState, pos.i(), neighborPos.i(), flags, maxUpdateDepth));
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, BlockPosition sourcePos) {
        this.a(pos, new e(pos, sourceBlock, sourcePos.i()));
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        this.a(pos, new a(state, pos.i(), sourceBlock, sourcePos.i(), notify));
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, @Nullable EnumDirection except) {
        this.a(pos, new b(pos.i(), sourceBlock, except));
    }

    private void a(BlockPosition pos, c entry) {
        if (NoBlockUpdateCommand.isNoBlockUpdate()) {
            return;
        }
        boolean bl = this.g > 0;
        boolean bl2 = this.d >= 0 && this.g >= this.d;
        ++this.g;
        if (!bl2) {
            if (bl) {
                this.f.add(entry);
            } else {
                this.e.push(entry);
            }
        } else if (this.g - 1 == this.d) {
            b.error("Too many chained neighbor updates. Skipping the rest. First skipped position: " + pos.x());
        }
        if (!bl) {
            this.a();
        }
    }

    private void a() {
        try {
            block3: while (!this.e.isEmpty() || !this.f.isEmpty()) {
                for (int i2 = this.f.size() - 1; i2 >= 0; --i2) {
                    this.e.push(this.f.get(i2));
                }
                this.f.clear();
                c neighborUpdates = this.e.peek();
                while (this.f.isEmpty()) {
                    if (neighborUpdates.a(this.c)) continue;
                    this.e.pop();
                    continue block3;
                }
            }
        }
        finally {
            this.e.clear();
            this.f.clear();
            this.g = 0;
        }
    }

    record d(EnumDirection a, IBlockData b, BlockPosition c, BlockPosition d, int e, int f) implements c
    {
        @Override
        public boolean a(World world) {
            NeighborUpdater.a(world, this.a, this.b, this.c, this.d, this.e, this.f);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "direction;state;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "direction;state;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "direction;state;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    static interface c {
        public boolean a(World var1);
    }

    record e(BlockPosition a, Block b, BlockPosition c) implements c
    {
        @Override
        public boolean a(World world) {
            IBlockData blockState = world.a_(this.a);
            NeighborUpdater.a(world, blockState, this.a, this.b, this.c, false);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "pos;block;neighborPos", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "pos;block;neighborPos", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "pos;block;neighborPos", "a", "b", "c"}, this, o2);
        }
    }

    record a(IBlockData a, BlockPosition b, Block c, BlockPosition d, boolean e) implements c
    {
        @Override
        public boolean a(World world) {
            NeighborUpdater.a(world, this.a, this.b, this.c, this.d, this.e);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "state;pos;block;neighborPos;movedByPiston", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "state;pos;block;neighborPos;movedByPiston", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "state;pos;block;neighborPos;movedByPiston", "a", "b", "c", "d", "e"}, this, o2);
        }
    }

    static final class b
    implements c {
        private final BlockPosition a;
        private final Block b;
        @Nullable
        private final EnumDirection c;
        private int d = 0;

        b(BlockPosition pos, Block sourceBlock, @Nullable EnumDirection except) {
            this.a = pos;
            this.b = sourceBlock;
            this.c = except;
            if (NeighborUpdater.a[this.d] == except) {
                ++this.d;
            }
        }

        @Override
        public boolean a(World world) {
            BlockPosition blockPos = this.a.a(NeighborUpdater.a[this.d++]);
            IBlockData blockState = world.a_(blockPos);
            try {
                BlockPhysicsEvent event;
                boolean cancelled = false;
                CraftWorld cworld = world.getWorld();
                if (cworld != null && !(event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(world, blockPos), (BlockData)CraftBlockData.fromData(blockState), (org.bukkit.block.Block)CraftBlock.at(world, this.a))).callEvent()) {
                    cancelled = true;
                }
                if (!cancelled) {
                    blockState.a(world, blockPos, this.b, this.a, false);
                }
            }
            catch (StackOverflowError ex) {
                World.lastPhysicsProblem = new BlockPosition(blockPos);
            }
            if (this.d < NeighborUpdater.a.length && NeighborUpdater.a[this.d] == this.c) {
                ++this.d;
            }
            return this.d < NeighborUpdater.a.length;
        }
    }
}

