/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData {
    private static final Logger a = LogUtils.getLogger();
    public final Map<String, PersistentBase> b = Maps.newHashMap();
    private final DataFixer c;
    private final File d;

    public WorldPersistentData(File directory, DataFixer dataFixer) {
        this.c = dataFixer;
        this.d = directory;
    }

    private File a(String id) {
        return new File(this.d, id + ".dat");
    }

    public <T extends PersistentBase> T a(Function<NBTTagCompound, T> readFunction, Supplier<T> supplier, String id) {
        T savedData = this.a(readFunction, id);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData2 = (PersistentBase)supplier.get();
        this.a(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends PersistentBase> T a(Function<NBTTagCompound, T> readFunction, String id) {
        PersistentBase savedData = this.b.get(id);
        if (savedData == null && !this.b.containsKey(id)) {
            savedData = this.b(readFunction, id);
            this.b.put(id, savedData);
        }
        return (T)savedData;
    }

    @Nullable
    private <T extends PersistentBase> T b(Function<NBTTagCompound, T> readFunction, String id) {
        try {
            File file = this.a(id);
            if (file.exists()) {
                NBTTagCompound compoundTag = this.a(id, SharedConstants.b().d().c());
                return (T)((PersistentBase)readFunction.apply(compoundTag.p("data")));
            }
        }
        catch (Exception exception) {
            a.error("Error loading saved data: {}", (Object)id, (Object)exception);
        }
        return null;
    }

    public void a(String id, PersistentBase state) {
        this.b.put(id, state);
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound a(String id, int dataVersion) throws IOException {
        File file = this.a(id);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound;
            try (PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);){
                void compoundTag3;
                if (this.a(pushbackInputStream)) {
                    NBTTagCompound compoundTag = NBTCompressedStreamTools.a(pushbackInputStream);
                } else {
                    try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                        NBTTagCompound compoundTag2 = NBTCompressedStreamTools.a(dataInputStream);
                    }
                }
                int i2 = GameProfileSerializer.b((NBTTagCompound)compoundTag3, 1343);
                nBTTagCompound = DataFixTypes.h.a(this.c, (NBTTagCompound)compoundTag3, i2, dataVersion);
            }
            return nBTTagCompound;
        }
    }

    private boolean a(PushbackInputStream stream) throws IOException {
        int j2;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i2 = stream.read(bs, 0, 2);
        if (i2 == 2 && (j2 = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i2 != 0) {
            stream.unread(bs, 0, i2);
        }
        return bl;
    }

    public void a() {
        this.b.forEach((id, state) -> {
            if (state != null) {
                state.a(this.a((String)id));
            }
        });
    }
}

