/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class IntRange {
    @Nullable
    final NumberProvider a;
    @Nullable
    final NumberProvider b;
    private final b c;
    private final a d;

    public Set<LootContextParameter<?>> a() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.a != null) {
            builder.addAll(this.a.a());
        }
        if (this.b != null) {
            builder.addAll(this.b.a());
        }
        return builder.build();
    }

    IntRange(@Nullable NumberProvider min, @Nullable NumberProvider max) {
        this.a = min;
        this.b = max;
        if (min == null) {
            if (max == null) {
                this.c = (context, value) -> value;
                this.d = (context, value) -> true;
            } else {
                this.c = (context, value) -> Math.min(max.a(context), value);
                this.d = (context, value) -> value <= max.a(context);
            }
        } else if (max == null) {
            this.c = (context, value) -> Math.max(min.a(context), value);
            this.d = (context, value) -> value >= min.a(context);
        } else {
            this.c = (context, value) -> MathHelper.a(value, min.a(context), max.a(context));
            this.d = (context, value) -> value >= min.a(context) && value <= max.a(context);
        }
    }

    public static IntRange a(int value) {
        ConstantValue constantValue = ConstantValue.a(value);
        return new IntRange(constantValue, constantValue);
    }

    public static IntRange a(int min, int max) {
        return new IntRange(ConstantValue.a(min), ConstantValue.a(max));
    }

    public static IntRange b(int min) {
        return new IntRange(ConstantValue.a(min), null);
    }

    public static IntRange c(int max) {
        return new IntRange(null, ConstantValue.a(max));
    }

    public int a(LootTableInfo context, int value) {
        return this.c.apply(context, value);
    }

    public boolean b(LootTableInfo context, int value) {
        return this.d.test(context, value);
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }

    public static class c
    implements JsonDeserializer<IntRange>,
    JsonSerializer<IntRange> {
        @Override
        public IntRange a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            if (jsonElement.isJsonPrimitive()) {
                return IntRange.a(jsonElement.getAsInt());
            }
            JsonObject jsonObject = ChatDeserializer.m(jsonElement, "value");
            NumberProvider numberProvider = jsonObject.has("min") ? ChatDeserializer.a(jsonObject, "min", jsonDeserializationContext, NumberProvider.class) : null;
            NumberProvider numberProvider2 = jsonObject.has("max") ? ChatDeserializer.a(jsonObject, "max", jsonDeserializationContext, NumberProvider.class) : null;
            return new IntRange(numberProvider, numberProvider2);
        }

        @Override
        public JsonElement a(IntRange intRange, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            if (Objects.equals(intRange.b, intRange.a)) {
                return jsonSerializationContext.serialize((Object)intRange.a);
            }
            if (intRange.b != null) {
                jsonObject.add("max", jsonSerializationContext.serialize((Object)intRange.b));
            }
            if (intRange.a != null) {
                jsonObject.add("min", jsonSerializationContext.serialize((Object)intRange.a));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((IntRange)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

