/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootDataManager
implements IReloadListener,
LootDataResolver {
    private static final Logger b = LogUtils.getLogger();
    public static final LootDataId<LootTable> a = new LootDataId<LootTable>(LootDataType.c, LootTables.a);
    private Map<LootDataId<?>, ?> c = Map.of();
    private Multimap<LootDataType<?>, MinecraftKey> d = ImmutableMultimap.of();
    public Map<?, MinecraftKey> lootTableToKey = ImmutableMap.of();

    @Override
    public final CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, GameProfilerFiller prepareProfiler, GameProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        HashMap map = new HashMap();
        CompletableFuture[] acompletablefuture = (CompletableFuture[])LootDataType.c().map(lootdatatype -> LootDataManager.a(lootdatatype, manager, prepareExecutor, map)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf(acompletablefuture);
        Objects.requireNonNull(synchronizer);
        return ((CompletableFuture)completablefuture.thenCompose(synchronizer::a)).thenAcceptAsync(ovoid -> this.a(map), applyExecutor);
    }

    private static <T> CompletableFuture<?> a(LootDataType<T> type, IResourceManager resourceManager, Executor executor, Map<LootDataType<?>, Map<MinecraftKey, ?>> results) {
        HashMap map1 = new HashMap();
        results.put(type, map1);
        return CompletableFuture.runAsync(() -> {
            HashMap<MinecraftKey, JsonElement> map2 = new HashMap<MinecraftKey, JsonElement>();
            ResourceDataJson.a(resourceManager, type.b(), type.a(), map2);
            map2.forEach((minecraftkey, jsonelement) -> type.a((MinecraftKey)minecraftkey, (JsonElement)jsonelement).ifPresent(object -> map1.put(minecraftkey, object)));
        }, executor);
    }

    private void a(Map<LootDataType<?>, Map<MinecraftKey, ?>> lootData) {
        Object object = lootData.get(LootDataType.c).remove(LootTables.a);
        if (object != null) {
            b.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.a);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder com_google_common_collect_immutablemultimap_builder = ImmutableMultimap.builder();
        lootData.forEach((lootdatatype, map1) -> map1.forEach((minecraftkey, object1) -> {
            builder.put(new LootDataId(lootdatatype, (MinecraftKey)minecraftkey), object1);
            com_google_common_collect_immutablemultimap_builder.put(lootdatatype, minecraftkey);
        }));
        builder.put(a, (Object)LootTable.a);
        ImmutableMap map12 = builder.build();
        LootCollector lootcollector = new LootCollector(LootContextParameterSets.m, new LootDataResolver(){
            final /* synthetic */ Map val$map1;
            {
                this.val$map1 = map;
            }

            @Override
            @Nullable
            public <T> T getElement(LootDataId<T> key) {
                return (T)this.val$map1.get(key);
            }
        });
        map12.forEach((lootdataid, object1) -> LootDataManager.a(lootcollector, lootdataid, object1));
        lootcollector.a().forEach((s2, s1) -> b.warn("Found loot table element validation problem in {}: {}", s2, s1));
        this.c = map12;
        this.d = com_google_common_collect_immutablemultimap_builder.build();
        ImmutableMap.Builder lootTableToKeyBuilder = ImmutableMap.builder();
        this.c.forEach((key, lootTable) -> lootTableToKeyBuilder.put(lootTable, (Object)key.b()));
        this.lootTableToKey = lootTableToKeyBuilder.build();
    }

    private static <T> void a(LootCollector reporter, LootDataId<T> key, Object value) {
        key.a().a(reporter, key, value);
    }

    @Override
    @Nullable
    public <T> T getElement(LootDataId<T> key) {
        return (T)this.c.get(key);
    }

    public Collection<MinecraftKey> a(LootDataType<?> type) {
        return this.d.get(type);
    }

    public static LootItemCondition a(LootItemCondition[] predicates) {
        return new a(predicates);
    }

    public static LootItemFunction a(LootItemFunction[] modifiers) {
        return new b(modifiers);
    }

    private static class a
    implements LootItemCondition {
        private final LootItemCondition[] a;
        private final Predicate<LootTableInfo> b;

        a(LootItemCondition[] terms) {
            this.a = terms;
            this.b = LootItemConditions.a(terms);
        }

        public final boolean a(LootTableInfo loottableinfo) {
            return this.b.test(loottableinfo);
        }

        @Override
        public void a(LootCollector reporter) {
            LootItemCondition.super.a(reporter);
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2].a(reporter.b(".term[" + i2 + "]"));
            }
        }

        @Override
        public LootItemConditionType b() {
            throw new UnsupportedOperationException();
        }
    }

    private static class b
    implements LootItemFunction {
        protected final LootItemFunction[] a;
        private final BiFunction<ItemStack, LootTableInfo, ItemStack> b;

        public b(LootItemFunction[] functions) {
            this.a = functions;
            this.b = LootItemFunctions.a(functions);
        }

        public ItemStack a(ItemStack itemstack, LootTableInfo loottableinfo) {
            return this.b.apply(itemstack, loottableinfo);
        }

        @Override
        public void a(LootCollector reporter) {
            LootItemFunction.super.a(reporter);
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2].a(reporter.b(".function[" + i2 + "]"));
            }
        }

        @Override
        public LootItemFunctionType b() {
            throw new UnsupportedOperationException();
        }
    }
}

