/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger a = LogUtils.getLogger();
    final List<Enchantment> b;

    LootItemFunctionEnchant(LootItemCondition[] conditions, Collection<Enchantment> enchantments) {
        super(conditions);
        this.b = ImmutableList.copyOf(enchantments);
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.d;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        Enchantment enchantment2;
        RandomSource randomSource = context.b();
        if (this.b.isEmpty()) {
            boolean bl = stack.a(Items.qb);
            List list = BuiltInRegistries.g.s().filter(Enchantment::i).filter(enchantment -> bl || enchantment.a(stack)).collect(Collectors.toList());
            if (list.isEmpty()) {
                a.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
                return stack;
            }
            Enchantment enchantment3 = (Enchantment)list.get(randomSource.a(list.size()));
        } else {
            enchantment2 = this.b.get(randomSource.a(this.b.size()));
        }
        return LootItemFunctionEnchant.a(stack, enchantment2, randomSource);
    }

    private static ItemStack a(ItemStack stack, Enchantment enchantment, RandomSource random) {
        int i2 = MathHelper.a(random, enchantment.e(), enchantment.a());
        if (stack.a(Items.qb)) {
            stack = new ItemStack(Items.tC);
            ItemEnchantedBook.a(stack, new WeightedRandomEnchant(enchantment, i2));
        } else {
            stack.a(enchantment, i2);
        }
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static LootItemFunctionConditional.a<?> d() {
        return LootItemFunctionEnchant.a(conditions -> new LootItemFunctionEnchant((LootItemCondition[])conditions, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Set<Enchantment> a = Sets.newHashSet();

        @Override
        protected a a() {
            return this;
        }

        public a a(Enchantment enchantment) {
            this.a.add(enchantment);
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionEnchant(this.g(), this.a);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionEnchant> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionEnchant object, JsonSerializationContext context) {
            super.a(json, object, context);
            if (!object.b.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Enchantment enchantment : object.b) {
                    MinecraftKey resourceLocation = BuiltInRegistries.g.b(enchantment);
                    if (resourceLocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive(resourceLocation.toString()));
                }
                json.add("enchantments", (JsonElement)jsonArray);
            }
        }

        @Override
        public LootItemFunctionEnchant a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            ArrayList list = Lists.newArrayList();
            if (jsonObject.has("enchantments")) {
                JsonArray jsonArray = ChatDeserializer.v(jsonObject, "enchantments");
                for (JsonElement jsonElement : jsonArray) {
                    String string = ChatDeserializer.a(jsonElement, "enchantment");
                    Enchantment enchantment = BuiltInRegistries.g.b(new MinecraftKey(string)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + string + "'"));
                    list.add(enchantment);
                }
            }
            return new LootItemFunctionEnchant(lootItemConditions, list);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

