/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger a = LogUtils.getLogger();
    final IChatBaseComponent b;
    @Nullable
    final LootTableInfo.EntityTarget c;

    LootItemFunctionSetName(LootItemCondition[] conditions, @Nullable IChatBaseComponent name, @Nullable LootTableInfo.EntityTarget entity) {
        super(conditions);
        this.b = name;
        this.c = entity;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.k;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return this.c != null ? ImmutableSet.of(this.c.a()) : ImmutableSet.of();
    }

    public static UnaryOperator<IChatBaseComponent> a(LootTableInfo context, @Nullable LootTableInfo.EntityTarget sourceEntity) {
        Entity entity;
        if (sourceEntity != null && (entity = context.c(sourceEntity.a())) != null) {
            CommandListenerWrapper commandSourceStack = entity.da().a(2);
            return textComponent -> {
                try {
                    return ChatComponentUtils.a(commandSourceStack, textComponent, entity, 0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    a.warn("Failed to resolve text component", (Throwable)commandSyntaxException);
                    return textComponent;
                }
            };
        }
        return textComponent -> textComponent;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (this.b != null) {
            stack.a((IChatBaseComponent)LootItemFunctionSetName.a(context, this.c).apply(this.b));
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name) {
        return LootItemFunctionSetName.a((LootItemCondition[] conditions) -> new LootItemFunctionSetName((LootItemCondition[])conditions, name, null));
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, LootTableInfo.EntityTarget target) {
        return LootItemFunctionSetName.a((LootItemCondition[] conditions) -> new LootItemFunctionSetName((LootItemCondition[])conditions, name, target));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionSetName> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionSetName object, JsonSerializationContext context) {
            super.a(json, object, context);
            if (object.b != null) {
                json.add("name", IChatBaseComponent.ChatSerializer.c(object.b));
            }
            if (object.c != null) {
                json.add("entity", context.serialize((Object)object.c));
            }
        }

        @Override
        public LootItemFunctionSetName a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(jsonObject.get("name"));
            LootTableInfo.EntityTarget entityTarget = ChatDeserializer.a(jsonObject, "entity", null, jsonDeserializationContext, LootTableInfo.EntityTarget.class);
            return new LootItemFunctionSetName(lootItemConditions, component, entityTarget);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

