/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTag;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> a = (stack, context) -> stack;
    public static final LootItemFunctionType b = LootItemFunctions.a("set_count", new LootItemFunctionSetCount.a());
    public static final LootItemFunctionType c = LootItemFunctions.a("enchant_with_levels", new LootEnchantLevel.b());
    public static final LootItemFunctionType d = LootItemFunctions.a("enchant_randomly", new LootItemFunctionEnchant.b());
    public static final LootItemFunctionType e = LootItemFunctions.a("set_enchantments", new SetEnchantmentsFunction.b());
    public static final LootItemFunctionType f = LootItemFunctions.a("set_nbt", new LootItemFunctionSetTag.a());
    public static final LootItemFunctionType g = LootItemFunctions.a("furnace_smelt", new LootItemFunctionSmelt.a());
    public static final LootItemFunctionType h = LootItemFunctions.a("looting_enchant", new LootEnchantFunction.b());
    public static final LootItemFunctionType i = LootItemFunctions.a("set_damage", new LootItemFunctionSetDamage.a());
    public static final LootItemFunctionType j = LootItemFunctions.a("set_attributes", new LootItemFunctionSetAttribute.d());
    public static final LootItemFunctionType k = LootItemFunctions.a("set_name", new LootItemFunctionSetName.a());
    public static final LootItemFunctionType l = LootItemFunctions.a("exploration_map", new LootItemFunctionExplorationMap.b());
    public static final LootItemFunctionType m = LootItemFunctions.a("set_stew_effect", new LootItemFunctionSetStewEffect.b());
    public static final LootItemFunctionType n = LootItemFunctions.a("copy_name", new LootItemFunctionCopyName.b());
    public static final LootItemFunctionType o = LootItemFunctions.a("set_contents", new LootItemFunctionSetContents.b());
    public static final LootItemFunctionType p = LootItemFunctions.a("limit_count", new LootItemFunctionLimitCount.a());
    public static final LootItemFunctionType q = LootItemFunctions.a("apply_bonus", new LootItemFunctionApplyBonus.e());
    public static final LootItemFunctionType r = LootItemFunctions.a("set_loot_table", new LootItemFunctionSetTable.a());
    public static final LootItemFunctionType s = LootItemFunctions.a("explosion_decay", new LootItemFunctionExplosionDecay.a());
    public static final LootItemFunctionType t = LootItemFunctions.a("set_lore", new LootItemFunctionSetLore.b());
    public static final LootItemFunctionType u = LootItemFunctions.a("fill_player_head", new LootItemFunctionFillPlayerHead.a());
    public static final LootItemFunctionType v = LootItemFunctions.a("copy_nbt", new LootItemFunctionCopyNBT.d());
    public static final LootItemFunctionType w = LootItemFunctions.a("copy_state", new LootItemFunctionCopyState.b());
    public static final LootItemFunctionType x = LootItemFunctions.a("set_banner_pattern", new SetBannerPatternFunction.b());
    public static final LootItemFunctionType y = LootItemFunctions.a("set_potion", new SetPotionFunction.a());
    public static final LootItemFunctionType z = LootItemFunctions.a("set_instrument", new SetInstrumentFunction.a());
    public static final LootItemFunctionType A = LootItemFunctions.a("reference", new FunctionReference.a());

    private static LootItemFunctionType a(String id, LootSerializer<? extends LootItemFunction> jsonSerializer) {
        return IRegistry.a(BuiltInRegistries.H, new MinecraftKey(id), new LootItemFunctionType(jsonSerializer));
    }

    public static Object a() {
        return JsonRegistry.a(BuiltInRegistries.H, "function", "function", LootItemFunction::b).a();
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> a(BiFunction<ItemStack, LootTableInfo, ItemStack>[] lootFunctions) {
        switch (lootFunctions.length) {
            case 0: {
                return a;
            }
            case 1: {
                return lootFunctions[0];
            }
            case 2: {
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction = lootFunctions[0];
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction2 = lootFunctions[1];
                return (stack, context) -> (ItemStack)biFunction2.apply((ItemStack)biFunction.apply((ItemStack)stack, (LootTableInfo)context), (LootTableInfo)context);
            }
        }
        return (stack, context) -> {
            for (BiFunction biFunction : lootFunctions) {
                stack = (ItemStack)biFunction.apply(stack, context);
            }
            return stack;
        };
    }
}

