/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBannerPatternFunction
extends LootItemFunctionConditional {
    final List<Pair<Holder<EnumBannerPatternType>, EnumColor>> a;
    final boolean b;

    SetBannerPatternFunction(LootItemCondition[] conditions, List<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns, boolean append) {
        super(conditions);
        this.a = patterns;
        this.b = append;
    }

    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        NBTTagList listTag3;
        NBTTagCompound compoundTag = ItemBlock.a(stack);
        if (compoundTag == null) {
            compoundTag = new NBTTagCompound();
        }
        EnumBannerPatternType.a builder = new EnumBannerPatternType.a();
        this.a.forEach(builder::a);
        NBTTagList listTag = builder.a();
        if (this.b) {
            NBTTagList listTag2 = compoundTag.c("Patterns", 10).e();
            listTag2.addAll(listTag);
        } else {
            listTag3 = listTag;
        }
        compoundTag.a("Patterns", listTag3);
        ItemBlock.a(stack, TileEntityTypes.t, compoundTag);
        return stack;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.x;
    }

    public static a a(boolean append) {
        return new a(append);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableList.Builder<Pair<Holder<EnumBannerPatternType>, EnumColor>> a = ImmutableList.builder();
        private final boolean b;

        a(boolean append) {
            this.b = append;
        }

        @Override
        protected a a() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new SetBannerPatternFunction(this.g(), (List<Pair<Holder<EnumBannerPatternType>, EnumColor>>)this.a.build(), this.b);
        }

        public a a(ResourceKey<EnumBannerPatternType> pattern, EnumColor color) {
            return this.a(BuiltInRegistries.al.f(pattern), color);
        }

        public a a(Holder<EnumBannerPatternType> pattern, EnumColor color) {
            this.a.add((Object)Pair.of(pattern, (Object)color));
            return this;
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<SetBannerPatternFunction> {
        @Override
        @Override
        public void a(JsonObject json, SetBannerPatternFunction object, JsonSerializationContext context) {
            super.a(json, object, context);
            JsonArray jsonArray = new JsonArray();
            object.a.forEach(pair -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("pattern", ((Holder)pair.getFirst()).e().orElseThrow(() -> new JsonSyntaxException("Unknown pattern: " + pair.getFirst())).a().toString());
                jsonObject.addProperty("color", ((EnumColor)pair.getSecond()).b());
                jsonArray.add((JsonElement)jsonObject);
            });
            json.add("patterns", (JsonElement)jsonArray);
            json.addProperty("append", Boolean.valueOf(object.b));
        }

        @Override
        public SetBannerPatternFunction a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            ImmutableList.Builder builder = ImmutableList.builder();
            JsonArray jsonArray = ChatDeserializer.v(jsonObject, "patterns");
            for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
                JsonObject jsonObject2 = ChatDeserializer.m(jsonArray.get(i2), "pattern[" + i2 + "]");
                String string = ChatDeserializer.i(jsonObject2, "pattern");
                Optional<Holder.c<EnumBannerPatternType>> optional = BuiltInRegistries.al.b(ResourceKey.a(Registries.c, new MinecraftKey(string)));
                if (optional.isEmpty()) {
                    throw new JsonSyntaxException("Unknown pattern: " + string);
                }
                String string2 = ChatDeserializer.i(jsonObject2, "color");
                EnumColor dyeColor = EnumColor.a(string2, null);
                if (dyeColor == null) {
                    throw new JsonSyntaxException("Unknown color: " + string2);
                }
                builder.add((Object)Pair.of((Object)optional.get(), (Object)dyeColor));
            }
            boolean bl = ChatDeserializer.k(jsonObject, "append");
            return new SetBannerPatternFunction(lootItemConditions, (List<Pair<Holder<EnumBannerPatternType>, EnumColor>>)builder.build(), bl);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

