/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionRandomChanceWithLooting
implements LootItemCondition {
    final float a;
    final float b;

    LootItemConditionRandomChanceWithLooting(float chance, float lootingMultiplier) {
        this.a = chance;
        this.b = lootingMultiplier;
    }

    @Override
    public LootItemConditionType b() {
        return LootItemConditions.e;
    }

    @Override
    public Set<LootContextParameter<?>> a() {
        return ImmutableSet.of(LootContextParameters.d);
    }

    public boolean a(LootTableInfo loottableinfo) {
        Entity entity = loottableinfo.c(LootContextParameters.d);
        int i2 = 0;
        if (entity instanceof EntityLiving) {
            i2 = EnchantmentManager.h((EntityLiving)entity);
        }
        if (loottableinfo.a(LootContextParameters.LOOTING_MOD)) {
            i2 = loottableinfo.c(LootContextParameters.LOOTING_MOD);
        }
        return loottableinfo.b().i() < this.a + (float)i2 * this.b;
    }

    public static LootItemCondition.a a(float chance, float lootingMultiplier) {
        return () -> new LootItemConditionRandomChanceWithLooting(chance, lootingMultiplier);
    }

    public static class a
    implements LootSerializer<LootItemConditionRandomChanceWithLooting> {
        @Override
        public void a(JsonObject json, LootItemConditionRandomChanceWithLooting object, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(object.a));
            json.addProperty("looting_multiplier", (Number)Float.valueOf(object.b));
        }

        public LootItemConditionRandomChanceWithLooting b(JsonObject json, JsonDeserializationContext context) {
            return new LootItemConditionRandomChanceWithLooting(ChatDeserializer.m(json, "chance"), ChatDeserializer.m(json, "looting_multiplier"));
        }
    }
}

