/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootItemConditionReference
implements LootItemCondition {
    private static final Logger a = LogUtils.getLogger();
    final MinecraftKey b;

    LootItemConditionReference(MinecraftKey id) {
        this.b = id;
    }

    @Override
    @Override
    public LootItemConditionType b() {
        return LootItemConditions.p;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        LootDataId<LootItemCondition> lootDataId = new LootDataId<LootItemCondition>(LootDataType.a, this.b);
        if (reporter.a(lootDataId)) {
            reporter.a("Condition " + this.b + " is recursively called");
            return;
        }
        LootItemCondition.super.a(reporter);
        reporter.b().getElementOptional(lootDataId).ifPresentOrElse(predicate -> predicate.a(reporter.a(".{" + this.b + "}", lootDataId)), () -> reporter.a("Unknown condition table called " + this.b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean a(LootTableInfo lootContext) {
        LootItemCondition lootItemCondition = lootContext.a().getElement(LootDataType.a, this.b);
        if (lootItemCondition == null) {
            a.warn("Tried using unknown condition table called {}", (Object)this.b);
            return false;
        }
        LootTableInfo.c<LootItemCondition> visitedEntry = LootTableInfo.a(lootItemCondition);
        if (lootContext.b(visitedEntry)) {
            try {
                boolean bl = lootItemCondition.test(lootContext);
                return bl;
            }
            finally {
                lootContext.c(visitedEntry);
            }
        }
        a.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a a(MinecraftKey id) {
        return () -> new LootItemConditionReference(id);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionReference> {
        @Override
        @Override
        public void a(JsonObject json, LootItemConditionReference object, JsonSerializationContext context) {
            json.addProperty("name", object.b.toString());
        }

        @Override
        public LootItemConditionReference b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.i(jsonObject, "name"));
            return new LootItemConditionReference(resourceLocation);
        }

        @Override
        public /* synthetic */ Object a(JsonObject json, JsonDeserializationContext context) {
            return this.b(json, context);
        }
    }
}

