/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBanner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBed;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBell;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftComparator;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftConduit;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftDropper;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEndPortal;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftHopper;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftLectern;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftMovingPiston;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftMagicNumbers.getMaterial(blockData.b()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };
    private static final Map<TileEntityTypes<?>, BlockStateFactory<?>> FACTORIES_BY_BLOCK_ENTITY_TYPE = new HashMap();

    private static void register(TileEntityTypes<?> type, BlockStateFactory<?> factory) {
        FACTORIES_BY_BLOCK_ENTITY_TYPE.put(type, factory);
    }

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends TileEntity, B extends CraftBlockEntityState<T>> void register(TileEntityTypes<? extends T> blockEntityType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor) {
        BlockEntityStateFactory<TileEntity, B> factory = new BlockEntityStateFactory<TileEntity, B>(blockStateType, blockStateConstructor, blockEntityType::a);
        for (Block block : blockEntityType.R) {
            CraftBlockStates.register(CraftMagicNumbers.getMaterial(block), factory);
        }
        CraftBlockStates.register(blockEntityType, factory);
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    private static BlockStateFactory<?> getFactory(Material material, TileEntityTypes<?> type) {
        if (type != null) {
            return FACTORIES_BY_BLOCK_ENTITY_TYPE.getOrDefault(type, CraftBlockStates.getFactory(material));
        }
        return CraftBlockStates.getFactory(material);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static TileEntity createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(BlockPosition.b, CraftMagicNumbers.getBlock(material).n());
        }
        return null;
    }

    public static Class<? extends CraftBlockState> getBlockStateType(TileEntityTypes<?> blockEntityType) {
        Preconditions.checkNotNull(blockEntityType, (Object)"blockEntityType is null");
        return CraftBlockStates.getFactory(null, blockEntityType).blockStateType;
    }

    public static BlockState getBlockState(org.bukkit.block.Block block) {
        return CraftBlockStates.getBlockState(block, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockState getBlockState(org.bukkit.block.Block block, boolean useSnapshot) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockPosition blockPosition = craftBlock.getPosition();
        IBlockData blockData = craftBlock.getNMS();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        boolean prev = CraftBlockEntityState.DISABLE_SNAPSHOT;
        CraftBlockEntityState.DISABLE_SNAPSHOT = !useSnapshot;
        try {
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
            blockState.setWorldHandle(craftBlock.getHandle());
            CraftBlockState craftBlockState = blockState;
            return craftBlockState;
        }
        finally {
            CraftBlockEntityState.DISABLE_SNAPSHOT = prev;
        }
    }

    public static BlockState getBlockState(Material material, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(BlockPosition.b, material, blockEntityTag);
    }

    public static BlockState getBlockState(BlockPosition blockPosition, Material material, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        IBlockData blockData = CraftMagicNumbers.getBlock(material).n();
        return CraftBlockStates.getBlockState(blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(IBlockData blockData, @Nullable NBTTagCompound blockEntityTag) {
        return CraftBlockStates.getBlockState(BlockPosition.b, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(BlockPosition blockPosition, IBlockData blockData, @Nullable NBTTagCompound blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        TileEntity tileEntity = blockEntityTag == null ? null : TileEntity.a(blockPosition, blockData, blockEntityTag);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    public static BlockState getUnplacedBlockState(IBlockAccess levelAccessor, BlockPosition blockPos, IBlockData blockData) {
        TileEntity tileEntity = levelAccessor.c_(blockPos);
        return CraftBlockStates.getBlockState(null, blockPos, blockData, tileEntity);
    }

    private static CraftBlockState getBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
        Material material = CraftMagicNumbers.getMaterial(blockData.b());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material, tileEntity != null ? tileEntity.u() : null);
        return factory.createBlockState(world, blockPosition, blockData, tileEntity);
    }

    public static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(GeneratorAccess world, BlockPosition pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    public static CraftBlockState getBlockState(GeneratorAccess world, BlockPosition pos, int flag) {
        return new CraftBlockState(CraftBlock.at(world, pos), flag);
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(TileEntityTypes.h, CraftSign.class, CraftSign::new);
        CraftBlockStates.register(TileEntityTypes.i, CraftHangingSign.class, CraftHangingSign::new);
        CraftBlockStates.register(TileEntityTypes.p, CraftSkull.class, CraftSkull::new);
        CraftBlockStates.register(TileEntityTypes.w, CraftCommandBlock.class, CraftCommandBlock::new);
        CraftBlockStates.register(TileEntityTypes.t, CraftBanner.class, CraftBanner::new);
        CraftBlockStates.register(TileEntityTypes.x, CraftShulkerBox.class, CraftShulkerBox::new);
        CraftBlockStates.register(TileEntityTypes.y, CraftBed.class, CraftBed::new);
        CraftBlockStates.register(TileEntityTypes.H, CraftBeehive.class, CraftBeehive::new);
        CraftBlockStates.register(TileEntityTypes.G, CraftCampfire.class, CraftCampfire::new);
        CraftBlockStates.register(TileEntityTypes.A, CraftBarrel.class, CraftBarrel::new);
        CraftBlockStates.register(TileEntityTypes.o, CraftBeacon.class, CraftBeacon::new);
        CraftBlockStates.register(TileEntityTypes.E, CraftBell.class, CraftBell::new);
        CraftBlockStates.register(TileEntityTypes.C, CraftBlastFurnace.class, CraftBlastFurnace::new);
        CraftBlockStates.register(TileEntityTypes.l, CraftBrewingStand.class, CraftBrewingStand::new);
        CraftBlockStates.register(TileEntityTypes.b, CraftChest.class, CraftChest::new);
        CraftBlockStates.register(TileEntityTypes.M, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new);
        CraftBlockStates.register(TileEntityTypes.s, CraftComparator.class, CraftComparator::new);
        CraftBlockStates.register(TileEntityTypes.z, CraftConduit.class, CraftConduit::new);
        CraftBlockStates.register(TileEntityTypes.q, CraftDaylightDetector.class, CraftDaylightDetector::new);
        CraftBlockStates.register(TileEntityTypes.O, CraftDecoratedPot.class, CraftDecoratedPot::new);
        CraftBlockStates.register(TileEntityTypes.f, CraftDispenser.class, CraftDispenser::new);
        CraftBlockStates.register(TileEntityTypes.g, CraftDropper.class, CraftDropper::new);
        CraftBlockStates.register(TileEntityTypes.m, CraftEnchantingTable.class, CraftEnchantingTable::new);
        CraftBlockStates.register(TileEntityTypes.d, CraftEnderChest.class, CraftEnderChest::new);
        CraftBlockStates.register(TileEntityTypes.v, CraftEndGateway.class, CraftEndGateway::new);
        CraftBlockStates.register(TileEntityTypes.n, CraftEndPortal.class, CraftEndPortal::new);
        CraftBlockStates.register(TileEntityTypes.a, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new);
        CraftBlockStates.register(TileEntityTypes.r, CraftHopper.class, CraftHopper::new);
        CraftBlockStates.register(TileEntityTypes.F, CraftJigsaw.class, CraftJigsaw::new);
        CraftBlockStates.register(TileEntityTypes.e, CraftJukebox.class, CraftJukebox::new);
        CraftBlockStates.register(TileEntityTypes.D, CraftLectern.class, CraftLectern::new);
        CraftBlockStates.register(TileEntityTypes.k, CraftMovingPiston.class, CraftMovingPiston::new);
        CraftBlockStates.register(TileEntityTypes.K, CraftSculkCatalyst.class, CraftSculkCatalyst::new);
        CraftBlockStates.register(TileEntityTypes.I, CraftSculkSensor.class, CraftSculkSensor::new);
        CraftBlockStates.register(TileEntityTypes.L, CraftSculkShrieker.class, CraftSculkShrieker::new);
        CraftBlockStates.register(TileEntityTypes.J, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new);
        CraftBlockStates.register(TileEntityTypes.B, CraftSmoker.class, CraftSmoker::new);
        CraftBlockStates.register(TileEntityTypes.j, CraftCreatureSpawner.class, CraftCreatureSpawner::new);
        CraftBlockStates.register(TileEntityTypes.u, CraftStructureBlock.class, CraftStructureBlock::new);
        CraftBlockStates.register(TileEntityTypes.N, CraftBrushableBlock.class, CraftBrushableBlock::new);
        CraftBlockStates.register(TileEntityTypes.c, CraftChest.class, CraftChest::new);
    }

    private static class BlockEntityStateFactory<T extends TileEntity, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<BlockPosition, IBlockData, T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
        }

        @Override
        public final B createBlockState(World world, BlockPosition blockPosition, IBlockData blockData, TileEntity tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(BlockPosition blockPosition, IBlockData blockData) {
            return (T)((TileEntity)this.tileEntityConstructor.apply(blockPosition, blockData));
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, BlockPosition var2, IBlockData var3, TileEntity var4);
    }
}

