/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.command;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommand;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.minecraft.commands.CommandListenerWrapper;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;

public class BukkitCommandWrapper
implements com.mojang.brigadier.Command<CommandListenerWrapper>,
Predicate<CommandListenerWrapper>,
SuggestionProvider<CommandListenerWrapper>,
BukkitBrigadierCommand<CommandListenerWrapper> {
    private final CraftServer server;
    private final Command command;

    public BukkitCommandWrapper(CraftServer server, Command command) {
        this.server = server;
        this.command = command;
    }

    public LiteralCommandNode<CommandListenerWrapper> register(CommandDispatcher<CommandListenerWrapper> dispatcher, String label) {
        LiteralCommandNode literal;
        RootCommandNode<CommandListenerWrapper> root = dispatcher.getRoot();
        LiteralCommandNode defaultNode = literal = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)label).requires((Predicate)this)).executes((com.mojang.brigadier.Command)this)).build();
        ArgumentCommandNode defaultArgs = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)this).executes((com.mojang.brigadier.Command)this)).build();
        literal.addChild((CommandNode)defaultArgs);
        CommandRegisteredEvent event = new CommandRegisteredEvent(label, (BukkitBrigadierCommand)this, this.command, root, literal, defaultArgs);
        if (!event.callEvent()) {
            return null;
        }
        literal = event.getLiteral();
        if (event.isRawCommand()) {
            defaultNode.clientNode = literal;
            literal = defaultNode;
        }
        root.addChild((CommandNode)literal);
        return literal;
    }

    @Override
    public boolean test(CommandListenerWrapper wrapper) {
        return this.command.testPermissionSilent(wrapper.getBukkitSender());
    }

    public int run(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
        CommandSender sender = ((CommandListenerWrapper)context.getSource()).getBukkitSender();
        try {
            return this.server.dispatchCommand(sender, context.getRange().get(context.getInput())) ? 1 : 0;
        }
        catch (CommandException ex) {
            sender.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            this.server.getLogger().log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandListenerWrapper> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        List<String> results = this.server.tabComplete(((CommandListenerWrapper)context.getSource()).getBukkitSender(), builder.getInput(), ((CommandListenerWrapper)context.getSource()).e(), ((CommandListenerWrapper)context.getSource()).d(), true);
        builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
        for (String s2 : results) {
            builder.suggest(s2);
        }
        return builder.buildFuture();
    }
}

