/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.animal.EntityFox;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, EntityFox entity) {
        super(server, entity);
    }

    @Override
    public EntityFox getHandle() {
        return (EntityFox)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftFox";
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().r().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().a(EntityFox.Type.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().bU();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().y(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().w();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().w(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().C(sleeping);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        UUID uuid = this.getHandle().aj().b(EntityFox.cd).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null) {
            Preconditions.checkState((boolean)this.getHandle().aj().b(EntityFox.ce).isEmpty(), (Object)"Must remove second trusted player first");
        }
        this.getHandle().aj().b(EntityFox.cd, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        UUID uuid = this.getHandle().aj().b(EntityFox.ce).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null) {
            Preconditions.checkState((boolean)this.getHandle().aj().b(EntityFox.cd).isPresent(), (Object)"Must add first trusted player first");
        }
        this.getHandle().aj().b(EntityFox.ce, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public boolean isFaceplanted() {
        return this.getHandle().fY();
    }

    public void setInterested(boolean interested) {
        this.getHandle().z(interested);
    }

    public boolean isInterested() {
        return this.getHandle().gh();
    }

    public void setLeaping(boolean leaping) {
        this.getHandle().x(leaping);
    }

    public boolean isLeaping() {
        return this.getHandle().ge();
    }

    public void setDefending(boolean defending) {
        this.getHandle().B(defending);
    }

    public boolean isDefending() {
        return this.getHandle().gk();
    }

    public void setFaceplanted(boolean faceplanted) {
        this.getHandle().A(faceplanted);
    }
}

