/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.BlockWorkbench;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.spigotmc.AsyncCatcher;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.fN());
        this.enderChest = new CraftInventory(entity.ga());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().fh() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().bR.g());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().bR.b(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().bR.broadcastCarriedItem();
        }
    }

    @Override
    public void setHurtDirection(float hurtDirection) {
        this.getHandle().ck = hurtDirection;
    }

    public boolean isDeeplySleeping() {
        return this.getHandle().fQ();
    }

    public int getSleepTicks() {
        return this.getHandle().cm;
    }

    public Location getPotentialBedLocation() {
        EntityPlayer handle = (EntityPlayer)this.getHandle();
        BlockPosition bed = handle.N();
        if (bed == null) {
            return null;
        }
        WorldServer worldServer = handle.d.a(handle.P());
        if (worldServer == null) {
            return null;
        }
        return new Location((World)worldServer.getWorld(), (double)bed.u(), (double)bed.v(), (double)bed.w());
    }

    public FishHook getFishHook() {
        if (this.getHandle().cj == null) {
            return null;
        }
        return (FishHook)this.getHandle().cj.getBukkitEntity();
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPosition blockposition = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().dI().a_(blockposition);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (IBlockData)iblockdata.a(BlockBed.b, true);
        this.getHandle().dI().a(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().a(true, setSpawnLocation);
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().fw().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().cv();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.fN());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        TileEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container formerContainer = this.getHandle().bR;
        ITileInventory iinventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            iinventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            iinventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof ITileInventory) {
            iinventory = (ITileInventory)((Object)craft.getInventory());
        }
        if (iinventory instanceof ITileInventory && iinventory instanceof TileEntity && !(te = (TileEntity)((Object)iinventory)).l()) {
            te.a(this.getHandle().dI());
        }
        Containers container = CraftContainer.getNotchInventoryType(inventory);
        if (iinventory instanceof ITileInventory) {
            this.getHandle().a(iinventory);
        } else {
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().bR == formerContainer) {
            return null;
        }
        this.getHandle().bR.checkReachable = false;
        return this.getHandle().bR.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, EntityPlayer player, Containers<?> windowType) {
        if (player.c == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        Container container = new CraftContainer(inventory, (EntityHuman)player, player.nextContainerCounter());
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        container = (Container)result.getSecond();
        if (container == null) {
            return;
        }
        Component adventure$title = container.getBukkitView().title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(container.getBukkitView().getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.eT()) {
            player.c.a(new PacketPlayOutOpenWindow(container.j, windowType, PaperAdventure.asVanilla(adventure$title)));
        }
        player.bR = container;
        player.a(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().a(((BlockWorkbench)Blocks.cA).b(null, this.getHandle().dI(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().bR.checkReachable = false;
        }
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        ITileInventory menuProvider = ((BlockEnchantmentTable)Blocks.fr).b(null, this.getHandle().dI(), pos);
        if (menuProvider == null) {
            if (!force) {
                return null;
            }
            menuProvider = new TileInventory((syncId, inventory, player) -> new ContainerEnchantTable(syncId, inventory, ContainerAccess.a(this.getHandle().dI(), pos)), IChatBaseComponent.c("container.enchant"));
        }
        this.getHandle().a(menuProvider);
        if (force) {
            this.getHandle().bR.checkReachable = false;
        }
        return this.getHandle().bR.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).c == null) {
            return;
        }
        if (this.getHandle().bR != this.getHandle().bQ) {
            ((EntityPlayer)this.getHandle()).c.handleContainerClose(new PacketPlayInCloseWindow(this.getHandle().bR.j), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        if ((container = (Container)result.getSecond()) == null) {
            return;
        }
        Containers windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        Component adventure$title = inventory.title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(inventory.getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.eT()) {
            player.c.a(new PacketPlayOutOpenWindow(container.j, windowType, PaperAdventure.asVanilla(adventure$title)));
        }
        player.bR = container;
        player.a(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        IChatBaseComponent name;
        IMerchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().H_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().gj().c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.f(this.getHandle());
        mcMerchant.a(this.getHandle(), name, level);
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openAnvil(Location location, boolean force) {
        return this.openInventory(location, force, Material.ANVIL);
    }

    public InventoryView openCartographyTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.CARTOGRAPHY_TABLE);
    }

    public InventoryView openGrindstone(Location location, boolean force) {
        return this.openInventory(location, force, Material.GRINDSTONE);
    }

    public InventoryView openLoom(Location location, boolean force) {
        return this.openInventory(location, force, Material.LOOM);
    }

    public InventoryView openSmithingTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.SMITHING_TABLE);
    }

    public InventoryView openStonecutter(Location location, boolean force) {
        return this.openInventory(location, force, Material.STONECUTTER);
    }

    private InventoryView openInventory(Location location, boolean force, Material material) {
        Object block;
        AsyncCatcher.catchOp("open" + material);
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != material) {
            return null;
        }
        if (material == Material.ANVIL) {
            block = Blocks.gS;
        } else if (material == Material.CARTOGRAPHY_TABLE) {
            block = Blocks.nX;
        } else if (material == Material.GRINDSTONE) {
            block = Blocks.nZ;
        } else if (material == Material.LOOM) {
            block = Blocks.nT;
        } else if (material == Material.SMITHING_TABLE) {
            block = Blocks.ob;
        } else if (material == Material.STONECUTTER) {
            block = Blocks.oc;
        } else {
            throw new IllegalArgumentException("Unsupported inventory type: " + material);
        }
        this.getHandle().a(block.b(null, this.getHandle().dI(), new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        this.getHandle().bR.checkReachable = !force;
        return this.getHandle().bR.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().closeContainer(InventoryCloseEvent.Reason.PLUGIN);
    }

    public void closeInventory(InventoryCloseEvent.Reason reason) {
        this.getHandle().closeContainer(reason);
    }

    public boolean isBlocking() {
        return this.getHandle().fp();
    }

    @Override
    public boolean isHandRaised() {
        return this.getHandle().fi();
    }

    public ItemStack getItemInUse() {
        net.minecraft.world.item.ItemStack item = this.getHandle().fk();
        return item.b() ? null : CraftItemStack.asCraftMirror(item);
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().ch;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().ch = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().fW();
    }

    public float getAttackCooldown() {
        return this.getHandle().A(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getHandle().gi().a(CraftMagicNumbers.getItem(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        ItemCooldown.Info cooldown = this.getHandle().gi().a.get(CraftMagicNumbers.getItem(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.b - this.getHandle().gi().b);
    }

    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().gi().a(CraftMagicNumbers.getItem(material), ticks);
    }

    public Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().ge().g() && (entity = this.getHandle().releaseLeftShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().gf().g() && (entity = this.getHandle().releaseRightShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<IRecipe<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        CraftingManager manager = this.getHandle().dI().n().aE();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<IRecipe<?>> recipe = manager.a(CraftNamespacedKey.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().ge().g()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().ge(), this.getHandle().dI());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().i(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        if (!this.getHandle().gf().g()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().gf(), this.getHandle().dI());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().j(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public void openSign(Sign sign, Side side) {
        CraftSign.openSign(sign, (CraftPlayer)this, side);
    }

    public boolean dropItem(boolean dropAll) {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityHuman;
        boolean success = player.a(dropAll);
        if (!success) {
            return false;
        }
        net.minecraft.world.entity.player.PlayerInventory inv = player.fN();
        OptionalInt optionalSlot = player.bR.b(inv, inv.l);
        optionalSlot.ifPresent(slot -> player.cW.a(player.bR, slot, inv.f()));
        return true;
    }

    public float getExhaustion() {
        return this.getHandle().fX().c;
    }

    public void setExhaustion(float value) {
        this.getHandle().fX().c = value;
    }

    public float getSaturation() {
        return this.getHandle().fX().b;
    }

    public void setSaturation(float value) {
        this.getHandle().fX().b = value;
    }

    public int getFoodLevel() {
        return this.getHandle().fX().a;
    }

    public void setFoodLevel(int value) {
        this.getHandle().fX().a = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().fX().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().fX().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().fX().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().fX().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().fX().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().fX().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().gm().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().a(Optional.empty());
        } else {
            this.getHandle().a(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        EntityFireworks fireworks = new EntityFireworks(this.getHandle().dI(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().dI().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }
}

