/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPig;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAnimals;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, EntityPig entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().i();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().bX.a(saddled);
    }

    public int getBoostTicks() {
        return this.getHandle().bX.f ? this.getHandle().bX.e() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().bX.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().bX.f ? this.getHandle().bX.g : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().bX.f) {
            return;
        }
        int max = this.getHandle().bX.e();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().bX.g = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    @Override
    public EntityPig getHandle() {
        return (EntityPig)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }
}

