/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.item.Item;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPiglinAbstract;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Piglin;
import org.bukkit.inventory.Inventory;

public class CraftPiglin
extends CraftPiglinAbstract
implements Piglin,
CraftRangedEntity<EntityPiglin> {
    public CraftPiglin(CraftServer server, EntityPiglin entity) {
        super(server, entity);
    }

    public boolean isAbleToHunt() {
        return this.getHandle().ck;
    }

    public void setIsAbleToHunt(boolean flag) {
        this.getHandle().ck = flag;
    }

    public boolean addBarterMaterial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftMagicNumbers.getItem(material);
        return this.getHandle().allowedBarterItems.add(item);
    }

    public boolean removeBarterMaterial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftMagicNumbers.getItem(material);
        return this.getHandle().allowedBarterItems.remove(item);
    }

    public boolean addMaterialOfInterest(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftMagicNumbers.getItem(material);
        return this.getHandle().interestItems.add(item);
    }

    public boolean removeMaterialOfInterest(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Item item = CraftMagicNumbers.getItem(material);
        return this.getHandle().interestItems.remove(item);
    }

    public Set<Material> getInterestList() {
        return Collections.unmodifiableSet(this.getHandle().interestItems.stream().map(CraftMagicNumbers::getMaterial).collect(Collectors.toSet()));
    }

    public Set<Material> getBarterList() {
        return Collections.unmodifiableSet(this.getHandle().allowedBarterItems.stream().map(CraftMagicNumbers::getMaterial).collect(Collectors.toSet()));
    }

    public Inventory getInventory() {
        return new CraftInventory(this.getHandle().cj);
    }

    @Override
    public EntityPiglin getHandle() {
        return (EntityPiglin)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftPiglin";
    }

    public void setChargingCrossbow(boolean chargingCrossbow) {
        this.getHandle().b(chargingCrossbow);
    }

    public boolean isChargingCrossbow() {
        return this.getHandle().gi();
    }

    public void setDancing(boolean dancing) {
        if (dancing) {
            this.getHandle().dK().a(MemoryModuleType.ai, true);
            this.getHandle().dK().a(MemoryModuleType.ah, this.getHandle().aF());
        } else {
            this.getHandle().dK().b(MemoryModuleType.ai);
            this.getHandle().dK().b(MemoryModuleType.ah);
        }
    }

    public void setDancing(long duration) {
        this.getHandle().dK().a(MemoryModuleType.ai, true, duration);
        this.getHandle().dK().a(MemoryModuleType.ah, this.getHandle().aF(), duration);
    }

    public boolean isDancing() {
        return this.getHandle().gg();
    }
}

