/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.monster.EntityVex;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Vex;

public class CraftVex
extends CraftMonster
implements Vex {
    public CraftVex(CraftServer server, EntityVex entity) {
        super(server, entity);
    }

    @Override
    public EntityVex getHandle() {
        return (EntityVex)super.getHandle();
    }

    public Mob getSummoner() {
        EntityInsentient owner = this.getHandle().r();
        return owner != null ? (Mob)owner.getBukkitEntity() : null;
    }

    public void setSummoner(Mob summoner) {
        this.getHandle().a(summoner == null ? null : ((CraftMob)summoner).getHandle());
    }

    public boolean hasLimitedLifetime() {
        return this.getHandle().bW;
    }

    public void setLimitedLifetime(boolean hasLimitedLifetime) {
        this.getHandle().bW = hasLimitedLifetime;
    }

    public int getLimitedLifetimeTicks() {
        return this.getHandle().bX;
    }

    public void setLimitedLifetimeTicks(int ticks) {
        this.getHandle().bX = ticks;
    }

    @Override
    public String toString() {
        return "CraftVex";
    }

    public boolean isCharging() {
        return this.getHandle().fY();
    }

    public void setCharging(boolean charging) {
        this.getHandle().w(charging);
    }

    public Location getBound() {
        BlockPosition blockPosition = this.getHandle().w();
        return blockPosition == null ? null : CraftLocation.toBukkit(blockPosition, this.getWorld());
    }

    public void setBound(Location location) {
        if (location == null) {
            this.getHandle().i((BlockPosition)null);
        } else {
            Preconditions.checkArgument((boolean)this.getWorld().equals(location.getWorld()), (Object)"The bound world cannot be different to the entity's world.");
            this.getHandle().i(CraftLocation.toBlockPosition(location));
        }
    }

    public int getLifeTicks() {
        return this.getHandle().bX;
    }

    public void setLifeTicks(int lifeTicks) {
        this.getHandle().b(lifeTicks);
        if (lifeTicks < 0) {
            this.getHandle().bW = false;
        }
    }

    public boolean hasLimitedLife() {
        return this.getHandle().bW;
    }
}

