/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.FireworkMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaFirework
extends CraftMetaItem
implements FireworkMeta {
    static final CraftMetaItem.ItemMetaKey FIREWORKS = new CraftMetaItem.ItemMetaKey("Fireworks");
    static final CraftMetaItem.ItemMetaKey FLIGHT = new CraftMetaItem.ItemMetaKey("Flight", "power");
    static final CraftMetaItem.ItemMetaKey EXPLOSIONS = new CraftMetaItem.ItemMetaKey("Explosions", "firework-effects");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_COLORS = new CraftMetaItem.ItemMetaKey("Colors");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_TYPE = new CraftMetaItem.ItemMetaKey("Type");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_TRAIL = new CraftMetaItem.ItemMetaKey("Trail");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_FLICKER = new CraftMetaItem.ItemMetaKey("Flicker");
    static final CraftMetaItem.ItemMetaKey EXPLOSION_FADE = new CraftMetaItem.ItemMetaKey("FadeColors");
    private List<FireworkEffect> effects;
    private Integer power;

    CraftMetaFirework(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaFirework)) {
            return;
        }
        CraftMetaFirework that = (CraftMetaFirework)meta;
        this.power = that.power;
        if (that.hasEffects()) {
            this.effects = new ArrayList<FireworkEffect>(that.effects);
        }
    }

    CraftMetaFirework(NBTTagCompound tag) {
        super(tag);
        if (!tag.e(CraftMetaFirework.FIREWORKS.NBT)) {
            return;
        }
        NBTTagCompound fireworks = tag.p(CraftMetaFirework.FIREWORKS.NBT);
        this.power = fireworks.f(CraftMetaFirework.FLIGHT.NBT);
        if (!fireworks.e(CraftMetaFirework.EXPLOSIONS.NBT)) {
            return;
        }
        NBTTagList fireworkEffects = fireworks.c(CraftMetaFirework.EXPLOSIONS.NBT, 10);
        this.effects = new ArrayList<FireworkEffect>(fireworkEffects.size());
        ArrayList<FireworkEffect> effects = this.effects;
        for (int i2 = 0; i2 < fireworkEffects.size(); ++i2) {
            try {
                effects.add(CraftMetaFirework.getEffect((NBTTagCompound)fireworkEffects.k(i2)));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static FireworkEffect getEffect(NBTTagCompound explosion) {
        FireworkEffect.Builder effect = FireworkEffect.builder().flicker(explosion.q(CraftMetaFirework.EXPLOSION_FLICKER.NBT)).trail(explosion.q(CraftMetaFirework.EXPLOSION_TRAIL.NBT)).with(CraftMetaFirework.getEffectType(0xFF & explosion.f(CraftMetaFirework.EXPLOSION_TYPE.NBT)));
        int[] colors = explosion.n(CraftMetaFirework.EXPLOSION_COLORS.NBT);
        if (colors.length == 0) {
            effect.withColor(Color.WHITE);
        }
        for (int color : colors) {
            effect.withColor(Color.fromRGB((int)color));
        }
        for (int color : explosion.n(CraftMetaFirework.EXPLOSION_FADE.NBT)) {
            effect.withFade(Color.fromRGB((int)color));
        }
        return effect.build();
    }

    static NBTTagCompound getExplosion(FireworkEffect effect) {
        NBTTagCompound explosion = new NBTTagCompound();
        if (effect.hasFlicker()) {
            explosion.a(CraftMetaFirework.EXPLOSION_FLICKER.NBT, true);
        }
        if (effect.hasTrail()) {
            explosion.a(CraftMetaFirework.EXPLOSION_TRAIL.NBT, true);
        }
        CraftMetaFirework.addColors(explosion, EXPLOSION_COLORS, effect.getColors());
        CraftMetaFirework.addColors(explosion, EXPLOSION_FADE, effect.getFadeColors());
        explosion.a(CraftMetaFirework.EXPLOSION_TYPE.NBT, (byte)CraftMetaFirework.getNBT(effect.getType()));
        return explosion;
    }

    public static int getNBT(FireworkEffect.Type type) {
        switch (type) {
            case BALL: {
                return 0;
            }
            case BALL_LARGE: {
                return 1;
            }
            case STAR: {
                return 2;
            }
            case CREEPER: {
                return 3;
            }
            case BURST: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + type);
    }

    static FireworkEffect.Type getEffectType(int nbt) {
        switch (nbt) {
            case 0: {
                return FireworkEffect.Type.BALL;
            }
            case 1: {
                return FireworkEffect.Type.BALL_LARGE;
            }
            case 2: {
                return FireworkEffect.Type.STAR;
            }
            case 3: {
                return FireworkEffect.Type.CREEPER;
            }
            case 4: {
                return FireworkEffect.Type.BURST;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + nbt);
    }

    CraftMetaFirework(Map<String, Object> map) {
        super(map);
        Integer power = CraftMetaItem.SerializableMeta.getObject(Integer.class, map, CraftMetaFirework.FLIGHT.BUKKIT, true);
        if (power != null) {
            this.power = power;
        }
        Iterable effects = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaFirework.EXPLOSIONS.BUKKIT, true);
        this.safelyAddEffects(effects);
    }

    public boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }

    void safelyAddEffects(Iterable<?> collection) {
        if (collection == null || collection instanceof Collection && ((Collection)collection).isEmpty()) {
            return;
        }
        List<FireworkEffect> effects = this.effects;
        if (effects == null) {
            effects = this.effects = new ArrayList<FireworkEffect>();
        }
        for (Object obj : collection) {
            Preconditions.checkArgument((boolean)(obj instanceof FireworkEffect), (String)"%s in %s is not a FireworkEffect", obj, collection);
            effects.add((FireworkEffect)obj);
        }
    }

    @Override
    void applyToItem(NBTTagCompound itemTag) {
        super.applyToItem(itemTag);
        if (this.isFireworkEmpty()) {
            return;
        }
        NBTTagCompound fireworks = itemTag.p(CraftMetaFirework.FIREWORKS.NBT);
        itemTag.a(CraftMetaFirework.FIREWORKS.NBT, fireworks);
        if (this.hasEffects()) {
            NBTTagList effects = new NBTTagList();
            for (FireworkEffect effect : this.effects) {
                effects.add(CraftMetaFirework.getExplosion(effect));
            }
            if (effects.size() > 0) {
                fireworks.a(CraftMetaFirework.EXPLOSIONS.NBT, effects);
            }
        }
        if (this.hasPower()) {
            fireworks.a(CraftMetaFirework.FLIGHT.NBT, this.power.byteValue());
        }
    }

    static void addColors(NBTTagCompound compound, CraftMetaItem.ItemMetaKey key, List<Color> colors) {
        if (colors.isEmpty()) {
            return;
        }
        int[] colorArray = new int[colors.size()];
        int i2 = 0;
        for (Color color : colors) {
            colorArray[i2++] = color.asRGB();
        }
        compound.a(key.NBT, colorArray);
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.FIREWORK_ROCKET;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isFireworkEmpty();
    }

    boolean isFireworkEmpty() {
        return !this.hasEffects() && !this.hasPower();
    }

    boolean hasPower() {
        return this.power != null && this.power != 0;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaFirework) {
            CraftMetaFirework that = (CraftMetaFirework)meta;
            return (this.hasPower() ? that.hasPower() && this.power == that.power : !that.hasPower()) && (this.hasEffects() ? that.hasEffects() && this.effects.equals(that.effects) : !that.hasEffects());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaFirework || this.isFireworkEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasPower()) {
            hash = 61 * hash + this.power;
        }
        if (this.hasEffects()) {
            hash = 61 * hash + 13 * this.effects.hashCode();
        }
        return hash != original ? CraftMetaFirework.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasEffects()) {
            builder.put((Object)CraftMetaFirework.EXPLOSIONS.BUKKIT, (Object)ImmutableList.copyOf(this.effects));
        }
        if (this.hasPower()) {
            builder.put((Object)CraftMetaFirework.FLIGHT.BUKKIT, (Object)this.power);
        }
        return builder;
    }

    @Override
    public CraftMetaFirework clone() {
        CraftMetaFirework meta = (CraftMetaFirework)super.clone();
        if (this.effects != null) {
            meta.effects = new ArrayList<FireworkEffect>(this.effects);
        }
        return meta;
    }

    public void addEffect(FireworkEffect effect) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"FireworkEffect cannot be null");
        if (this.effects == null) {
            this.effects = new ArrayList<FireworkEffect>();
        }
        this.effects.add(effect);
    }

    public void addEffects(FireworkEffect ... effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        if (effects.length == 0) {
            return;
        }
        List<FireworkEffect> list = this.effects;
        if (list == null) {
            list = this.effects = new ArrayList<FireworkEffect>();
        }
        for (FireworkEffect effect : effects) {
            Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"effects cannot contain null FireworkEffect");
            list.add(effect);
        }
    }

    public void addEffects(Iterable<FireworkEffect> effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        this.safelyAddEffects(effects);
    }

    public List<FireworkEffect> getEffects() {
        return this.effects == null ? ImmutableList.of() : ImmutableList.copyOf(this.effects);
    }

    public int getEffectsSize() {
        return this.effects == null ? 0 : this.effects.size();
    }

    public void removeEffect(int index) {
        if (this.effects == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }
        this.effects.remove(index);
    }

    public void clearEffects() {
        this.effects = null;
    }

    public int getPower() {
        return this.hasPower() ? this.power : 0;
    }

    public void setPower(int power) {
        Preconditions.checkArgument((power >= 0 ? 1 : 0) != 0, (String)"power cannot be less than zero: %s", (int)power);
        Preconditions.checkArgument((power < 128 ? 1 : 0) != 0, (String)"power cannot be more than 127: %s", (int)power);
        this.power = power;
    }
}

