/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory.util;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_20_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftTileInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract IInventory getTileEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(holder, type, this.getTileEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).a(PaperAdventure.asVanilla(title));
        }
        return this.getInventory(owner, type, te);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).a(CraftChatMessage.fromStringOrNull(title));
        }
        return this.getInventory(holder, type, te);
    }

    @Deprecated
    public Inventory getInventory(IInventory tileEntity) {
        return this.getInventory(null, null, tileEntity);
    }

    public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
        if (owner != null) {
            return new CraftInventoryCustom(owner, type, tileEntity);
        }
        return new CraftInventory(tileEntity);
    }

    public static class Smoker
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntitySmoker(BlockPosition.b, Blocks.nV.n());
        }
    }

    public static class Lectern
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityLectern((BlockPosition)BlockPosition.b, (IBlockData)Blocks.oa.n()).e;
        }
    }

    public static class BlastFurnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBlastFurnace(BlockPosition.b, Blocks.nW.n());
        }
    }

    public static class Hopper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityHopper(BlockPosition.b, Blocks.hc.n());
        }
    }

    public static class Dropper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDropper(BlockPosition.b, Blocks.hi.n());
        }
    }

    public static class Dispenser
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDispenser(BlockPosition.b, Blocks.aU.n());
        }
    }

    public static class BrewingStand
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBrewingStand(BlockPosition.b, Blocks.fs.n());
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityBrewingStand)tileEntity).a(PaperAdventure.asVanilla(title));
            }
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityBrewingStand)tileEntity).a(CraftChatMessage.fromStringOrNull(title));
            }
            return this.getInventory(holder, type, tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return this.getInventory(null, null, tileEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, tileEntity);
            }
            return new CraftInventoryBrewer(tileEntity);
        }
    }

    public static abstract class AbstractFurnaceInventoryConverter
    extends CraftTileInventoryConverter {
        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityFurnace)tileEntity).a(PaperAdventure.asVanilla(title));
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityFurnace)tileEntity).a(CraftChatMessage.fromStringOrNull(title));
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return this.getInventory(null, null, tileEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, tileEntity);
            }
            return new CraftInventoryFurnace((TileEntityFurnace)tileEntity);
        }
    }

    public static class Furnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            TileEntityFurnaceFurnace furnace = new TileEntityFurnaceFurnace(BlockPosition.b, Blocks.cD.n());
            return furnace;
        }
    }
}

