/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.scheduler.MinecraftInternalPlugin;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.BotInventoryContainer;
import top.leavesmc.leaves.bot.BotStatsCounter;
import top.leavesmc.leaves.bot.BotUtil;
import top.leavesmc.leaves.bot.MojangAPI;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.bot.agent.actions.StopAction;
import top.leavesmc.leaves.entity.Bot;
import top.leavesmc.leaves.entity.CraftBot;
import top.leavesmc.leaves.event.bot.BotCreateEvent;
import top.leavesmc.leaves.event.bot.BotJoinEvent;
import top.leavesmc.leaves.util.MathUtils;

public class ServerBot
extends EntityPlayer {
    private final Map<String, BotAction> actions;
    private final boolean removeOnDeath;
    private final int tracingRange;
    private Vec3D velocity;
    private int fireTicks;
    private int jumpTicks;
    private int noFallTicks;
    public boolean waterSwim;
    private Vec3D knockback;
    public BotCreateState createState;
    private final ServerStatisticManager stats;
    private final BotInventoryContainer container;
    private static final List<ServerBot> bots = new CopyOnWriteArrayList<ServerBot>();
    private static final Plugin MINECRAFT_PLUGIN = new MinecraftInternalPlugin();

    private ServerBot(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(server, world, profile);
        this.am.b(new DataWatcherObject<Integer>(16, DataWatcherRegistry.b), 255);
        this.am.b(EntityHuman.bL, (byte)-2);
        this.velocity = new Vec3D(this.bl, this.bm, this.bn);
        this.noFallTicks = 60;
        this.fireTicks = 0;
        this.actions = new HashMap<String, BotAction>();
        this.removeOnDeath = true;
        this.stats = new BotStatsCounter(server);
        this.container = new BotInventoryContainer(this);
        this.fauxSleeping = LeavesConfig.fakeplayerSkipSleep;
        this.waterSwim = true;
        this.knockback = Vec3D.b;
        this.tracingRange = world.spigotConfig.playerTrackingRange * world.spigotConfig.playerTrackingRange;
    }

    public static ServerBot createBot(@NotNull BotCreateState state) {
        if (!ServerBot.isCreateLegal(state.name)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        BotCreateEvent event = new BotCreateEvent(state.name, state.skinName, state.loc, ChatColor.YELLOW + state.name + " joined the game");
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        Location location = event.getCreateLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        CustomGameProfile profile = new CustomGameProfile(BotUtil.getBotUUID(state), state.name, state.skin);
        ServerBot bot = new ServerBot(server, world, profile);
        bot.c = new PlayerConnection(server, new NetworkManager(EnumProtocolDirection.b){

            @Override
            public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
            }
        }, bot);
        bot.isRealPlayer = true;
        bot.createState = state;
        if (event.getJoinMessage() != null) {
            Bukkit.broadcastMessage((String)event.getJoinMessage());
        }
        bot.b(location.getX(), location.getY(), location.getZ());
        bot.a(location.getYaw(), location.getPitch());
        bot.getBukkitEntity().setRotation(location.getYaw(), location.getPitch());
        world.addFreshEntity(bot, CreatureSpawnEvent.SpawnReason.COMMAND);
        bot.renderAll();
        server.ac().addNewBot(bot);
        bots.add(bot);
        BotJoinEvent event1 = new BotJoinEvent(bot.getBukkitPlayer());
        server.server.getPluginManager().callEvent((Event)event1);
        return bot;
    }

    public static boolean isCreateLegal(@NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            return false;
        }
        if (Bukkit.getPlayer((String)name) != null || ServerBot.getBot(name) != null) {
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            return false;
        }
        return ServerBot.getBots().size() < LeavesConfig.fakeplayerLimit;
    }

    public void renderAll() {
        MinecraftServer.getServer().ac().t().forEach(player -> {
            this.sendPlayerInfo((EntityPlayer)player);
            this.sendFakeData(player.c, false);
        });
    }

    public void sendPlayerInfo(EntityPlayer player) {
        player.c.a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.a, ClientboundPlayerInfoUpdatePacket.a.d, ClientboundPlayerInfoUpdatePacket.a.f), (Collection<EntityPlayer>)List.of(this)));
    }

    public boolean needSendFakeData(EntityPlayer player) {
        return LeavesConfig.alwaysSendFakeplayerData && player.dI() == this.dI() && player.dg().g(this.dg()) > (double)this.tracingRange;
    }

    public void sendFakeDataIfNeed(EntityPlayer player, boolean login) {
        if (this.needSendFakeData(player)) {
            this.sendFakeData(player.c, login);
        }
    }

    public void sendFakeData(ServerPlayerConnection playerConnection, boolean login) {
        playerConnection.a(new PacketPlayOutNamedEntitySpawn(this));
        if (login) {
            Bukkit.getScheduler().runTaskLater(MINECRAFT_PLUGIN, () -> this.c.a(new PacketPlayOutEntityHeadRotation(this, (byte)(this.dy() * 256.0f / 360.0f))), 10L);
        } else {
            this.c.a(new PacketPlayOutEntityHeadRotation(this, (byte)(this.dy() * 256.0f / 360.0f)));
        }
    }

    private void sendPacket(Packet<?> packet) {
        MinecraftServer.getServer().ac().t().forEach(player -> player.c.a(packet));
    }

    @Override
    public void a(@NotNull DamageSource damageSource) {
        super.a(damageSource);
        this.dieCheck();
    }

    private void dieCheck() {
        if (this.removeOnDeath) {
            bots.remove(this);
            this.d.ac().removeBot(this);
            this.a(Entity.RemovalReason.a);
            this.setDead();
            this.removeTab();
            Bukkit.broadcastMessage((String)(ChatColor.YELLOW + this.Z().getString() + " left the game"));
        }
    }

    private void removeTab() {
        this.sendPacket(new ClientboundPlayerInfoRemovePacket(List.of(this.ct())));
    }

    private void setDead() {
        this.sendPacket(new PacketPlayOutEntityDestroy(this.af()));
        this.bb = true;
        this.bQ.b(this);
        this.bR.b(this);
    }

    @Override
    @Nullable
    public Entity b(@NotNull WorldServer destination) {
        return null;
    }

    public Bot getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftBot getBukkitEntity() {
        return (CraftBot)super.getBukkitEntity();
    }

    @Override
    public boolean aV() {
        Location loc = this.getLocation();
        for (int i2 = 0; i2 <= 2; ++i2) {
            Material type = loc.getBlock().getType();
            if (type == Material.WATER || type == Material.LAVA) {
                return true;
            }
            loc.add(0.0, 0.9, 0.0);
        }
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.m();
        if (!this.bs()) {
            return;
        }
        if (this.fireTicks > 0) {
            --this.fireTicks;
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.noFallTicks > 0) {
            --this.noFallTicks;
        }
        if (this.bW > 0) {
            --this.bW;
        }
        this.updateLocation();
        this.fH();
        float health = this.er();
        float maxHealth = this.eI();
        float regenAmount = 0.01f;
        float amount = health < maxHealth - regenAmount ? health + regenAmount : maxHealth;
        this.t(amount);
        BlockPosition blockposition = this.aD();
        IBlockData iblockdata = this.dI().a_(blockposition);
        Vec3D vec3d1 = this.h(this.velocity);
        this.a(vec3d1.d, this.ay(), iblockdata, blockposition);
        ++this.aQ;
        if (this.er() > 0.0f) {
            AxisAlignedBB axisalignedbb = this.bM() && !this.cW().dD() ? this.cE().b(this.cW().cE()).c(1.0, 0.0, 1.0) : this.cE().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dI().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ae() == EntityTypes.J) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dD()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)SystemUtils.a(list1, this.af));
            }
        }
        Iterator<Map.Entry<String, BotAction>> iterator = this.actions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BotAction> entry = iterator.next();
            if (entry.getValue().isCancel()) {
                iterator.remove();
                continue;
            }
            entry.getValue().tryTick(this);
        }
    }

    private void touch(@NotNull Entity entity) {
        entity.b_(this);
    }

    @Override
    public void a(@NotNull EntityItem item) {
        super.a(item);
        this.updateItemInMainHand();
    }

    public void updateItemInMainHand() {
        this.tryReplenishOrReplaceInMainHand();
        this.z();
    }

    public void updateItemInOffHand() {
        this.tryReplenishOrReplaceInOffHand();
        this.z();
    }

    public void tryReplenishOrReplaceInOffHand() {
        ItemStack offhand = this.eP();
        if (!offhand.b()) {
            BotUtil.replenishment(offhand, this.fN().i);
            if (BotUtil.isDamage(offhand, 10)) {
                BotUtil.replaceTool(EnumItemSlot.b, this);
            }
        }
    }

    public void tryReplenishOrReplaceInMainHand() {
        ItemStack mainHand = this.eO();
        if (!mainHand.b()) {
            BotUtil.replenishment(mainHand, this.fN().i);
            if (BotUtil.isDamage(mainHand, 10)) {
                BotUtil.replaceTool(EnumItemSlot.a, this);
            }
        }
    }

    @Override
    public void a(double heightDifference, boolean onGround, @NotNull IBlockData state, @NotNull BlockPosition landedPosition) {
        if (onGround) {
            if (this.aa > 0.0f) {
                state.b().a(this.dI(), state, landedPosition, (Entity)this, this.aa);
                this.dI().a(GameEvent.B, this.dg(), GameEvent.a.a(this, this.aC.map(blockposition1 -> this.dI().a_((BlockPosition)blockposition1)).orElse(state)));
            }
            this.n();
        } else if (heightDifference < 0.0) {
            this.aa -= (float)heightDifference;
        }
    }

    @Override
    public void m() {
        if (this.aL > 0) {
            --this.aL;
        }
        this.ao();
        this.bo = (int)this.bn;
        this.bf = this.be;
        this.M = this.dy();
        this.N = this.dA();
    }

    public Location getLocation() {
        return this.getBukkitPlayer().getLocation();
    }

    @Override
    public void knockback(double strength, double x2, double z2, @NotNull Entity knockingBackEntity) {
        if ((strength *= 1.0 - this.b(GenericAttributes.c)) > 0.0) {
            this.at = true;
            Vec3D vec3d = this.dl();
            Vec3D vec3d1 = new Vec3D(x2, 0.0, z2).d().a(strength);
            this.knockback = new Vec3D(vec3d.c / 2.0 - vec3d1.c, this.ay() ? Math.min(0.4, vec3d.d / 2.0 + strength) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
        }
    }

    private void updateLocation() {
        this.velocity = new Vec3D(this.bl, this.bm, this.bn);
        if (this.waterSwim && this.aV()) {
            this.g(new Vec3D(0.0, 0.05, 0.0));
        }
        this.g(this.knockback);
        this.knockback = Vec3D.b;
        this.h(this.velocity);
    }

    public void faceLocation(@NotNull Location loc) {
        this.look(loc.toVector().subtract(this.getLocation().toVector()), false);
    }

    public void look(Vector dir, boolean keepYaw) {
        float pitch;
        float yaw;
        if (keepYaw) {
            yaw = this.cm();
            pitch = MathUtils.fetchPitch(dir);
        } else {
            float[] vals = MathUtils.fetchYawPitch(dir);
            yaw = vals[0];
            pitch = vals[1];
            this.sendPacket(new PacketPlayOutEntityHeadRotation(this, (byte)(yaw * 256.0f / 360.0f)));
        }
        this.a(yaw, pitch);
        this.getBukkitEntity().setRotation(yaw, pitch);
    }

    public void punch() {
        this.a(EnumHand.a);
    }

    @Override
    public void d(@NotNull Entity target) {
        super.d(target);
        this.punch();
    }

    @Override
    public void eW() {
        double jumpPower = (double)this.eU() + (double)this.eV();
        this.g(new Vec3D(0.0, jumpPower, 0.0));
    }

    public void dropAll() {
        this.fN().k();
        this.z();
    }

    public void setBotAction(BotAction action) {
        if (action instanceof StopAction) {
            this.actions.clear();
        }
        action.init();
        this.actions.put(action.getName(), action);
    }

    public Collection<BotAction> getBotActions() {
        return this.actions.values();
    }

    public BotAction getBotAction(String name) {
        return this.actions.get(name);
    }

    @Deprecated
    public BotAction getBotAction() {
        return null;
    }

    @Override
    @NotNull
    public ServerStatisticManager D() {
        return this.stats;
    }

    public BotInventoryContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public EnumInteractionResult a(@NotNull EntityHuman player, @NotNull EnumHand hand) {
        if (LeavesConfig.openFakeplayerInventory && player.eO().b()) {
            player.a(new TileInventory((i2, inventory, p2) -> ContainerChest.b(i2, inventory, this.container), this.H_()));
            return EnumInteractionResult.a;
        }
        return super.a(player, hand);
    }

    public static ServerBot getBot(EntityPlayer player) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (b2.af() != player.af()) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(String name) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (!b2.Z().getString().equals(name)) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(UUID uuid) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (b2.ax != uuid) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static void saveOrRemoveAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            bots.forEach(bot -> fakePlayerList.add(bot.createState.realName, (JsonElement)BotUtil.saveBot(bot)));
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        } else {
            ServerBot.removeAllBot();
        }
    }

    public static void loadAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                BotUtil.loadBot(entry);
            }
            file.delete();
        }
    }

    public static boolean removeAllBot() {
        for (ServerBot bot : bots) {
            bot.a(bot.dJ().m());
        }
        return true;
    }

    public static List<ServerBot> getBots() {
        return bots;
    }

    public static class BotCreateState {
        public Location loc;
        public String[] skin;
        public String skinName;
        private String realName;
        private String name;

        public BotCreateState() {
        }

        public BotCreateState(Location loc, String realName, String skinName) {
            this.loc = loc;
            this.skinName = skinName;
            this.setRealName(realName);
        }

        public BotCreateState(Location loc, String name, String realName, String skinName, String[] skin) {
            this.loc = loc;
            this.skinName = skinName;
            this.skin = skin;
            this.realName = realName;
            this.name = name;
        }

        public ServerBot createSync() {
            return ServerBot.createBot(this);
        }

        public void createAsync(Consumer<ServerBot> consumer) {
            Bukkit.getScheduler().runTaskAsynchronously(MINECRAFT_PLUGIN, () -> {
                if (this.skinName != null) {
                    this.skin = MojangAPI.getSkin(this.skinName);
                }
                Bukkit.getScheduler().runTask(MINECRAFT_PLUGIN, () -> {
                    ServerBot bot = ServerBot.createBot(this);
                    if (bot != null && consumer != null) {
                        consumer.accept(bot);
                    }
                });
            });
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRealName(String realName) {
            this.realName = realName;
            this.name = LeavesConfig.fakeplayerPrefix + realName + LeavesConfig.fakeplayerSuffix;
        }

        public String getName() {
            return this.name;
        }

        public String getRealName() {
            return this.realName;
        }
    }

    public static class CustomGameProfile
    extends GameProfile {
        public CustomGameProfile(UUID uuid, String name, String[] skin) {
            super(uuid, name);
            this.setSkin(skin);
        }

        public void setSkin(String[] skin) {
            if (skin != null) {
                this.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
            }
        }
    }
}

