/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.command.CommandArgument;
import top.leavesmc.leaves.command.CommandArgumentResult;
import top.leavesmc.leaves.command.CommandArgumentType;

public class BreakBlockAction
extends BotAction {
    private int delay = 0;
    private int nowDelay = 0;
    private BlockPosition lastPos = null;
    private int destroyProgressTime = 0;
    private int lastSentState = -1;

    public BreakBlockAction() {
        super("break", new CommandArgument(CommandArgumentType.INTEGER, CommandArgumentType.INTEGER));
        this.setTabComplete(0, List.of("[TickDelay]"));
        this.setTabComplete(1, List.of("[DoNumber]"));
    }

    @Override
    public BotAction getNew(@NotNull EntityPlayer player, @NotNull CommandArgumentResult result) {
        return new BreakBlockAction().setTickDelay(result.readInt(20)).setNumber(result.readInt(-1));
    }

    @Override
    public BotAction setTickDelay(int tickDelay) {
        super.setTickDelay(0);
        this.delay = tickDelay;
        return this;
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        if (this.nowDelay > 0) {
            --this.nowDelay;
            return false;
        }
        Block block = bot.getBukkitEntity().getTargetBlockExact(5);
        if (block != null) {
            IBlockData iblockdata;
            BlockPosition pos = ((CraftBlock)block).getPosition();
            if (this.lastPos == null || !this.lastPos.equals(pos)) {
                this.lastPos = pos;
                this.destroyProgressTime = 0;
                this.lastSentState = -1;
            }
            if (!(iblockdata = bot.dI().a_(pos)).i()) {
                bot.punch();
                if (iblockdata.a(bot, bot.dI(), pos) >= 1.0f) {
                    bot.e.a(pos, 0, "insta mine");
                    bot.dI().a(bot.af(), pos, -1);
                    bot.updateItemInMainHand();
                    this.finalBreak();
                    return true;
                }
                float damage = this.incrementDestroyProgress(bot, iblockdata, pos);
                if (damage >= 1.0f) {
                    bot.e.a(pos, 0, "destroyed");
                    bot.dI().a(bot.af(), pos, -1);
                    bot.updateItemInMainHand();
                    this.finalBreak();
                    return true;
                }
            }
        }
        return false;
    }

    private void finalBreak() {
        this.lastPos = null;
        this.destroyProgressTime = 0;
        this.lastSentState = -1;
        this.nowDelay = this.delay;
    }

    private float incrementDestroyProgress(ServerBot bot, @NotNull IBlockData state, BlockPosition pos) {
        float f2 = state.a(bot, bot.dI(), pos) * (float)(++this.destroyProgressTime);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.lastSentState) {
            bot.dI().a(bot.af(), pos, k2);
            this.lastSentState = k2;
        }
        return f2;
    }
}

