/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.command.subcommands;

import io.papermc.paper.command.CommandUtil;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.command.CommandSender;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.command.LeavesSubcommand;
import top.leavesmc.leaves.util.TickStatus;

public class TickCommand
implements LeavesSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        if (!LeavesConfig.tickCommand) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Tick Status: ", (TextColor)NamedTextColor.GRAY), this.getStatus().getMessage()}));
            return true;
        }
        TickStatus oldStatus = this.getStatus();
        switch (args[0]) {
            case "warp": {
                MinecraftServer.tickStatus = TickStatus.WARP;
                sender.sendMessage(this.getStatusChangeMessage(oldStatus));
                break;
            }
            case "freeze": {
                MinecraftServer.tickStatus = TickStatus.FREEZE;
                sender.sendMessage(this.getStatusChangeMessage(oldStatus));
                break;
            }
            case "normal": {
                MinecraftServer.tickStatus = TickStatus.NORMAL;
                sender.sendMessage(this.getStatusChangeMessage(oldStatus));
            }
        }
        return true;
    }

    public Component getStatusChangeMessage(TickStatus old) {
        return Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Tick Status: ", (TextColor)NamedTextColor.GRAY), old.getMessage(), Component.text((String)" -> ", (TextColor)NamedTextColor.GRAY), this.getStatus().getMessage()});
    }

    public TickStatus getStatus() {
        return MinecraftServer.tickStatus;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        if (!LeavesConfig.tickCommand) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandUtil.getListMatchingLast(sender, args, "normal", "warp", "freeze");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean tabCompletes() {
        return LeavesConfig.tickCommand;
    }
}

