/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.entity;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.bot.agent.actions.CraftCustomBotAction;
import top.leavesmc.leaves.entity.Bot;
import top.leavesmc.leaves.entity.BotManager;
import top.leavesmc.leaves.entity.CraftBot;
import top.leavesmc.leaves.entity.botaction.CustomBotAction;

public class CraftBotManager
implements BotManager {
    private final Collection<Bot> botViews = Collections.unmodifiableList(Lists.transform(ServerBot.getBots(), (Function)new Function<ServerBot, CraftBot>(){

        public CraftBot apply(ServerBot bot) {
            return bot.getBukkitEntity();
        }
    }));

    @Nullable
    public Bot getBot(@NotNull UUID uuid) {
        return ServerBot.getBot(uuid).getBukkitPlayer();
    }

    @Nullable
    public Bot getBot(@NotNull String name) {
        return ServerBot.getBot(name).getBukkitPlayer();
    }

    @Nullable
    public Bot createBot(@NotNull String name, @NotNull String realName, @Nullable String[] skin, @Nullable String skinName, @NotNull Location location) {
        ServerBot bot = new ServerBot.BotCreateState(location, name, realName, skinName, skin).createSync();
        if (bot != null) {
            return bot.getBukkitPlayer();
        }
        return null;
    }

    public void createBot(@NotNull String name, @Nullable String skinName, @NotNull Location location, Consumer<Bot> consumer) {
        new ServerBot.BotCreateState(location, name, skinName).createAsync(serverBot -> consumer.accept((Object)serverBot.getBukkitPlayer()));
    }

    public void removeBot(@NotNull String name) {
        ServerBot bot = ServerBot.getBot(name);
        if (bot != null) {
            bot.a(bot.dJ().m());
        }
    }

    public void removeBot(@NotNull UUID uuid) {
        ServerBot bot = ServerBot.getBot(uuid);
        if (bot != null) {
            bot.a(bot.dJ().m());
        }
    }

    public void removeAllBots() {
        ServerBot.removeAllBot();
    }

    public void saveOrRemoveAllBots() {
        ServerBot.saveOrRemoveAllBot();
    }

    public Collection<Bot> getBots() {
        return this.botViews;
    }

    public boolean registerCustomBotAction(String name, CustomBotAction action) {
        return Actions.register(new CraftCustomBotAction(name, action));
    }

    public boolean unregisterCustomBotAction(String name) {
        return Actions.unregister(name);
    }
}

