/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.lithium.common.util.collections;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.function.Predicate;
import net.minecraft.util.MathHelper;

public final class Object2BooleanCacheTable<T> {
    private final int mask;
    private final Node<T>[] nodes;
    private final Predicate<T> operator;

    public Object2BooleanCacheTable(int capacity, Predicate<T> operator) {
        int capacity1 = MathHelper.c(capacity);
        this.mask = capacity1 - 1;
        this.nodes = new Node[capacity1];
        this.operator = operator;
    }

    private static <T> int hash(T key) {
        return HashCommon.mix((int)key.hashCode());
    }

    public boolean get(T key) {
        int idx = Object2BooleanCacheTable.hash(key) & this.mask;
        Node<T> node = this.nodes[idx];
        if (node != null && key.equals(node.key)) {
            return node.value;
        }
        boolean test = this.operator.test(key);
        this.nodes[idx] = new Node<T>(key, test);
        return test;
    }

    static class Node<T> {
        final T key;
        final boolean value;

        Node(T key, boolean value) {
            this.key = key;
            this.value = value;
        }
    }
}

