/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ProtocolUtils;

public class BBORProtocol {
    public static final String PROTOCOL_ID = "bbor";
    private static final MinecraftKey INITIALIZE_CLIENT = BBORProtocol.id("initialize");
    private static final MinecraftKey ADD_BOUNDING_BOX = BBORProtocol.id("add_bounding_box_v2");
    private static final MinecraftKey STRUCTURE_LIST_SYNC = BBORProtocol.id("structure_list_sync_v1");
    public static final MinecraftKey SUBSCRIBE = BBORProtocol.id("subscribe");
    private static final Map<Integer, EntityPlayer> players = new ConcurrentHashMap<Integer, EntityPlayer>();
    private static final Map<Integer, Set<BBoundingBox>> playerBoundingBoxesCache = new HashMap<Integer, Set<BBoundingBox>>();
    private static final Map<MinecraftKey, Map<BBoundingBox, Set<BBoundingBox>>> dimensionCache = new ConcurrentHashMap<MinecraftKey, Map<BBoundingBox, Set<BBoundingBox>>>();
    private static final WorldServer OVERWORLD = MinecraftServer.getServer().D();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void onPlayerLoggedIn(@NotNull EntityPlayer player) {
        if (LeavesConfig.bborProtocol) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.writeLong(OVERWORLD.A());
            buf.writeInt(BBORProtocol.OVERWORLD.A.a());
            buf.writeInt(BBORProtocol.OVERWORLD.A.c());
            ProtocolUtils.sendPayloadPacket(player, INITIALIZE_CLIENT, buf);
            IRegistry<Structure> structureRegistry = player.d.aV().d(Registries.az);
            Set<String> structureIds = structureRegistry.g().stream().map(e2 -> ((ResourceKey)e2.getKey()).a().toString()).collect(Collectors.toSet());
            PacketDataSerializer buf1 = new PacketDataSerializer(Unpooled.buffer());
            buf1.d(structureIds.size());
            structureIds.forEach(buf1::a);
            ProtocolUtils.sendPayloadPacket(player, STRUCTURE_LIST_SYNC, buf1);
        }
    }

    public static void onPlayerSubscribed(@NotNull EntityPlayer player) {
        if (LeavesConfig.bborProtocol) {
            players.put(player.af(), player);
            BBORProtocol.sendBoundingToPlayer(player.af(), player);
        }
    }

    public static void onDataPackReload() {
        if (LeavesConfig.bborProtocol) {
            for (Map.Entry<Integer, EntityPlayer> playerEntry : players.entrySet()) {
                IRegistry<Structure> structureRegistry = MinecraftServer.getServer().aV().d(Registries.az);
                Set<String> structureIds = structureRegistry.g().stream().map(e2 -> ((ResourceKey)e2.getKey()).a().toString()).collect(Collectors.toSet());
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.d(structureIds.size());
                structureIds.forEach(buf::a);
                ProtocolUtils.sendPayloadPacket(playerEntry.getValue(), STRUCTURE_LIST_SYNC, buf);
            }
        }
    }

    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.bborProtocol) {
            players.remove(player.af());
            playerBoundingBoxesCache.remove(player.af());
        }
    }

    public static void onChunkLoaded(@NotNull Chunk chunk) {
        if (LeavesConfig.bborProtocol) {
            HashMap<String, StructureStart> structures = new HashMap<String, StructureStart>();
            IRegistry<Structure> structureFeatureRegistry = chunk.F().B_().d(Registries.az);
            for (Map.Entry<Structure, StructureStart> es : chunk.g().entrySet()) {
                Optional<ResourceKey<Structure>> optional = structureFeatureRegistry.c(es.getKey());
                optional.ifPresent(key -> structures.put(key.a().toString(), (StructureStart)es.getValue()));
            }
            if (structures.size() > 0) {
                BBORProtocol.onStructuresLoaded(chunk.F().ac().a(), structures);
            }
        }
    }

    public static void onStructuresLoaded(@NotNull MinecraftKey dimensionID, @NotNull Map<String, StructureStart> structures) {
        Map<BBoundingBox, Set<BBoundingBox>> cache = BBORProtocol.getOrCreateCache(dimensionID);
        for (Map.Entry<String, StructureStart> entry : structures.entrySet()) {
            StructureStart structureStart = entry.getValue();
            if (structureStart == null) {
                return;
            }
            String type = "structure:" + entry.getKey();
            StructureBoundingBox bb = structureStart.a();
            BBoundingBox boundingBox = BBORProtocol.buildStructure(bb, type);
            if (cache.containsKey(boundingBox)) {
                return;
            }
            HashSet<BBoundingBox> structureBoundingBoxes = new HashSet<BBoundingBox>();
            for (StructurePiece structureComponent : structureStart.i()) {
                structureBoundingBoxes.add(BBORProtocol.buildStructure(structureComponent.f(), type));
            }
            cache.put(boundingBox, structureBoundingBoxes);
        }
    }

    @NotNull
    private static BBoundingBox buildStructure(@NotNull StructureBoundingBox bb, String type) {
        BlockPosition min = new BlockPosition(bb.g(), bb.h(), bb.i());
        BlockPosition max = new BlockPosition(bb.j(), bb.k(), bb.l());
        return new BBoundingBox(type, min, max);
    }

    private static void sendBoundingToPlayer(int id, EntityPlayer player) {
        for (Map.Entry<MinecraftKey, Map<BBoundingBox, Set<BBoundingBox>>> entry : dimensionCache.entrySet()) {
            if (entry.getValue() == null) {
                return;
            }
            Set playerBoundingBoxes = playerBoundingBoxesCache.computeIfAbsent(id, k2 -> new HashSet());
            Map<BBoundingBox, Set<BBoundingBox>> boundingBoxMap = entry.getValue();
            for (BBoundingBox key : boundingBoxMap.keySet()) {
                if (playerBoundingBoxes.contains(key)) continue;
                Set<BBoundingBox> boundingBoxes = boundingBoxMap.get(key);
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.a(entry.getKey());
                key.serialize(buf);
                if (boundingBoxes != null && boundingBoxes.size() > 1) {
                    for (BBoundingBox box : boundingBoxes) {
                        box.serialize(buf);
                    }
                }
                ProtocolUtils.sendPayloadPacket(player, ADD_BOUNDING_BOX, buf);
                playerBoundingBoxes.add(key);
            }
        }
    }

    public static void tick() {
        if (LeavesConfig.bborProtocol) {
            for (Map.Entry<Integer, EntityPlayer> playerEntry : players.entrySet()) {
                BBORProtocol.sendBoundingToPlayer(playerEntry.getKey(), playerEntry.getValue());
            }
        }
    }

    public static void initAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            BBORProtocol.onPlayerLoggedIn(player);
        }
    }

    public static void loggedOutAllPlayer() {
        players.clear();
        playerBoundingBoxesCache.clear();
        for (Map<BBoundingBox, Set<BBoundingBox>> cache : dimensionCache.values()) {
            cache.clear();
        }
        dimensionCache.clear();
    }

    private static Map<BBoundingBox, Set<BBoundingBox>> getOrCreateCache(MinecraftKey dimensionId) {
        return dimensionCache.computeIfAbsent(dimensionId, dt -> new ConcurrentHashMap());
    }

    private record BBoundingBox(String type, BlockPosition min, BlockPosition max) {
        public void serialize(@NotNull PacketDataSerializer buf) {
            buf.writeChar(83);
            buf.writeInt(this.type.hashCode());
            buf.d(this.min.u()).d(this.min.v()).d(this.min.w());
            buf.d(this.max.u()).d(this.max.v()).d(this.max.w());
        }

        @Override
        public int hashCode() {
            return BBoundingBox.combineHashCodes(this.min.hashCode(), this.max.hashCode());
        }

        private static int combineHashCodes(int ... hashCodes) {
            int prime = 31;
            int result = 0;
            for (int hashCode : hashCodes) {
                result = 31 * result + hashCode;
            }
            return result;
        }
    }
}

