/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.util.ProtocolUtils;

public class CarpetServerProtocol {
    public static final String PROTOCOL_ID = "carpet";
    private static final MinecraftKey HELLO_ID = CarpetServerProtocol.id("hello");
    private static final int HI = 69;
    private static final int HELLO = 420;
    private static final int DATA = 1;

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void handlePacket(EntityPlayer player, @NotNull PacketPlayInCustomPayload packet) {
        PacketDataSerializer data;
        if (packet.c.equals(HELLO_ID) && (data = packet.d).m() == 420) {
            CarpetServerProtocol.handleHello(player, data);
        }
    }

    private static void handleHello(@NotNull EntityPlayer player, @NotNull PacketDataSerializer data) {
        LeavesLogger.LOGGER.info("Player " + player.cv() + " joined with carpet " + data.e(64));
        ProtocolUtils.sendPayloadPacket(player, HELLO_ID, CarpetRules.buildBuf());
    }

    public static void onPlayerJoin(EntityPlayer player) {
        if (LeavesConfig.leavesCarpetSupport) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.d(69).a("leaves-carpet-1.0.0");
            ProtocolUtils.sendPayloadPacket(player, HELLO_ID, buf);
        }
    }

    public static class CarpetRules {
        private static final Map<String, CarpetRule> rules = new HashMap<String, CarpetRule>();

        @NotNull
        public static PacketDataSerializer buildBuf() {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.d(1);
            NBTTagCompound rulesNbt = new NBTTagCompound();
            rules.values().forEach(rule -> rule.writeNBT(rulesNbt));
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("Rules", rulesNbt);
            buf.a(tag);
            return buf;
        }

        public static void register(CarpetRule rule) {
            rules.put(rule.name, rule);
        }
    }

    public record CarpetRule(String identifier, String name, String value) {
        @NotNull
        @Contract(value="_, _, _ -> new")
        public static CarpetRule of(String identifier, String name, boolean value) {
            return new CarpetRule(identifier, name, Boolean.toString(value));
        }

        public void writeNBT(@NotNull NBTTagCompound rules) {
            NBTTagCompound rule = new NBTTagCompound();
            rule.a("Value", this.value);
            rule.a("Manager", this.identifier);
            rule.a("Rule", this.name);
            rules.a(this.name, rule);
        }
    }
}

